/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon;

import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class PixelmonMethods {
    public static ArrayList<EntityPixelmon> getAllActivePokemon(EntityPlayer player) {
        ArrayList<EntityPixelmon> list = new ArrayList<EntityPixelmon>(6);
        Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage((EntityPlayerMP)player);
        if (optstorage.isPresent()) {
            PlayerStorage storage = optstorage.get();
            for (NBTTagCompound nbt : storage.getList()) {
                int[] id;
                Optional<EntityPixelmon> pixelmonOptional;
                if (nbt == null || !(pixelmonOptional = storage.getAlreadyExists(id = PixelmonMethods.getID(nbt), player.field_70170_p)).isPresent()) continue;
                list.add(pixelmonOptional.get());
            }
        }
        return list;
    }

    public static int[] getID(NBTTagCompound nbt) {
        return new int[]{nbt.func_74762_e("pixelmonID1"), nbt.func_74762_e("pixelmonID2")};
    }

    public static boolean isIDSame(NBTTagCompound nbt, EntityPixelmon entity) {
        return PixelmonMethods.isIDSame(PixelmonMethods.getID(nbt), entity.getPokemonId());
    }

    public static boolean isIDSame(NBTTagCompound nbt, PixelmonWrapper pw) {
        return PixelmonMethods.isIDSame(PixelmonMethods.getID(nbt), pw.getPokemonID());
    }

    public static boolean isIDSame(int[] id1, int[] id2) {
        if (id1 == null || id2 == null) {
            return false;
        }
        return (id1.length == 2 || id1.length == id2.length) && id1[0] == id2[0] && id1[1] == id2[1];
    }

    public static boolean isIDSame(NBTTagCompound nbt, int[] id) {
        return PixelmonMethods.isIDSame(PixelmonMethods.getID(nbt), id);
    }

    public static boolean isIDSame(EntityPixelmon e, int[] id) {
        return PixelmonMethods.isIDSame(e.getPokemonId(), id);
    }

    public static boolean isIDSame(int[] id, EntityPixelmon e) {
        return PixelmonMethods.isIDSame(e.getPokemonId(), id);
    }

    public static boolean isIDSame(int[] id, PokemonLink e) {
        return PixelmonMethods.isIDSame(e.getPokemonID(), id);
    }

    public static boolean isIDSame(EntityPixelmon e1, EntityPixelmon e2) {
        return PixelmonMethods.isIDSame(e1.getPokemonId(), e2.getPokemonId());
    }

    public static boolean isIDSame(PixelmonWrapper e1, PixelmonWrapper e2) {
        return PixelmonMethods.isIDSame(e1.getPokemonID(), e2.getPokemonID());
    }

    public static boolean isIDSame(PixelmonWrapper e1, int[] id2) {
        return PixelmonMethods.isIDSame(e1.getPokemonID(), id2);
    }

    public static boolean isIDSame(int[] id1, PixelmonWrapper e2) {
        return PixelmonMethods.isIDSame(id1, e2.getPokemonID());
    }

    public static void toBytesUUID(ByteBuf buf, UUID uuid) {
        buf.writeLong(uuid.getMostSignificantBits());
        buf.writeLong(uuid.getLeastSignificantBits());
    }

    public static UUID fromBytesUUID(ByteBuf buf) {
        return new UUID(buf.readLong(), buf.readLong());
    }

    public static void toBytesPokemonID(ByteBuf buf, int[] pokemonID) {
        buf.writeInt(pokemonID[0]);
        buf.writeInt(pokemonID[1]);
    }

    public static int[] fromBytesPokemonID(ByteBuf buf) {
        return new int[]{buf.readInt(), buf.readInt()};
    }

    public static void changeForm(int newForm, EntityLivingBase owner, Optional<NBTTagCompound> nbt, Optional<EntityPixelmon> pokemon) {
        if (pokemon.isPresent()) {
            pokemon.get().setForm(newForm, true);
        } else {
            EntityPixelmon entity = (EntityPixelmon)PixelmonEntityList.createEntityFromNBT(nbt.get(), owner.field_70170_p);
            entity.setForm(newForm, true);
        }
    }
}

