/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.command;

import com.google.common.collect.ImmutableList;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.commands.DeregisterSubcommandEvent;
import com.pixelmonmod.pixelmon.api.events.commands.ExecutePixelmonCommandEvent;
import com.pixelmonmod.pixelmon.api.events.commands.RegisterSubcommandEvent;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerComputerStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import com.pixelmonmod.pixelmon.util.PixelmonPlayerUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class PixelmonCommand
extends CommandBase {
    private ArrayList<PixelmonCommand> subcommands = new ArrayList();

    protected abstract void execute(ICommandSender var1, String[] var2) throws CommandException;

    public PixelmonCommand(PixelmonCommand ... subcommands) {
        for (PixelmonCommand subcommand : subcommands) {
            this.subcommands.add(subcommand);
        }
    }

    @Nullable
    public static PixelmonCommand getParentCommand(PixelmonCommand subcommand) {
        for (ICommand command : FMLCommonHandler.instance().getMinecraftServerInstance().field_71321_q.func_71555_a().values()) {
            if (!(command instanceof PixelmonCommand) || !((PixelmonCommand)command).subcommands.contains((Object)subcommand)) continue;
            return (PixelmonCommand)command;
        }
        return null;
    }

    public final void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        ExecutePixelmonCommandEvent event;
        PixelmonCommand targetCommand = this;
        if (args.length > 0) {
            String arg0 = args[0];
            block0: for (PixelmonCommand subcommand : this.subcommands) {
                ArrayList<String> aliases = new ArrayList<String>(subcommand.func_71514_a());
                aliases.add(subcommand.func_71517_b());
                for (String alias : aliases) {
                    if (!alias.equalsIgnoreCase(arg0)) continue;
                    targetCommand = subcommand;
                    String[] newArgs = new String[args.length - 1];
                    for (int i = 1; i < args.length; ++i) {
                        newArgs[i - 1] = args[i];
                    }
                    args = newArgs;
                    break block0;
                }
            }
        }
        if (!Pixelmon.EVENT_BUS.post((Event)(event = new ExecutePixelmonCommandEvent(sender, targetCommand, args)))) {
            event.getCommand().execute(event.sender, event.getArgs());
        }
    }

    public ImmutableList<PixelmonCommand> getSubcommands() {
        return ImmutableList.copyOf(this.subcommands);
    }

    public void registerSubcommand(PixelmonCommand subcommand) {
        if (!Pixelmon.EVENT_BUS.post((Event)new RegisterSubcommandEvent(this, subcommand))) {
            this.subcommands.add(subcommand);
        }
    }

    public void deregisterSubcommand(String name) {
        for (PixelmonCommand subcommand : this.subcommands) {
            if (!subcommand.func_71517_b().equalsIgnoreCase(name)) continue;
            this.deregisterSubcommand(subcommand);
        }
    }

    public void deregisterSubcommand(PixelmonCommand subcommand) {
        if (!Pixelmon.EVENT_BUS.post((Event)new DeregisterSubcommandEvent(this, subcommand))) {
            this.subcommands.remove((Object)subcommand);
        }
    }

    @Nullable
    public EntityPlayerMP getPlayer(String name) {
        return PixelmonPlayerUtils.getUniquePlayerStartingWith(name);
    }

    @Nullable
    public EntityPlayerMP getPlayer(ICommandSender sender, String name) {
        return PixelmonPlayerUtils.getUniquePlayerStartingWith(name, sender);
    }

    @Nullable
    public PlayerStorage getPlayerStorage(EntityPlayerMP player) {
        return PixelmonStorage.pokeBallManager.getPlayerStorage(player).orElse(null);
    }

    @Nullable
    public PlayerComputerStorage getComputerStorage(EntityPlayerMP player) {
        return PixelmonStorage.computerManager.getPlayerStorage(player);
    }

    public MinecraftServer getServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance();
    }

    public List<String> tabCompleteUsernames(String[] args) {
        return PixelmonCommand.func_71530_a((String[])args, (String[])this.getServer().func_71213_z());
    }

    public List<String> tabCompletePokemon(String[] args) {
        return PixelmonCommand.func_175762_a((String[])args, EnumPokemon.getNameList());
    }

    public void sendMessage(ICommandSender sender, TextFormatting color, String string, Object ... data) {
        TextComponentTranslation text = new TextComponentTranslation(string, data);
        text.func_150256_b().func_150238_a(color);
        sender.func_145747_a((ITextComponent)text);
    }

    public void sendMessage(ICommandSender sender, String string, Object ... data) {
        this.sendMessage(sender, TextFormatting.GRAY, string, data);
    }
}

