/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.SpawnSet;
import com.pixelmonmod.pixelmon.api.spawning.util.SpatialData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public abstract class AbstractSpawner {
    public final ArrayList<UUID> spawned = new ArrayList();
    public volatile boolean isBusy = false;
    public long lastSpawnTime;
    public final ArrayList<SpawnSet> spawnSets = new ArrayList();

    public boolean shouldDoSpawning() {
        return !this.isBusy;
    }

    public ArrayList<SpawnInfo> getSuitableSpawns(SpawnLocation spawnLocation) {
        ArrayList<SpawnInfo> suitableSpawns = new ArrayList<SpawnInfo>();
        for (SpawnSet set : this.spawnSets) {
            suitableSpawns.addAll(set.suitableSpawnsFor(this, spawnLocation));
        }
        return suitableSpawns;
    }

    @Nullable
    public SpawnInfo getWeightedSpawnInfo(SpawnLocation spawnLocation) {
        ArrayList<SpawnInfo> suitableSpawns = this.getSuitableSpawns(spawnLocation);
        return suitableSpawns.isEmpty() ? null : this.choose(spawnLocation, suitableSpawns);
    }

    public SpawnInfo choose(SpawnLocation spawnLocation, ArrayList<SpawnInfo> spawnInfos) {
        SpawnInfo spawnInfo;
        if (spawnInfos.isEmpty()) {
            return null;
        }
        if (spawnInfos.size() == 1) {
            return spawnInfos.get(0);
        }
        HashMap<SpawnInfo, Float> finalRarities = new HashMap<SpawnInfo, Float>();
        float raritySum = 0.0f;
        for (SpawnInfo spawnInfo2 : spawnInfos) {
            float rarity = spawnInfo2.getAdjustedRarity(spawnLocation);
            finalRarities.put(spawnInfo2, Float.valueOf(rarity));
            raritySum += rarity;
        }
        if (raritySum == 0.0f) {
            return null;
        }
        float selected = RandomHelper.getRandomNumberBetween(0.0f, raritySum);
        raritySum = 0.0f;
        Iterator<SpawnInfo> var9 = spawnInfos.iterator();
        do {
            if (var9.hasNext()) continue;
            Pixelmon.LOGGER.log(Level.WARN, "Unable to choose a SpawnInfo based on rarities. This shouldn't be possible.");
            return null;
        } while ((raritySum += ((Float)finalRarities.get(spawnInfo = var9.next())).floatValue()) < selected || ((Float)finalRarities.get(spawnInfo)).floatValue() == 0.0f);
        return spawnInfo;
    }

    public SpatialData calculateSpatialData(World world, BlockPos centre, int max, boolean includeDownwards, Predicate<Block> condition) {
        int z;
        int y;
        int xMul;
        int yOffset;
        int xOffset;
        int[] nArray;
        IBlockState state = world.func_180495_p(centre);
        if (!condition.test(state.func_177230_c())) {
            return new SpatialData(0, world.func_180495_p(centre.func_177977_b()).func_177230_c(), Lists.newArrayList((Object[])new Block[]{state.func_177230_c()}));
        }
        int r = 1;
        int[] xs = new int[]{-1, 1};
        if (includeDownwards) {
            int[] nArray2 = new int[2];
            nArray2[0] = -1;
            nArray = nArray2;
            nArray2[1] = 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 1;
        }
        int[] ys = nArray;
        int[] zs = new int[]{-1, 1};
        int radius = r;
        block0: while (radius <= max) {
            int[] var12 = xs;
            xOffset = xs.length;
            for (yOffset = 0; yOffset < xOffset; ++yOffset) {
                xMul = var12[yOffset];
                int[] var16 = zs;
                y = zs.length;
                for (z = 0; z < y; ++z) {
                    int zMul = var16[z];
                    int[] var20 = ys;
                    int var21 = ys.length;
                    for (int var22 = 0; var22 < var21; ++var22) {
                        int yMul = var20[var22];
                        state = world.func_180495_p(centre.func_177982_a(xMul * r, yMul * r, zMul * r));
                        if (condition.test(state.func_177230_c())) continue;
                        r = radius;
                        break block0;
                    }
                }
            }
            r = radius++;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, 0, 0);
        ArrayList<Block> uniqueSurroundingBlocks = new ArrayList<Block>();
        for (xOffset = -r; xOffset <= r; ++xOffset) {
            for (yOffset = -r; yOffset <= r; ++yOffset) {
                for (xMul = -r; xMul <= r; ++xMul) {
                    int x = xOffset + centre.func_177958_n();
                    Block block = world.func_180495_p((BlockPos)pos.func_181079_c(x, y = yOffset + centre.func_177956_o(), z = xMul + centre.func_177952_p())).func_177230_c();
                    if (uniqueSurroundingBlocks.contains(block)) continue;
                    uniqueSurroundingBlocks.add(block);
                }
            }
        }
        return new SpatialData(r, world.func_180495_p(centre.func_177977_b()).func_177230_c(), uniqueSurroundingBlocks);
    }

    public static class SpawnerBuilder<T extends AbstractSpawner> {
        protected ArrayList<SpawnSet> spawnSets = new ArrayList();

        public SpawnerBuilder addSpawnSets(SpawnSet ... spawnSets) {
            SpawnSet[] var2 = spawnSets;
            int var3 = spawnSets.length;
            for (int var4 = 0; var4 < var3; ++var4) {
                SpawnSet spawnSet = var2[var4];
                this.spawnSets.add(spawnSet);
            }
            return this;
        }

        public SpawnerBuilder addSpawnSets(Collection<SpawnSet> spawnSets) {
            this.spawnSets.addAll(spawnSets);
            return this;
        }

        public SpawnerBuilder setSpawnSets(SpawnSet ... spawnSets) {
            this.spawnSets.clear();
            return this.addSpawnSets(spawnSets);
        }

        public SpawnerBuilder setSpawnSets(Collection<SpawnSet> spawnSets) {
            this.spawnSets.clear();
            this.addSpawnSets(spawnSets);
            return this;
        }

        public T apply(T spawner) {
            ((AbstractSpawner)spawner).spawnSets.clear();
            ((AbstractSpawner)spawner).spawnSets.addAll(this.spawnSets);
            return spawner;
        }
    }
}

