/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.spawning.SpawnEvent;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.config.BetterSpawnerConfig;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class SpawnAction<T extends Entity> {
    public SpawnInfo spawnInfo;
    public SpawnLocation spawnLocation;
    protected T entity;

    public SpawnAction(SpawnInfo spawnInfo, SpawnLocation spawnLocation) {
        this.spawnInfo = spawnInfo;
        this.spawnLocation = spawnLocation;
    }

    protected abstract T createEntity();

    public T getOrCreateEntity() {
        if (this.entity == null) {
            this.entity = this.createEntity();
        }
        return this.entity;
    }

    public void setEntity(T t) {
        if (t != null) {
            this.entity = t;
        }
    }

    @Nullable
    public T doSpawn(AbstractSpawner spawner) {
        this.getOrCreateEntity();
        if (this.spawnInfo.interval != null && !BetterSpawnerConfig.checkInterval(this.spawnInfo.interval)) {
            return null;
        }
        SpawnEvent spawnEvent = new SpawnEvent(spawner, this);
        if (Pixelmon.EVENT_BUS.post((Event)spawnEvent)) {
            return null;
        }
        this.entity.func_70107_b((double)this.spawnLocation.location.pos.func_177958_n() + 0.5, (double)this.spawnLocation.location.pos.func_177956_o(), (double)this.spawnLocation.location.pos.func_177952_p() + 0.5);
        this.spawnLocation.location.world.func_72838_d(this.entity);
        spawner.spawned.add(this.entity.func_110124_au());
        spawner.lastSpawnTime = System.currentTimeMillis();
        if (this.spawnInfo.interval != null) {
            BetterSpawnerConfig.consumeInterval(this.spawnInfo.interval);
        }
        return this.entity;
    }
}

