/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnActionPokemon;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import java.util.Optional;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;

public class SpawnInfoPokemon
extends SpawnInfo {
    public static final String TYPE_ID_POKEMON = "pokemon";
    private PokemonSpec spec = PokemonSpec.from("Psyduck");
    public int minLevel = 1;
    public int maxLevel = 100;
    public Float spawnSpecificShinyRate = null;

    public SpawnInfoPokemon() {
        super(TYPE_ID_POKEMON);
    }

    @Override
    public void onImport() {
        this.calculateRequiredSpace();
        super.onImport();
        if (this.minLevel > this.maxLevel) {
            Pixelmon.LOGGER.warn("A SpawnInfo for " + this.spec.name + " has minLevel=" + this.minLevel + " and maxLevel=" + this.maxLevel + " which is weird. Fixing.");
            int temp = this.minLevel;
            this.minLevel = this.maxLevel;
            this.maxLevel = temp;
        }
    }

    public void setPokemon(PokemonSpec spec) {
        this.spec = spec;
        this.calculateRequiredSpace();
    }

    public void calculateRequiredSpace() {
        Optional<BaseStats> optBaseStats;
        if (this.spec.name != null && this.requiredSpace == -1 && (optBaseStats = EntityPixelmon.getBaseStats(this.spec.name)).isPresent()) {
            BaseStats baseStats = optBaseStats.get();
            this.requiredSpace = (int)Math.ceil(baseStats.length > baseStats.height ? (double)baseStats.length : (double)baseStats.height);
        }
    }

    public SpawnAction<EntityPixelmon> construct(AbstractSpawner spawner, SpawnLocation spawnLocation) {
        PokemonSpec spec = this.spec.copy();
        if (spec.name == null) {
            spec.name = EnumPokemon.Psyduck.name;
        }
        if (spec.level == null) {
            if (PixelmonConfig.spawnLevelsByDistance) {
                BlockPos spawnPos = spawnLocation.location.world.func_175694_M();
                double distanceFromSpawn = spawnPos.func_185332_f(spawnLocation.location.pos.func_177958_n(), spawnLocation.location.pos.func_177956_o(), spawnLocation.location.pos.func_177952_p());
                int levelBase = (int)(distanceFromSpawn / (double)PixelmonConfig.distancePerLevel) + 1;
                if (levelBase > PixelmonConfig.maxLevelByDistance) {
                    levelBase = PixelmonConfig.maxLevelByDistance;
                }
                int variation = RandomHelper.getRandomNumberBetween(-5, 5);
                spec.level = MathHelper.func_76125_a((int)(levelBase + variation), (int)1, (int)PixelmonConfig.maxLevelByDistance);
            } else {
                spec.level = RandomHelper.getRandomNumberBetween(this.minLevel, this.maxLevel);
            }
        }
        if (spec.shiny == null) {
            if (this.spawnSpecificShinyRate != null) {
                if (this.spawnSpecificShinyRate.floatValue() == 0.0f) {
                    spec.shiny = false;
                } else if (this.spawnSpecificShinyRate.floatValue() > 0.0f) {
                    spec.shiny = RandomHelper.getRandomChance(1.0f / this.spawnSpecificShinyRate.floatValue());
                }
            } else if (this.set.setSpecificShinyRate != null) {
                if (this.set.setSpecificShinyRate.floatValue() == 0.0f) {
                    spec.shiny = false;
                } else if (this.set.setSpecificShinyRate.floatValue() > 0.0f) {
                    spec.shiny = RandomHelper.getRandomChance(1.0f / this.set.setSpecificShinyRate.floatValue());
                }
            } else {
                spec.shiny = PixelmonConfig.shinyRate > 0.0f ? Boolean.valueOf(RandomHelper.getRandomChance(1.0f / PixelmonConfig.shinyRate)) : Boolean.valueOf(false);
            }
        }
        return new SpawnActionPokemon(this, spawnLocation, spec);
    }

    public PokemonSpec getPokemonSpec() {
        return this.spec;
    }

    @Override
    public String toString() {
        if (this.spec.name == null || this.spec.name.equals("random")) {
            return "Random";
        }
        return I18n.func_74838_a((String)("pixelmon." + this.spec.name.toLowerCase() + ".name"));
    }
}

