/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles;

import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.Spectator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class BattleRegistry {
    private static int battleIndex = 0;
    private static final Map<Integer, BattleControllerBase> battleIDMap = new HashMap<Integer, BattleControllerBase>();
    private static final Map<String, BattleControllerBase> battleNameMap = new HashMap<String, BattleControllerBase>();
    private static final List<BattleControllerBase> battleList = new ArrayList<BattleControllerBase>();

    public static boolean hasBattle() {
        return !battleIDMap.isEmpty();
    }

    public static void registerBattle(BattleControllerBase bc) {
        bc.battleIndex = battleIndex++;
        battleIDMap.put(bc.battleIndex, bc);
        battleList.add(bc);
        for (PlayerParticipant p : bc.getPlayers()) {
            battleNameMap.put(p.getDisplayName(), bc);
        }
    }

    public static BattleControllerBase getBattle(int index) {
        return battleIDMap.get(index);
    }

    public static BattleControllerBase getBattle(EntityPlayer player) {
        return player == null ? null : battleNameMap.get(player.getDisplayNameString());
    }

    public static BattleControllerBase getBattleExcludeSpectate(EntityPlayer player) {
        BattleControllerBase bc = BattleRegistry.getBattle(player);
        if (bc == null) {
            return null;
        }
        return bc.hasSpectator(player) ? null : bc;
    }

    public static BattleControllerBase getBattle(String playerName) {
        return battleNameMap.get(playerName);
    }

    public static BattleControllerBase getSpectatedBattle(EntityPlayer player) {
        return battleNameMap.get(player.getDisplayNameString());
    }

    public static void registerSpectator(Spectator spectator, BattleControllerBase bc) {
        battleNameMap.put(spectator.getEntity().getDisplayNameString(), bc);
    }

    public static void unregisterSpectator(Spectator spectator) {
        battleNameMap.remove(spectator.getEntity().getDisplayNameString());
    }

    public static boolean removeSpectator(EntityPlayerMP player) {
        BattleControllerBase battle = battleNameMap.get(player.getDisplayNameString());
        if (battle != null) {
            return battle.removeSpectator(player);
        }
        return false;
    }

    public static void deRegisterBattle(BattleControllerBase bc) {
        if (bc != null) {
            battleIDMap.remove(bc.battleIndex);
            battleList.remove(bc);
            for (PlayerParticipant p : bc.getPlayers()) {
                battleNameMap.remove(p.getDisplayName());
            }
            for (Spectator s : bc.spectators) {
                battleNameMap.remove(s.getEntity().getDisplayNameString());
            }
        }
    }

    public static void updateBattles() {
        int size = battleList.size();
        for (int i = 0; i < size; ++i) {
            battleList.get(i).update();
            int currentSize = battleList.size();
            if (currentSize >= size) continue;
            size = currentSize;
            --i;
        }
    }

    @Deprecated
    public static int getIndex(BattleControllerBase bc) {
        return bc.battleIndex;
    }
}

