/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.attacks.TargetingInfo;
import com.pixelmonmod.pixelmon.battles.attacks.animations.IAttackAnimation;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.StatsEffect;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.attackModifiers.AttackModifierBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.attackModifiers.CriticalHit;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.attackModifiers.MultipleHit;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.Assurance;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.BeatUp;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.Fling;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.TripleKick;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.multiTurn.MultiTurnCharge;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.multiTurn.MultiTurnSpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.log.MoveResults;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.rules.clauses.SkyBattle;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.database.AttackCategory;
import com.pixelmonmod.pixelmon.database.DatabaseMoves;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AngerPoint;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.KeenEye;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Overcoat;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.ParentalBond;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Sniper;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.SuperLuck;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Unaware;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.enums.EnumType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.text.translation.I18n;

public class Attack {
    public static final float EFFECTIVE_NORMAL = 1.0f;
    public static final float EFFECTIVE_SUPER = 2.0f;
    public static final float EFFECTIVE_MAX = 4.0f;
    public static final float EFFECTIVE_NOT = 0.5f;
    public static final float EFFECTIVE_BARELY = 0.25f;
    public static final float EFFECTIVE_NONE = 0.0f;
    public static final int ATTACK_PHYSICAL = 0;
    public static final int ATTACK_SPECIAL = 1;
    public static final int ATTACK_STATUS = 2;
    public static final int NEVER_MISS = -1;
    public static final int IGNORE_SEMIINVULNERABLE = -2;
    private static final int NUM_ATTACKS = 650;
    private static AttackBase[] fullAttackList;
    private static Map<String, AttackBase> fullAttackMap;
    public AttackBase baseAttack;
    public int pp;
    public int ppBase;
    public int movePower;
    public int moveAccuracy;
    public boolean cantMiss;
    private boolean disabled;
    public MoveResults moveResult;
    public float damageResult;
    public int savedPower;
    public int savedAccuracy;
    public EnumType savedType;
    static AttackCategory[] categories;

    public Attack(int attackIndex, String moveName, ResultSet rs) throws SQLException {
        Attack.initializeAllAttacks();
        AttackBase base = fullAttackList[attackIndex];
        if (base == null) {
            Pixelmon.LOGGER.error("No attack found with name: " + moveName);
        }
        this.initializeAttack(base);
    }

    public Attack(AttackBase base) {
        this.initializeAttack(base);
    }

    public Attack(int attackIndex) {
        Attack.initializeAllAttacks();
        try {
            this.initializeAttack(fullAttackList[attackIndex]);
        }
        catch (IndexOutOfBoundsException | NullPointerException e) {
            Pixelmon.LOGGER.error("No attack found for index " + attackIndex);
        }
    }

    public Attack(String moveName) {
        Attack.initializeAllAttacks();
        if (Attack.hasAttack(moveName)) {
            this.initializeAttack(Attack.getAttackBase(moveName).get());
        } else {
            Pixelmon.LOGGER.error("No attack found with name: " + moveName);
        }
    }

    public static Optional<AttackBase> getAttackBase(String moveName) {
        if (Attack.hasAttack(moveName)) {
            return Optional.of(fullAttackMap.get(moveName.toLowerCase()));
        }
        return Optional.empty();
    }

    public void initializeAttack(AttackBase base) {
        this.baseAttack = base;
        this.movePower = this.baseAttack.basePower;
        this.pp = this.baseAttack.ppBase;
        this.ppBase = this.baseAttack.ppBase;
        fullAttackMap.put(base.getLocalizedName(), base);
    }

    public static boolean hasAttack(int attackIndex) {
        Attack.initializeAllAttacks();
        return fullAttackList[attackIndex] != null;
    }

    public static boolean hasAttack(String moveName) {
        Attack.initializeAllAttacks();
        return fullAttackMap.containsKey(moveName.toLowerCase());
    }

    public static AttackBase[] getAttacks(String[] nameList) {
        Attack.initializeAllAttacks();
        AttackBase[] attacks = new AttackBase[nameList.length];
        for (int i = 0; i < nameList.length; ++i) {
            attacks[i] = fullAttackMap.get(nameList[i].toLowerCase());
            if (attacks[i] != null) continue;
            Pixelmon.LOGGER.error("No attack found with name: " + nameList[i]);
        }
        return attacks;
    }

    private static void initializeAllAttacks() {
        if (fullAttackList == null) {
            fullAttackList = new AttackBase[650];
            fullAttackMap = new HashMap<String, AttackBase>(1300);
            DatabaseMoves.initializeAllAttacks();
        }
    }

    public static void registerAttack(int attackIndex, String moveName, ResultSet rs) throws SQLException {
        if (fullAttackList[attackIndex] == null) {
            AttackBase a;
            Attack.fullAttackList[attackIndex] = a = new AttackBase(attackIndex, moveName, rs);
            fullAttackMap.put(moveName.toLowerCase(), a);
            fullAttackMap.put(a.getLocalizedName().toLowerCase(), a);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean use(PixelmonWrapper user, PixelmonWrapper target, MoveResults moveResults) {
        block59: {
            void var14_51;
            boolean shouldNotLosePP;
            block61: {
                EffectBase critModifier;
                AbilityBase userAbility;
                block60: {
                    int n;
                    Object opponents;
                    this.moveResult = moveResults;
                    this.damageResult = -1.0f;
                    if (user.bc == null || target.bc == null) break block59;
                    if (!this.checkSkyBattle(user.bc)) {
                        user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
                        moveResults.result = AttackResult.failed;
                        return false;
                    }
                    userAbility = user.getBattleAbility();
                    AbilityBase targetAbility = target.getBattleAbility();
                    if (!this.canHit(user, target) && !this.canHitNoTarget()) {
                        moveResults.result = AttackResult.notarget;
                        return true;
                    }
                    if (user == target) {
                        for (PixelmonWrapper pixelmonWrapper : user.bc.getActiveUnfaintedPokemon()) {
                            for (StatusBase status : pixelmonWrapper.getStatuses()) {
                                if (!status.stopsSelfStatusMove(pixelmonWrapper, user, this)) continue;
                                moveResults.result = AttackResult.failed;
                                return true;
                            }
                        }
                        this.applySelfStatusMove(user, moveResults);
                        return true;
                    }
                    if (user.targets.size() == 1 && ((ArrayList)(opponents = user.bc.getOpponentPokemon(user.getParticipant()))).size() > 1) {
                        Iterator iterator = ((ArrayList)opponents).iterator();
                        while (iterator.hasNext()) {
                            PixelmonWrapper pw = (PixelmonWrapper)iterator.next();
                            if (pw == target) continue;
                            for (StatusBase statusBase : pw.getStatuses()) {
                                if (!statusBase.redirectAttack(user, pw, this)) continue;
                                target = pw;
                                break;
                            }
                            if (!pw.getBattleAbility().redirectAttack(user, pw, this)) continue;
                            target = pw;
                            break;
                        }
                    }
                    for (EffectBase effectBase : this.baseAttack.effects) {
                        try {
                            if (effectBase.applyEffectStart(user, target) == AttackResult.proceed) continue;
                            return true;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    int[] modifiedMoveStats = new int[]{this.baseAttack.basePower, this.baseAttack.accuracy};
                    modifiedMoveStats = userAbility.modifyPowerAndAccuracyUser(this.baseAttack.basePower, this.baseAttack.accuracy, user, target, this);
                    for (PixelmonWrapper teammate : user.bc.getTeamPokemon(user)) {
                        modifiedMoveStats = teammate.getBattleAbility().modifyPowerAndAccuracyTeammate(modifiedMoveStats[0], modifiedMoveStats[1], user, target, this);
                    }
                    modifiedMoveStats = targetAbility.modifyPowerAndAccuracyTarget(modifiedMoveStats[0], modifiedMoveStats[1], user, target, this);
                    boolean bl = false;
                    if (modifiedMoveStats[1] < 0) {
                        n = modifiedMoveStats[1];
                    }
                    modifiedMoveStats = user.getUsableHeldItem().modifyPowerAndAccuracyUser(modifiedMoveStats, user, target, this);
                    modifiedMoveStats = target.getUsableHeldItem().modifyPowerAndAccuracyTarget(modifiedMoveStats, user, target, this);
                    int beforeSize = user.getStatuses().size();
                    for (int i = 0; i < beforeSize; ++i) {
                        StatusBase statusBase = user.getStatus(i);
                        modifiedMoveStats = statusBase.modifyPowerAndAccuracyUser(modifiedMoveStats[0], modifiedMoveStats[1], user, target, this);
                        if (user.getStatuses().size() != beforeSize) break;
                    }
                    for (StatusBase statusBase : target.getStatuses()) {
                        modifiedMoveStats = statusBase.modifyPowerAndAccuracyTarget(modifiedMoveStats[0], modifiedMoveStats[1], user, target, this);
                    }
                    for (StatusBase statusBase : user.bc.globalStatusController.getGlobalStatuses()) {
                        modifiedMoveStats = statusBase.modifyPowerAndAccuracyTarget(modifiedMoveStats[0], modifiedMoveStats[1], user, target, this);
                    }
                    if (n < 0 && modifiedMoveStats[1] >= 0) {
                        modifiedMoveStats[1] = n;
                    }
                    this.movePower = modifiedMoveStats[0];
                    this.moveAccuracy = Math.min(modifiedMoveStats[1], 100);
                    this.cantMiss = false;
                    if (user.pokemon != null && target.pokemon != null) {
                        user.pokemon.func_70671_ap().func_75651_a((Entity)target.pokemon, 0.0f, 0.0f);
                    }
                    double accuracy = this.moveAccuracy;
                    if (this.moveAccuracy >= 0) {
                        double combinedAccuracy;
                        int evasion = target.getBattleStats().getEvasionStage();
                        if (user.bc.globalStatusController.hasStatus(StatusType.Gravity)) {
                            evasion = Math.max(-6, evasion - 2);
                        }
                        if (user.getBattleAbility() instanceof KeenEye) {
                            evasion = Math.min(0, evasion);
                        }
                        if ((combinedAccuracy = (double)(user.getBattleStats().getAccuracyStage() - evasion)) > 6.0) {
                            combinedAccuracy = 6.0;
                        } else if (combinedAccuracy < -6.0) {
                            combinedAccuracy = -6.0;
                        }
                        accuracy = (double)this.moveAccuracy * ((double)user.getBattleStats().GetAccOrEva(combinedAccuracy) / 100.0);
                    }
                    ArrayList allStatuses = (ArrayList)target.getStatuses().stream().collect(Collectors.toList());
                    allStatuses.addAll(target.bc.globalStatusController.getGlobalStatuses().stream().collect(Collectors.toList()));
                    shouldNotLosePP = false;
                    for (int i = 0; i < this.baseAttack.effects.size(); ++i) {
                        EffectBase effectBase = this.baseAttack.effects.get(i);
                        if (!(effectBase instanceof MultiTurnSpecialAttackBase)) continue;
                        shouldNotLosePP = ((MultiTurnSpecialAttackBase)effectBase).shouldNotLosePP(user);
                    }
                    for (StatusBase statusBase : user.getStatuses()) {
                        try {
                            if (!statusBase.stopsIncomingAttackUser(target, user)) continue;
                            return !shouldNotLosePP;
                        }
                        catch (Exception exc) {
                            user.bc.battleLog.onCrash(exc, "Error calculating stopsIncomingAttack for " + statusBase.type.toString() + " for attack " + this.baseAttack.getLocalizedName());
                        }
                    }
                    for (StatusBase statusBase : allStatuses) {
                        try {
                            if (!statusBase.stopsIncomingAttack(target, user)) continue;
                            this.onMiss(user, target, moveResults, statusBase);
                            return !shouldNotLosePP;
                        }
                        catch (Exception exc) {
                            user.bc.battleLog.onCrash(exc, "Error calculating stopsIncomingAttack for " + statusBase.type.toString() + " for attack " + this.baseAttack.getLocalizedName());
                        }
                    }
                    if (!target.getBattleAbility(user).allowsIncomingAttack(target, user, this) || !target.getUsableHeldItem().allowsIncomingAttack(target, user, this)) {
                        try {
                            this.onMiss(user, target, moveResults, targetAbility);
                            return !shouldNotLosePP;
                        }
                        catch (Exception var27) {
                            user.bc.battleLog.onCrash(var27, "Error calculating allowsIncomingAttack for attack " + this.baseAttack.getLocalizedName());
                        }
                    }
                    if (this.hasNoEffect(user, target)) {
                        user.bc.sendToAll("pixelmon.battletext.noeffect", target.getNickname());
                        this.onMiss(user, target, moveResults, (Object)EnumType.Mystery);
                        return !shouldNotLosePP;
                    }
                    if (!shouldNotLosePP) {
                        targetAbility.preProcessAttack(target, user, this);
                    }
                    boolean bl2 = this.cantMiss = this.cantMiss(user) || this.moveAccuracy < 0;
                    if (user.bc.simulateMode) {
                        this.moveResult.accuracy = this.moveAccuracy;
                        accuracy = 100.0;
                    }
                    critModifier = null;
                    if (this.cantMiss || RandomHelper.getRandomChance((int)accuracy)) break block60;
                    this.onMiss(user, target, moveResults, null);
                    break block61;
                }
                AttackResult attackResult = AttackResult.proceed;
                AttackResult applyEffectResult = AttackResult.proceed;
                for (EffectBase e : this.baseAttack.effects) {
                    try {
                        void var14_44;
                        block64: {
                            block62: {
                                block63: {
                                    if (!(e instanceof AttackModifierBase)) break block62;
                                    if (!(e instanceof CriticalHit)) break block63;
                                    critModifier = e;
                                    break block64;
                                }
                                applyEffectResult = ((AttackModifierBase)e).applyEffectDuring(user, target);
                                if (applyEffectResult == AttackResult.proceed) break block64;
                                AttackResult attackResult2 = applyEffectResult;
                                break block64;
                            }
                            if (e instanceof SpecialAttackBase) {
                                applyEffectResult = ((SpecialAttackBase)e).applyEffectDuring(user, target);
                                if (applyEffectResult != AttackResult.proceed) {
                                    AttackResult attackResult3 = applyEffectResult;
                                }
                            } else if (e instanceof MultiTurnSpecialAttackBase && (applyEffectResult = ((MultiTurnSpecialAttackBase)e).applyEffectDuring(user, target)) != AttackResult.proceed) {
                                AttackResult attackResult4 = applyEffectResult;
                                break;
                            }
                        }
                        if (var14_44 == AttackResult.succeeded || var14_44 == AttackResult.failed || var14_44 == AttackResult.charging || var14_44 == AttackResult.notarget) {
                            moveResults.result = var14_44;
                            continue;
                        }
                        if (var14_44 != AttackResult.hit) continue;
                        if (target.isAlive()) {
                            moveResults.result = AttackResult.hit;
                            continue;
                        }
                        moveResults.result = AttackResult.killed;
                    }
                    catch (Exception exc) {
                        user.bc.battleLog.onCrash(exc, "Error in applyEffect for " + e.getClass().toString() + " for attack " + this.baseAttack.getLocalizedName());
                    }
                }
                if (applyEffectResult == AttackResult.proceed) {
                    if (userAbility instanceof ParentalBond) {
                        user.inMultipleHit = true;
                        user.inParentalBond = true;
                        for (EffectBase e : this.baseAttack.effects) {
                            if (e instanceof BeatUp || e instanceof Fling || e instanceof MultiTurnCharge || e instanceof MultipleHit || e instanceof TripleKick) {
                                user.inParentalBond = false;
                                continue;
                            }
                            if (!(e instanceof Assurance)) continue;
                            this.baseAttack.basePower *= 2;
                        }
                    }
                    this.executeAttackEffects(user, target, moveResults, critModifier, 1.0f);
                    if (user.inParentalBond && this.baseAttack.attackCategory != 2 && target.isAlive() && user.isAlive() && user.targets.size() == 1) {
                        for (EffectBase e : this.baseAttack.effects) {
                            if (!(e instanceof Assurance)) continue;
                            this.baseAttack.basePower *= 2;
                        }
                        user.inMultipleHit = false;
                        user.inParentalBond = false;
                        this.executeAttackEffects(user, target, moveResults, critModifier, 0.5f);
                        user.bc.sendToAll("multiplehit.times", user.getNickname(), 2);
                    }
                    user.inParentalBond = false;
                    this.doMove(user, target);
                    for (EffectBase base : this.baseAttack.effects) {
                        if (!(base instanceof SpecialAttackBase)) continue;
                        ((SpecialAttackBase)base).applyAfterEffect(user);
                    }
                }
            }
            boolean bl = false;
            while (var14_51 < target.getStatusSize()) {
                int sizeBefore = target.getStatusSize();
                target.getStatus((int)var14_51).onAttackEnd(target);
                if (sizeBefore > target.getStatusSize()) {
                    --var14_51;
                }
                ++var14_51;
            }
            if (!user.bc.simulateMode) {
                EnumUpdateType[] enumUpdateTypeArray = new EnumUpdateType[]{EnumUpdateType.HP, EnumUpdateType.Moveset};
                if (user.getPlayerOwner() != null) {
                    user.update(enumUpdateTypeArray);
                }
                if (target.getPlayerOwner() != null) {
                    target.update(enumUpdateTypeArray);
                }
            }
            if (target.isFainted()) {
                shouldNotLosePP = false;
            }
            return !shouldNotLosePP;
        }
        return false;
    }

    public boolean hasNoEffect(PixelmonWrapper user, PixelmonWrapper target) {
        boolean hasNoEffect;
        boolean bl = hasNoEffect = this.getTypeEffectiveness(user, target) == 0.0 && (this.baseAttack.attackCategory != 2 || this.isAttack("Poison Gas", "Poison Powder", "Thunder Wave", "Toxic"));
        if (!hasNoEffect && target.hasType(EnumType.Grass) && Overcoat.isPowderMove(this)) {
            hasNoEffect = true;
        }
        for (int o = 0; o < this.baseAttack.effects.size(); ++o) {
            if (!(this.baseAttack.effects.get(o) instanceof MultiTurnSpecialAttackBase) || !((MultiTurnSpecialAttackBase)this.baseAttack.effects.get(o)).ignoresType(user)) continue;
            hasNoEffect = false;
            break;
        }
        return hasNoEffect;
    }

    private void executeAttackEffects(PixelmonWrapper user, PixelmonWrapper target, MoveResults moveResults, EffectBase critModifier, float damageMultiplier) {
        double crit = Attack.calcCriticalHit(critModifier, user, target);
        int power = (int)((float)this.doDamageCalc(user, target, crit) * damageMultiplier);
        this.damageResult = power;
        if (this.baseAttack.attackCategory == 2) {
            power = 0;
        } else if (target.isAlive()) {
            if (crit > 1.0) {
                if (user.targets.size() > 1) {
                    user.bc.sendToAll("pixelmon.battletext.criticalhittarget", target.getNickname());
                } else {
                    user.bc.sendToAll("pixelmon.battletext.criticalhit", new Object[0]);
                }
            }
            this.damageResult = target.doBattleDamage(user, power, DamageTypeEnum.ATTACK);
            moveResults.result = target.isAlive() ? AttackResult.hit : AttackResult.killed;
        } else {
            this.damageResult = -1.0f;
            moveResults.result = AttackResult.notarget;
        }
        AttackResult tempResult = this.applyAttackEffect(user, target);
        if (tempResult != null) {
            moveResults.result = tempResult;
        }
        Attack.applyContactLate(user, target);
        if (this.canRemoveBerry()) {
            target.getUsableHeldItem().tookDamage(user, target, this.damageResult, DamageTypeEnum.ATTACK);
        }
    }

    public void doMove(PixelmonWrapper user, PixelmonWrapper target) {
        EntityLivingBase owner;
        if (user.bc.simulateMode || user.pokemon == null || target.pokemon == null) {
            return;
        }
        if (user.pokemon.field_70165_t == 0.0 && user.pokemon.field_70163_u == 0.0 && user.pokemon.field_70161_v == 0.0 && (owner = user.getParticipant().getEntity()) != null && !user.bc.simulateMode) {
            user.pokemon.func_70012_b(owner.field_70165_t, owner.field_70163_u, owner.field_70161_v, owner.field_70177_z, 0.0f);
        }
        for (IAttackAnimation anim : this.baseAttack.animations) {
            anim.doMove((EntityLiving)user.pokemon, (EntityLiving)target.pokemon);
        }
    }

    public int doDamageCalc(PixelmonWrapper userWrapper, PixelmonWrapper targetWrapper, double crit) {
        StatsType defenseStat;
        StatsType attackStat;
        if (this.movePower <= 0) {
            return 0;
        }
        AbilityBase userAbility = userWrapper.getBattleAbility();
        double stab = 1.0;
        if (this.hasSTAB(userWrapper)) {
            stab = 1.5;
        }
        stab = userAbility.modifyStab(stab);
        double type = this.getTypeEffectiveness(userWrapper, targetWrapper);
        double critical = crit;
        double modifier = stab * type * critical;
        double attack = 0.0;
        double defense = 0.0;
        double Level2 = userWrapper.getLevelNum();
        if (this.baseAttack.attackCategory == 1) {
            attackStat = StatsType.SpecialAttack;
            defenseStat = this.isAttack("Psyshock", "Psystrike", "Secret Sword") ? StatsType.Defence : StatsType.SpecialDefence;
        } else {
            attackStat = StatsType.Attack;
            defenseStat = StatsType.Defence;
        }
        attack = userWrapper.getBattleStats().getStatWithMod(attackStat);
        defense = targetWrapper.getBattleStats().getStatWithMod(defenseStat);
        if (crit > 1.0) {
            attack = Math.max((double)userWrapper.getBattleStats().getStatFromEnum(attackStat), attack);
            defense = Math.min((double)targetWrapper.getBattleStats().getStatFromEnum(defenseStat), defense);
        }
        if (this.isAttack("Chip Away", "Sacred Sword") || userAbility instanceof Unaware) {
            defense = targetWrapper.getBattleStats().getStatFromEnum(defenseStat);
        }
        if (this.isAttack("Beat Up") || targetWrapper.getBattleAbility(userWrapper) instanceof Unaware) {
            attack = userWrapper.getBattleStats().getStatFromEnum(attackStat);
        }
        double DmgRand = (double)RandomHelper.getRandomNumberBetween(85, 100) / 100.0;
        if (userWrapper.bc.simulateMode) {
            DmgRand = 1.0;
        }
        double DamageBase = (2.0 * Level2 / 5.0 + 2.0) * attack * (double)this.movePower * 0.02 / defense + 2.0;
        double Damage2 = DamageBase * modifier * DmgRand;
        Damage2 = userWrapper.getUsableHeldItem().preProcessAttackUser(userWrapper, targetWrapper, this, Damage2);
        Damage2 = targetWrapper.getUsableHeldItem().preProcessAttackTarget(userWrapper, targetWrapper, this, Damage2);
        if (userWrapper.targets.size() > 1) {
            Damage2 *= 0.75;
        }
        if (Damage2 < 1.0 && Damage2 > 0.0 && this.movePower > 0) {
            Damage2 = 1.0;
        }
        return (int)Damage2;
    }

    public void applySelfStatusMove(PixelmonWrapper user, MoveResults moveResults) {
        if (user.pokemon != null) {
            EntityPixelmon userPokemon = user.pokemon;
            userPokemon.func_70671_ap().func_75651_a((Entity)userPokemon, 0.0f, 0.0f);
        }
        for (int j = 0; j < this.baseAttack.effects.size(); ++j) {
            EffectBase e = this.baseAttack.effects.get(j);
            try {
                if (e instanceof StatsEffect) {
                    AttackResult statsResult = ((StatsEffect)e).applyStatEffect(user, user, this.baseAttack);
                    if (moveResults.result == AttackResult.succeeded) continue;
                    moveResults.result = statsResult;
                    continue;
                }
                if (e instanceof SpecialAttackBase) {
                    if (e.applyEffectStart(user, user) != AttackResult.proceed) {
                        return;
                    }
                    this.moveResult.result = ((SpecialAttackBase)e).applyEffectDuring(user, user);
                    continue;
                }
                if (e instanceof MultiTurnSpecialAttackBase) {
                    this.moveResult.result = ((MultiTurnSpecialAttackBase)e).applyEffectDuring(user, user);
                    continue;
                }
                if (e instanceof StatusBase) {
                    e.applyEffect(user, user);
                    continue;
                }
                if (!(e instanceof CriticalHit) || user.getBattleStats().increaseCritStage(2)) continue;
                user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
                continue;
            }
            catch (Exception exc) {
                user.bc.battleLog.onCrash(exc, "Error in applyEffect for " + e.getClass().toString() + " for attack " + this.baseAttack.getLocalizedName());
            }
        }
        user.getUsableHeldItem().onStatModified(user);
        if (!user.bc.simulateMode) {
            NPCTrainer trainer;
            if (user.getPlayerOwner() != null) {
                user.update(EnumUpdateType.HP, EnumUpdateType.Moveset);
            }
            if (user.pokemon != null && (trainer = user.pokemon.getTrainer()) != null) {
                trainer.getPokemonStorage().updateAndSendToClient(user.pokemon, EnumUpdateType.Moveset, EnumUpdateType.HP);
            }
        }
        if (moveResults.result == AttackResult.proceed) {
            moveResults.result = AttackResult.succeeded;
        }
    }

    public AttackResult applyAttackEffect(PixelmonWrapper user, PixelmonWrapper target) {
        AttackResult returnResult = null;
        for (int j = 0; j < this.baseAttack.effects.size(); ++j) {
            EffectBase e = this.baseAttack.effects.get(j);
            try {
                if (e instanceof StatsEffect) {
                    StatsEffect statsEffect = (StatsEffect)e;
                    boolean abilityAllowsChange = target.getBattleAbility(user).allowsStatChange(target, user, statsEffect);
                    if (abilityAllowsChange) {
                        for (PixelmonWrapper ally : target.bc.getTeamPokemon(target)) {
                            if (ally.getBattleAbility().allowsStatChangeTeammate(ally, target, user, statsEffect)) continue;
                            abilityAllowsChange = false;
                            break;
                        }
                    }
                    if (!abilityAllowsChange) continue;
                    AttackResult statsResult = statsEffect.applyStatEffect(user, target, this.baseAttack);
                    if (returnResult == AttackResult.succeeded) continue;
                    returnResult = statsResult;
                    continue;
                }
                if (e instanceof StatusBase) {
                    boolean shouldApply = true;
                    for (int i = 0; i < target.getStatusSize(); ++i) {
                        StatusBase et = target.getStatus(i);
                        if (user != target || !et.stopsStatusChange(et.type, target, user)) continue;
                        shouldApply = false;
                        break;
                    }
                    if (!shouldApply) continue;
                    e.applyEffect(user, target);
                    continue;
                }
                e.applyEffect(user, target);
                continue;
            }
            catch (Exception exc) {
                user.bc.battleLog.onCrash(exc, "Error in applyEffect for " + e.getClass().toString() + " for attack " + this.baseAttack.getLocalizedName());
            }
        }
        user.getUsableHeldItem().onStatModified(user);
        return returnResult;
    }

    public static void applyContact(PixelmonWrapper userPokemon, PixelmonWrapper targetPokemon) {
        if (!targetPokemon.hasStatus(StatusType.Substitute)) {
            userPokemon.getBattleAbility().applyEffectOnContactUser(userPokemon, targetPokemon);
            targetPokemon.getBattleAbility().applyEffectOnContactTarget(userPokemon, targetPokemon);
            targetPokemon.getUsableHeldItem().applyEffectOnContact(userPokemon, targetPokemon);
        }
    }

    public static void applyContactLate(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.attack != null && user.attack.baseAttack.getMakesContact() && !target.hasStatus(StatusType.Substitute)) {
            target.getBattleAbility().applyEffectOnContactTargetLate(user, target);
        }
    }

    public static void postProcessAttackAllHits(PixelmonWrapper user, PixelmonWrapper target, Attack attack, float power, DamageTypeEnum damageType, boolean onSubstitute) {
        if (!user.inParentalBond) {
            for (EffectBase effect : attack.baseAttack.effects) {
                effect.dealtDamage(user, target, attack, damageType);
            }
            if (!onSubstitute) {
                target.getBattleAbility().tookDamageTargetAfterMove(user, target, attack);
                target.getUsableHeldItem().postProcessAttackTarget(user, target, attack, power);
            }
            user.getUsableHeldItem().dealtDamage(user, target, attack, damageType);
        }
    }

    public void onMiss(PixelmonWrapper user, PixelmonWrapper target, MoveResults results, Object cause) {
        try {
            for (EffectBase effect : this.baseAttack.effects) {
                if (!(effect instanceof MultiTurnSpecialAttackBase) || !((MultiTurnSpecialAttackBase)effect).isCharging(user, target)) continue;
                results.result = ((MultiTurnSpecialAttackBase)effect).applyEffectDuring(user, target);
                if (results.result != AttackResult.charging) continue;
                return;
            }
            if (cause instanceof StatusBase) {
                ((StatusBase)cause).stopsIncomingAttackMessage(target, user);
            } else if (cause instanceof AbilityBase) {
                ((AbilityBase)cause).allowsIncomingAttackMessage(target, user, this);
            } else if (cause instanceof EnumType) {
                user.bc.sendToAll("pixelmon.battletext.noeffect", target.getNickname());
            } else {
                user.bc.sendToAll("pixelmon.battletext.missedattack", target.getNickname());
                results.result = AttackResult.missed;
            }
            for (EffectBase effect : this.baseAttack.effects) {
                effect.applyMissEffect(user, target);
            }
            user.getUsableHeldItem().onMiss(user, target);
        }
        catch (Exception exc) {
            user.bc.battleLog.onCrash(exc, "Error in applyMissEffect for attack " + this.baseAttack.getLocalizedName());
        }
        if (results.result != AttackResult.missed) {
            results.result = AttackResult.failed;
        }
    }

    public boolean hasSTAB(PixelmonWrapper user) {
        return user.type.contains((Object)this.baseAttack.attackType);
    }

    public void setDisabled(boolean value, PixelmonWrapper pixelmon) {
        this.setDisabled(value, pixelmon, false);
    }

    public void setDisabled(boolean value, PixelmonWrapper pixelmon, boolean switching) {
        this.disabled = value;
        if (pixelmon.getParticipant() instanceof PlayerParticipant) {
            pixelmon.update(EnumUpdateType.Moveset);
        }
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    public static double calcCriticalHit(EffectBase e, PixelmonWrapper user, PixelmonWrapper target) {
        if (target.getBattleAbility(user).preventsCriticalHits(user) || target.hasStatus(StatusType.LuckyChant)) {
            return 1.0;
        }
        int critStage = 1;
        critStage += user.getUsableHeldItem().adjustCritStage(user);
        AbilityBase userAbility = user.getBattleAbility();
        if (userAbility instanceof SuperLuck) {
            ++critStage;
        }
        if (user.attack.isAttack("Focus Energy") && !user.getBattleStats().increaseCritStage(2)) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            user.attack.moveResult.result = AttackResult.failed;
        }
        float percent = 0.0625f;
        if (e != null && e instanceof CriticalHit) {
            critStage += e.value;
        }
        if ((critStage += user.getBattleStats().getCritStage()) == 2) {
            percent = 0.125f;
        } else if (critStage == 3) {
            percent = 0.5f;
        } else if (critStage >= 4) {
            percent = 1.0f;
        }
        if (user.bc.simulateMode && percent < 1.0f) {
            percent = 0.0f;
        }
        if (RandomHelper.getRandomChance(percent)) {
            AbilityBase targetAbility = target.getBattleAbility();
            if (targetAbility instanceof AngerPoint && !user.bc.simulateMode) {
                ((AngerPoint)targetAbility).wasCrit = true;
            }
            double crit = 1.5;
            if (userAbility instanceof Sniper) {
                crit *= 1.5;
            }
            return crit;
        }
        return 1.0;
    }

    public boolean canHit(PixelmonWrapper pixelmon1, PixelmonWrapper pixelmon2) {
        return pixelmon2 != null && !pixelmon2.isFainted();
    }

    public static boolean canMovesHit(PixelmonWrapper entity, PixelmonWrapper target) {
        boolean[] b = new boolean[4];
        int i1 = 0;
        b[3] = true;
        b[2] = true;
        b[1] = true;
        b[0] = true;
        for (int i = 0; i < entity.getMoveset().size(); ++i) {
            Attack a = entity.getMoveset().get(i);
            if (!a.canHit(entity, target)) {
                b[i1] = false;
            }
            ++i1;
        }
        return b[0] && b[1] && b[2] && b[3];
    }

    public static int getAttackCategory(int categoryID) {
        if (categories == null) {
            categories = DatabaseMoves.getAttackCategories();
        }
        String categoryString = "";
        for (AttackCategory category : categories) {
            if (category.index != categoryID) continue;
            categoryString = category.category;
        }
        if (categoryString.equalsIgnoreCase("Special")) {
            return 1;
        }
        if (categoryString.equalsIgnoreCase("Physical")) {
            return 0;
        }
        if (categoryString.equalsIgnoreCase("Status")) {
            return 2;
        }
        if (PixelmonConfig.printErrors) {
            Pixelmon.LOGGER.info("Unknown attack category: " + categoryString);
        }
        return -1;
    }

    public boolean doesPersist(PixelmonWrapper entityPixelmon) {
        if (this.isAttack("Fly", "Bounce")) {
            return entityPixelmon.hasStatus(StatusType.Flying);
        }
        for (int i = 0; i < this.baseAttack.effects.size(); ++i) {
            EffectBase e = this.baseAttack.effects.get(i);
            try {
                if (!e.doesPersist(entityPixelmon)) continue;
                return true;
            }
            catch (Exception exc) {
                entityPixelmon.bc.battleLog.onCrash(exc, "Error in doesPersist for " + e.getClass().toString() + " for attack " + this.baseAttack.getLocalizedName());
            }
        }
        return entityPixelmon.hasStatus(StatusType.Recharge);
    }

    public boolean cantMiss(PixelmonWrapper user) {
        if (this.cantMiss) {
            return true;
        }
        for (int i = 0; i < this.baseAttack.effects.size(); ++i) {
            EffectBase e = this.baseAttack.effects.get(i);
            try {
                if (!e.cantMiss(user)) continue;
                return true;
            }
            catch (Exception exc) {
                user.bc.battleLog.onCrash(exc, "Error in cantMiss for " + e.getClass().toString() + " for attack " + this.baseAttack.getLocalizedName());
            }
        }
        return false;
    }

    public static String getCategoryString(int category) {
        if (category == 0) {
            return I18n.func_74838_a((String)"attack.category.physical");
        }
        if (category == 1) {
            return I18n.func_74838_a((String)"attack.category.special");
        }
        if (category == 2) {
            return I18n.func_74838_a((String)"attack.category.status");
        }
        return "";
    }

    public void sendEffectiveChat(PixelmonWrapper user, PixelmonWrapper target) {
        String s = null;
        if (this.baseAttack.attackCategory != 2) {
            float effectiveness = (float)this.getTypeEffectiveness(user, target);
            if (effectiveness == 0.0f) {
                user.bc.sendToAll("pixelmon.battletext.noeffect", target.getNickname());
                return;
            }
            if (effectiveness == 0.5f || effectiveness == 0.25f) {
                s = "pixelmon.battletext.wasnoteffective";
            } else if (effectiveness == 2.0f || effectiveness == 4.0f) {
                s = "pixelmon.battletext.supereffective";
            }
            if (s != null) {
                if (user.targets.size() > 1) {
                    user.bc.sendToAll(s.concat("target"), target.getNickname());
                } else {
                    user.bc.sendToAll(s, new Object[0]);
                }
            }
        }
    }

    public static boolean dealsDamage(Attack attack) {
        return attack != null && attack.baseAttack.basePower > 0;
    }

    public void saveAttack() {
        this.savedPower = this.baseAttack.basePower;
        this.savedAccuracy = this.baseAttack.accuracy;
        this.savedType = this.baseAttack.attackType;
    }

    public void restoreAttack() {
        this.baseAttack.basePower = this.savedPower;
        this.baseAttack.accuracy = this.savedAccuracy;
        this.baseAttack.attackType = this.savedType;
    }

    public boolean isAttack(String ... attacks) {
        for (String a : attacks) {
            if (!this.baseAttack.getUnLocalizedName().equalsIgnoreCase(a)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAttack(List<Attack> attackList, String ... attackNames) {
        for (Attack attack : attackList) {
            if (attack == null || !attack.isAttack(attackNames)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasOffensiveAttackType(List<Attack> attackList, EnumType type) {
        for (Attack attack : attackList) {
            if (attack == null || attack.baseAttack.attackType != type || attack.baseAttack.attackCategory == 2) continue;
            return true;
        }
        return false;
    }

    public void createMoveChoices(PixelmonWrapper pw, ArrayList<MoveChoice> choices, boolean includeAllies) {
        ArrayList<PixelmonWrapper> targets = new ArrayList<PixelmonWrapper>();
        TargetingInfo info = this.baseAttack.targetingInfo;
        if (info.hitsSelf) {
            targets.add(pw);
        }
        if (info.hitsAdjacentAlly && (includeAllies || info.hitsAll)) {
            targets.addAll(pw.bc.getTeamPokemonExcludeSelf(pw));
        }
        if (info.hitsAdjacentFoe) {
            targets.addAll(pw.bc.getOpponentPokemon(pw));
        }
        if (info.hitsAll) {
            choices.add(new MoveChoice(pw, this, targets));
        } else {
            for (PixelmonWrapper target : targets) {
                ArrayList<PixelmonWrapper> targetArray = new ArrayList<PixelmonWrapper>(1);
                targetArray.add(target);
                choices.add(new MoveChoice(pw, this, targetArray));
            }
        }
    }

    public ArrayList<MoveChoice> createMoveChoices(PixelmonWrapper pw, boolean includeAllies) {
        ArrayList<MoveChoice> choices = new ArrayList<MoveChoice>();
        this.createMoveChoices(pw, choices, includeAllies);
        return choices;
    }

    public ArrayList<Attack> createList() {
        ArrayList<Attack> list = new ArrayList<Attack>(1);
        list.add(this);
        return list;
    }

    public boolean equals(Object compare) {
        if (compare == null || !(compare instanceof Attack)) {
            return false;
        }
        return this.baseAttack.getUnLocalizedName().equalsIgnoreCase(((Attack)compare).baseAttack.getUnLocalizedName());
    }

    public int hashCode() {
        if (this.baseAttack == null) {
            return 0;
        }
        return this.baseAttack.getUnLocalizedName().hashCode();
    }

    public String toString() {
        return this.baseAttack.getUnLocalizedName();
    }

    public double getTypeEffectiveness(PixelmonWrapper user, PixelmonWrapper target) {
        List<EnumType> effectiveTypes = target.getEffectiveTypes(user, target);
        if (this.baseAttack.isAttack("Thousand Arrows") && effectiveTypes.contains((Object)EnumType.Flying)) {
            effectiveTypes.removeIf(type -> type == EnumType.Flying);
            if (effectiveTypes.isEmpty()) {
                effectiveTypes.add(EnumType.Normal);
            }
        }
        double effectiveness = EnumType.getTotalEffectiveness(effectiveTypes, this.baseAttack.attackType);
        for (EffectBase e : this.baseAttack.effects) {
            effectiveness = e.modifyTypeEffectiveness(effectiveTypes, this.baseAttack.attackType, effectiveness);
        }
        if (user.bc.rules.hasClause("inverse")) {
            effectiveness = EnumType.inverseEffectiveness((float)effectiveness);
        }
        return effectiveness;
    }

    public boolean canRemoveBerry() {
        return this.isAttack("Bug Bite", "Pluck", "Knock Off");
    }

    public Attack copy() {
        Attack newAttack = new Attack(this.baseAttack);
        newAttack.pp = this.pp;
        return newAttack;
    }

    public boolean checkSkyBattle(BattleControllerBase bc) {
        return !bc.rules.hasClause("sky") || SkyBattle.isMoveAllowed(this);
    }

    public boolean canHitNoTarget() {
        return this.isAttack("Doom Desire", "Future Sight", "Imprison", "Spikes", "Stealth Rock", "Sticky Web", "Toxic Spikes");
    }
}

