/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.attacks.TargetingInfo;
import com.pixelmonmod.pixelmon.battles.attacks.animations.AttackAnimationLeapForward;
import com.pixelmonmod.pixelmon.battles.attacks.animations.AttackAnimationParser;
import com.pixelmonmod.pixelmon.battles.attacks.animations.IAttackAnimation;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.attackModifiers.Priority;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.Pledge;
import com.pixelmonmod.pixelmon.battles.status.MeanLook;
import com.pixelmonmod.pixelmon.battles.status.PartialTrap;
import com.pixelmonmod.pixelmon.enums.EnumType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.util.text.translation.I18n;

public class AttackBase {
    public int attackIndex;
    private String attackName;
    public EnumType attackType = EnumType.Mystery;
    public int attackCategory;
    public int basePower;
    public int ppBase;
    public int ppMax;
    public int accuracy;
    private boolean makesContact;
    public ArrayList<EffectBase> effects = new ArrayList();
    public ArrayList<IAttackAnimation> animations = new ArrayList();
    public TargetingInfo targetingInfo;

    public AttackBase(int attackIndex, String moveName, ResultSet rs) throws SQLException {
        String[] splits;
        this.attackIndex = attackIndex;
        this.attackName = moveName;
        this.ppBase = rs.getInt("PP");
        this.ppMax = rs.getInt("PPMAX");
        this.attackType = EnumType.parseTypeFromDBID(rs.getInt("TYPEID"));
        if (this.attackName.equals("Struggle")) {
            this.attackType = EnumType.Mystery;
        }
        this.attackCategory = Attack.getAttackCategory(rs.getInt("MOVECATEGORYID"));
        this.basePower = rs.getInt("POWER");
        this.accuracy = rs.getInt("ACCURACY");
        if (rs.wasNull()) {
            this.accuracy = -1;
        }
        this.makesContact = rs.getBoolean("MAKESCONTACT");
        rs.getString("DESCRIPTION");
        for (String e : splits = rs.getString("EFFECT").split(";")) {
            EffectBase base;
            EffectBase etmp = EffectBase.getEffect(e);
            if (etmp != null) {
                this.effects.add(etmp);
                continue;
            }
            if (e.equals("PartialTrap")) {
                base = new PartialTrap();
                this.effects.add(base);
                continue;
            }
            if (e.equals("WaterPledge")) {
                base = new Pledge();
                this.effects.add(base);
                continue;
            }
            if (!e.equals("MeanLook")) continue;
            base = new MeanLook();
            this.effects.add(base);
        }
        String animationString = rs.getString("ATTACKANIMATIONS");
        if (animationString == null) {
            this.animations = new ArrayList();
            this.animations.add(new AttackAnimationLeapForward());
        } else {
            this.animations = AttackAnimationParser.GetAnimation(animationString);
        }
        this.targetingInfo = new TargetingInfo(rs);
    }

    public AttackBase(EnumType attackType, int basePower, int attackCategory) {
        this.attackType = attackType;
        this.basePower = basePower;
        this.attackCategory = attackCategory;
        this.attackName = "";
    }

    public String getLocalizedName() {
        return AttackBase.getLocalizedName(this.attackName);
    }

    public static String getLocalizedName(String attackName) {
        return I18n.func_74838_a((String)("attack." + attackName.toLowerCase() + ".name"));
    }

    public String getUnLocalizedName() {
        return this.attackName;
    }

    public String getLocalizedDescription() {
        return I18n.func_74838_a((String)("attack." + this.attackName.toLowerCase() + ".description"));
    }

    public boolean getMakesContact() {
        return this.makesContact;
    }

    public boolean isAttack(String name) {
        return this.attackName.toLowerCase().equals(name.toLowerCase()) || this.getLocalizedName().toLowerCase().equals(name.toLowerCase());
    }

    public int getPriority() {
        EffectBase effect;
        Iterator<EffectBase> var1 = this.effects.iterator();
        do {
            if (var1.hasNext()) continue;
            return 0;
        } while (!((effect = var1.next()) instanceof Priority));
        return ((Priority)effect).value;
    }

    public boolean hasSecondaryEffect() {
        EffectBase effect;
        Iterator<EffectBase> var1 = this.effects.iterator();
        do {
            if (var1.hasNext()) continue;
            return false;
        } while (!(effect = var1.next()).isChance());
        return true;
    }
}

