/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.attacks.EffectParser;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.modifiers.ChanceModifier;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.modifiers.ModifierBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.modifiers.ModifierType;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.enums.EnumType;
import java.util.ArrayList;
import java.util.List;

public abstract class EffectBase {
    public ArrayList<ModifierBase> modifiers = new ArrayList();
    private boolean persists;
    public int value = -1;
    public int value2 = -1;

    public EffectBase() {
        this.persists = false;
    }

    public EffectBase(boolean persists) {
        this.persists = persists;
    }

    public void addModifier(ModifierBase modifier) {
        this.modifiers.add(modifier);
    }

    public AttackResult applyEffectStart(PixelmonWrapper user, PixelmonWrapper target) {
        return AttackResult.proceed;
    }

    protected abstract void applyEffect(PixelmonWrapper var1, PixelmonWrapper var2);

    public boolean checkChance() {
        for (ModifierBase m : this.modifiers) {
            if (m.type != ModifierType.Chance) continue;
            return ((ChanceModifier)m).RollChance();
        }
        return true;
    }

    public boolean isChance() {
        for (ModifierBase m : this.modifiers) {
            if (m.type != ModifierType.Chance) continue;
            return true;
        }
        return false;
    }

    public float getChance() {
        for (ModifierBase m : this.modifiers) {
            if (m.type != ModifierType.Chance) continue;
            return ((ChanceModifier)m).value;
        }
        return 100.0f;
    }

    public void changeChance(int multiplier) {
        this.modifiers.stream().filter(m -> m.type == ModifierType.Chance).forEach(m -> {
            ((ChanceModifier)m).multiplier = multiplier;
        });
    }

    public abstract boolean cantMiss(PixelmonWrapper var1);

    public static EffectBase getEffect(String e) {
        EffectParser p = new EffectParser();
        return p.ParseEffect(e);
    }

    public boolean doesPersist(PixelmonWrapper user) {
        return this.persists;
    }

    public void applyMissEffect(PixelmonWrapper user, PixelmonWrapper target) {
    }

    public void applyEarlyEffect(PixelmonWrapper user) {
    }

    public void dealtDamage(PixelmonWrapper attacker, PixelmonWrapper defender, Attack attack, DamageTypeEnum damageType) {
    }

    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
    }

    protected float getWeightWithChance(float weight) {
        float chance = this.getChance() / 100.0f;
        return chance >= 0.5f ? weight : chance;
    }

    public double modifyTypeEffectiveness(List<EnumType> effectiveTypes, EnumType moveType, double baseEffectiveness) {
        return baseEffectiveness;
    }
}

