/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Terrain;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBone;
import net.minecraft.block.BlockMagma;
import net.minecraft.block.BlockNetherrack;
import net.minecraft.block.BlockSoulSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeSwamp;

public class TerrainExamine {
    public static TerrainType getTerrain(PixelmonWrapper user) {
        Block block;
        IBlockState state;
        Material blockMaterial;
        if (user == null || user.bc == null) {
            return TerrainType.Default;
        }
        Terrain terrain = user.bc.globalStatusController.getTerrain();
        switch (terrain.type) {
            case ElectricTerrain: {
                return TerrainType.Electric;
            }
            case GrassyTerrain: {
                return TerrainType.Grass;
            }
            case MistyTerrain: {
                return TerrainType.Misty;
            }
        }
        BlockPos userPosition = user.getWorldPosition();
        World world = user.getWorld();
        Biome biome = world.func_180494_b(userPosition);
        int numBelow = 0;
        do {
            state = world.func_180495_p(userPosition.func_177979_c(numBelow));
            block = state.func_177230_c();
        } while ((blockMaterial = state.func_185904_a()) == Material.field_151579_a && ++numBelow < 5);
        String blockName = block.func_149739_a();
        if (blockMaterial == Material.field_151586_h && biome instanceof BiomeSwamp) {
            return TerrainType.Swamp;
        }
        if (blockMaterial == Material.field_151577_b || blockMaterial == Material.field_151575_d || blockMaterial == Material.field_151584_j || blockMaterial == Material.field_151585_k || blockMaterial == Material.field_151582_l || blockMaterial == Material.field_151570_A || blockMaterial == Material.field_151572_C) {
            return TerrainType.Grass;
        }
        if (blockMaterial == Material.field_151586_h || blockMaterial == Material.field_151583_m || blockMaterial == Material.field_151589_v) {
            return TerrainType.Water;
        }
        if (blockMaterial == Material.field_151588_w || blockMaterial == Material.field_151598_x) {
            return TerrainType.Ice;
        }
        if (blockMaterial == Material.field_151597_y || blockMaterial == Material.field_151596_z) {
            return TerrainType.Snow;
        }
        if (blockMaterial == Material.field_151579_a) {
            return TerrainType.Sky;
        }
        if (block instanceof BlockSoulSand || block instanceof BlockBone) {
            return TerrainType.Burial;
        }
        if (blockMaterial == Material.field_151595_p || blockMaterial == Material.field_151571_B || blockMaterial == Material.field_151578_c) {
            return TerrainType.Sand;
        }
        if (blockMaterial == Material.field_151567_E || blockMaterial == Material.field_151566_D || blockMaterial == Material.field_189963_J || blockName.equals("whiteStone") || blockName.contains("end") || blockName.contains("purpur")) {
            return TerrainType.Space;
        }
        if (blockMaterial == Material.field_151587_i || blockMaterial == Material.field_151581_o || blockName.contains("nether") || block instanceof BlockNetherrack || block instanceof BlockMagma) {
            return TerrainType.Volcano;
        }
        if (blockMaterial == Material.field_151576_e) {
            return TerrainType.Cave;
        }
        return TerrainType.Default;
    }

    public static enum TerrainType {
        Default,
        Cave,
        Sand,
        Swamp,
        Water,
        Snow,
        Ice,
        Volcano,
        Burial,
        Sky,
        Space,
        Grass,
        Misty,
        Electric;

    }
}

