/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.multiTurn;

import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.multiTurn.MultiTurnSpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import java.util.ArrayList;

public class MultiTurnCharge
extends MultiTurnSpecialAttackBase {
    String message = "";
    Class<? extends StatusBase> base;
    StatusType type;

    public MultiTurnCharge() {
    }

    public MultiTurnCharge(String message) {
        this.message = message;
    }

    public MultiTurnCharge(String message, Class<? extends StatusBase> base, StatusType type) {
        this(message);
        this.base = base;
        this.type = type;
    }

    @Override
    public AttackResult applyEffectDuring(PixelmonWrapper user, PixelmonWrapper target) {
        if (!this.doesPersist(user)) {
            this.setPersists(user, true);
            this.setTurnCount(user, 2);
        }
        this.decrementTurnCount(user);
        if (this.getTurnCount(user) == 1) {
            user.bc.sendToAll(this.message, user.getNickname());
            if (!user.getUsableHeldItem().affectMultiturnMove(user)) {
                if (this.base != null) {
                    user.addStatus(StatusBase.getNewInstance(this.base), user);
                }
                return AttackResult.charging;
            }
        }
        if (this.type != null) {
            user.removeStatus(this.type);
        }
        this.setPersists(user, false);
        return AttackResult.proceed;
    }

    @Override
    public boolean cantMiss(PixelmonWrapper user) {
        return this.getTurnCount(user) == -1;
    }

    @Override
    public void applyMissEffect(PixelmonWrapper user, PixelmonWrapper target) {
        this.removeEffect(user, target);
    }

    @Override
    public void removeEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (this.type != null) {
            user.removeStatus(this.type);
        }
        this.setPersists(user, false);
    }

    @Override
    public boolean isCharging(PixelmonWrapper user, PixelmonWrapper target) {
        return !this.doesPersist(user);
    }

    @Override
    public boolean shouldNotLosePP(PixelmonWrapper user) {
        return !this.doesPersist(user) && user.getUsableHeldItem().getHeldItemType() != EnumHeldItems.powerHerb;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        if (pw.getUsableHeldItem().getHeldItemType() == EnumHeldItems.powerHerb) {
            return;
        }
        if (this.base == null) {
            if (userChoice.tier >= 3) {
                userChoice.lowerTier(2);
            } else {
                userChoice.weight /= 2.0f;
            }
        } else {
            userChoice.weight *= 0.9f;
        }
        if (pw.hasStatus(StatusType.Confusion, StatusType.Infatuated, StatusType.Paralysis)) {
            userChoice.weight /= 2.0f;
        }
    }
}

