/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller;

import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.EVsStore;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Level;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Stats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.Evolution;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.types.LevelingEvolution;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.ItemExpAll;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import com.pixelmonmod.pixelmon.items.heldItems.EVAdjusting;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public final class Experience {
    public static void awardExp(ArrayList<BattleParticipant> participants, BattleParticipant losingTeamOwner, PixelmonWrapper faintedPokemon) {
        if (faintedPokemon == null || faintedPokemon.bc.isLevelingDisabled()) {
            return;
        }
        for (BattleParticipant teamOwner : participants) {
            if (teamOwner.team == losingTeamOwner.team || !(teamOwner instanceof PlayerParticipant)) continue;
            PlayerParticipant player = (PlayerParticipant)teamOwner;
            Set<PixelmonWrapper> attackers = faintedPokemon.getAttackers();
            for (PixelmonWrapper pw : attackers) {
                if (pw.getParticipant() != teamOwner) continue;
                Experience.calcExp(faintedPokemon, pw, 1.0);
            }
            boolean hasExpAll = false;
            ArrayList items = new ArrayList();
            items.addAll(player.player.field_71071_by.field_70462_a);
            items.addAll(player.player.field_71071_by.field_184439_c);
            for (ItemStack item : items) {
                NBTTagCompound nbt;
                if (item == null || !(item.func_77973_b() instanceof ItemExpAll) || !item.func_77942_o() || !(nbt = item.func_77978_p()).func_74767_n("Activated")) continue;
                hasExpAll = true;
                break;
            }
            for (PixelmonWrapper pw : teamOwner.allPokemon) {
                if (attackers.contains(pw)) continue;
                boolean getsExp = false;
                if (hasExpAll || pw.getHeldItem().getHeldItemType() == EnumHeldItems.expShare) {
                    getsExp = true;
                }
                if (!getsExp) continue;
                Experience.calcExp(faintedPokemon, pw, 0.5);
            }
            player.givePlayerExp(faintedPokemon);
        }
    }

    private static void calcExp(PixelmonWrapper faintedPokemon, PixelmonWrapper expReceiver, double scaleFactor) {
        if (expReceiver.isFainted()) {
            return;
        }
        ItemHeld heldItem = expReceiver.getInitialHeldItem();
        EnumHeldItems heldItemType = heldItem.getHeldItemType();
        Level level = expReceiver.getLevel();
        EVsStore evStore = faintedPokemon.getBaseStats().evGain.cloneEVs();
        if (heldItemType == EnumHeldItems.evAdjusting) {
            EVAdjusting item = (EVAdjusting)heldItem;
            if (item.type.statAffected == StatsType.None) {
                evStore.doubleValues();
            } else {
                evStore.addEVs(4, item.type.statAffected);
            }
        }
        Stats stats = expReceiver.getStats();
        stats.EVs.gainEV(evStore);
        int beforeHP = stats.HP;
        stats.setLevelStats(expReceiver.getNature(), expReceiver.getBaseStats(), level.getLevel());
        if (stats.HP > beforeHP) {
            expReceiver.setHealth((int)Math.ceil((double)expReceiver.getHealth() / (double)beforeHP * (double)stats.HP));
            expReceiver.updateHPIncrease();
        }
        expReceiver.update(EnumUpdateType.HP, EnumUpdateType.Stats);
        if (expReceiver.getLevelNum() >= expReceiver.bc.rules.levelCap) {
            return;
        }
        double a = 1.0;
        if (faintedPokemon.getParticipant().getType() != ParticipantType.WildPokemon) {
            a = 1.5;
        }
        double t = expReceiver.getOriginalTrainer().equals(expReceiver.getParticipant().getDisplayName()) ? 1.0 : 1.5;
        double baseExp = faintedPokemon.getBaseStats().baseExp;
        double eggMultiplier = heldItemType == EnumHeldItems.luckyEgg ? 1.5 : 1.0;
        double faintedLevel = faintedPokemon.getLevelNum();
        double exp = a * t * baseExp * eggMultiplier * faintedLevel * (scaleFactor *= (double)PixelmonConfig.expModifier) / 7.0;
        for (Evolution e : expReceiver.getBaseStats().evolutions) {
            if (e == null || !(e instanceof LevelingEvolution) || level.getLevel() < ((LevelingEvolution)e).level) continue;
            exp *= 1.2;
            break;
        }
        level.awardEXP((int)exp);
    }
}

