/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller;

import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.GlobalStatusBase;
import com.pixelmonmod.pixelmon.battles.status.NoTerrain;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Terrain;
import com.pixelmonmod.pixelmon.battles.status.Weather;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class GlobalStatusController {
    public BattleControllerBase bc;
    private ArrayList<GlobalStatusBase> globalStatuses = new ArrayList();

    public GlobalStatusController(BattleControllerBase bc) {
        this.bc = bc;
    }

    public ArrayList<GlobalStatusBase> getGlobalStatuses() {
        ArrayList<GlobalStatusBase> effectiveStatuses = new ArrayList<GlobalStatusBase>(this.globalStatuses.size());
        effectiveStatuses.addAll(this.globalStatuses.stream().filter(status -> !status.isWeather() || !GlobalStatusBase.ignoreWeather(this.bc)).collect(Collectors.toList()));
        return effectiveStatuses;
    }

    public Weather getWeather() {
        if (GlobalStatusBase.ignoreWeather(this.bc)) {
            return null;
        }
        for (GlobalStatusBase g : this.globalStatuses) {
            if (!g.isWeather()) continue;
            return (Weather)g;
        }
        return null;
    }

    public Weather getWeatherIgnoreAbility() {
        for (GlobalStatusBase g : this.globalStatuses) {
            if (!g.isWeather()) continue;
            return (Weather)g;
        }
        return null;
    }

    public Terrain getTerrain() {
        for (GlobalStatusBase g : this.globalStatuses) {
            if (!g.isTerrain()) continue;
            return (Terrain)g;
        }
        return new NoTerrain();
    }

    public boolean removeGlobalStatus(StatusType status) {
        for (int i = 0; i < this.globalStatuses.size(); ++i) {
            GlobalStatusBase g = this.globalStatuses.get(i);
            if (g.type != status) continue;
            if (!this.bc.simulateMode) {
                this.globalStatuses.remove(i);
            }
            return true;
        }
        return false;
    }

    public void removeGlobalStatus(GlobalStatusBase g) {
        if (!this.bc.simulateMode) {
            this.globalStatuses.remove(g);
            if (g.isWeather()) {
                this.triggerWeatherChange(null);
            }
        }
    }

    public void addGlobalStatus(GlobalStatusBase g) {
        if (!this.bc.simulateMode) {
            if (g.isWeather()) {
                for (int i = 0; i < this.globalStatuses.size(); ++i) {
                    GlobalStatusBase gsb = this.globalStatuses.get(i);
                    if (!gsb.isWeather()) continue;
                    this.globalStatuses.remove(gsb);
                    --i;
                }
                if (!GlobalStatusBase.ignoreWeather(this.bc)) {
                    this.triggerWeatherChange((Weather)g);
                }
            }
            this.globalStatuses.add(g);
        }
    }

    public GlobalStatusBase getGlobalStatus(int index) {
        return this.globalStatuses.get(index);
    }

    public GlobalStatusBase getGlobalStatus(StatusType type) {
        for (GlobalStatusBase g : this.globalStatuses) {
            if (g.type != type) continue;
            return g;
        }
        return null;
    }

    public int getGlobalStatusSize() {
        return this.globalStatuses.size();
    }

    public boolean hasStatus(StatusType type) {
        return this.getGlobalStatus(type) != null;
    }

    public void endBattle() {
        this.globalStatuses.clear();
    }

    public void triggerWeatherChange(Weather weather) {
        for (PixelmonWrapper pw : this.bc.getActiveUnfaintedPokemon()) {
            pw.getBattleAbility().onWeatherChange(pw, weather);
        }
    }
}

