/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller.log;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackAction;
import com.pixelmonmod.pixelmon.battles.controller.log.BattleActionBase;
import com.pixelmonmod.pixelmon.battles.controller.log.SwitchAction;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import java.util.ArrayList;
import net.minecraft.entity.Entity;

public class BattleLog {
    private int crashCount = 0;
    BattleControllerBase bc;
    ArrayList<BattleActionBase[]> log;
    private final int size;

    public BattleLog(BattleControllerBase bc) {
        this.bc = bc;
        if (bc.rules.battleType.numPokemon == 2) {
            this.size = 4;
            this.log = new ArrayList();
            this.log.add(new BattleActionBase[this.size]);
        } else if (bc.rules.battleType.numPokemon == 1) {
            this.size = 2;
            this.log = new ArrayList();
            this.log.add(new BattleActionBase[this.size]);
        } else {
            if (PixelmonConfig.printErrors) {
                Pixelmon.LOGGER.error("Fatal error in initialisation of battleLog. Is this a triple or rotation battle?");
            }
            this.size = 0;
        }
    }

    public void addEvent(BattleActionBase event) {
        try {
            this.log.get((int)event.turn)[event.pokemonPosition] = event;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.log.get((int)event.turn)[0] = event;
        }
    }

    public BattleActionBase getAction(int turn, int position) {
        if (position >= this.log.get(turn).length) {
            position = this.log.get(turn).length - 1;
        }
        return this.log.get(turn)[position];
    }

    public BattleActionBase getActionForPokemon(int turn, PixelmonWrapper pw) {
        for (BattleActionBase bab : this.log.get(turn)) {
            if (bab == null || bab.pokemon != pw) continue;
            return bab;
        }
        return null;
    }

    public Attack getLastAttack(PixelmonWrapper pw) {
        for (int i = this.log.size() - 1; i >= 0; --i) {
            for (BattleActionBase bab : this.log.get(i)) {
                if (bab != null && bab.pokemon == pw && bab instanceof AttackAction) {
                    return ((AttackAction)bab).getAttack();
                }
                if (!(bab instanceof SwitchAction) || !PixelmonMethods.isIDSame(pw.getPokemonID(), ((SwitchAction)bab).switchingTo)) continue;
                return null;
            }
        }
        return null;
    }

    public ArrayList<Attack> getLastAttacks(PixelmonWrapper pw) {
        ArrayList<Attack> attacks = new ArrayList<Attack>();
        for (int i = this.log.size() - 1; i >= 0; --i) {
            for (BattleActionBase bab : this.log.get(i)) {
                if (bab != null && bab.pokemon == pw && bab instanceof AttackAction) {
                    attacks.add(((AttackAction)bab).getAttack());
                    continue;
                }
                if (!(bab instanceof SwitchAction) || !PixelmonMethods.isIDSame(pw.getPokemonID(), ((SwitchAction)bab).switchingTo)) continue;
                return attacks;
            }
        }
        return attacks;
    }

    public void turnTick() {
        this.log.add(new BattleActionBase[this.size]);
    }

    public void onCrash(Exception exc, String error) {
        ++this.crashCount;
        if (PixelmonConfig.printErrors) {
            System.out.println(error);
            exc.printStackTrace();
        }
        if (this.crashCount >= 3) {
            if (PixelmonConfig.printErrors) {
                System.out.println("===Too many errors detected in battle, force-ending===");
                this.bc.participants.stream().filter(participant -> participant instanceof PlayerParticipant).forEach(participant -> ChatHandler.sendChat((Entity)participant.getEntity(), "pixelmon.general.battleerror", new Object[0]));
            }
            this.bc.endBattleWithoutXP();
        }
    }
}

