/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller.participants;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Stats;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleType;
import java.util.Iterator;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.text.TextComponentBase;
import net.minecraft.util.text.TextComponentTranslation;

public class WildPixelmonParticipant
extends BattleParticipant {
    private boolean isBlockBattleParticipant = false;
    private static int idCounter = 0;

    public WildPixelmonParticipant(boolean isGrassBattleParticipant, EntityPixelmon ... pixelmon) {
        super(pixelmon.length);
        this.init(pixelmon);
        this.isBlockBattleParticipant = isGrassBattleParticipant;
    }

    public WildPixelmonParticipant(EntityPixelmon ... pixelmon) {
        super(pixelmon.length);
        this.init(pixelmon);
    }

    private void init(EntityPixelmon[] pixelmon) {
        this.allPokemon = new PixelmonWrapper[pixelmon.length];
        for (int i = 0; i < pixelmon.length; ++i) {
            PixelmonWrapper pw;
            this.allPokemon[i] = pw = new PixelmonWrapper((BattleParticipant)this, pixelmon[i], i);
            this.controlledPokemon.add(pw);
            pixelmon[i].setPokemonId(new int[]{-1, idCounter++});
        }
    }

    @Override
    public ParticipantType getType() {
        return ParticipantType.WildPokemon;
    }

    @Override
    public boolean hasMorePokemon() {
        return this.countAblePokemon() == 1;
    }

    @Override
    public boolean hasMorePokemonReserve() {
        return false;
    }

    @Override
    public boolean canGainXP() {
        return false;
    }

    @Override
    public void startBattle(BattleControllerBase bc) {
        super.startBattle(bc);
        boolean isBoss = false;
        for (PixelmonWrapper pw : this.controlledPokemon) {
            EnumBossMode bossMode = pw.pokemon.getBossMode();
            if (bossMode != EnumBossMode.NotBoss) {
                isBoss = true;
                int lvl = 1;
                for (BattleParticipant p : bc.participants) {
                    if (p.team == this.team || !(p instanceof PlayerParticipant)) continue;
                    int highestLevel = ((PlayerParticipant)p).getHighestLevel();
                    lvl = Math.max(lvl, highestLevel);
                }
                Stats stats = pw.getStats();
                stats.IVs.maximizeIVs();
                stats.EVs.randomizeMaxEVs();
                pw.setTempLevel(lvl += bossMode.extraLevels);
            }
            pw.setHealth(pw.getMaxHealth());
        }
        this.setBattleAI(isBoss ? PixelmonConfig.battleAIBoss.createAI(this) : PixelmonConfig.battleAIWild.createAI(this));
    }

    @Override
    public void endBattle() {
        for (PixelmonWrapper pw : this.controlledPokemon) {
            pw.pokemon.endBattle();
            if (!pw.isFainted() && !this.shouldDespawn() && !this.isBlockBattleParticipant) continue;
            pw.pokemon.func_70106_y();
        }
    }

    private boolean shouldDespawn() {
        if (PixelmonConfig.despawnOnFleeOrLoss) {
            if (this.bc.rules.battleType == EnumBattleType.Single) {
                if (this.bc.getOpponents(this).get(0) instanceof PlayerParticipant) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    @Override
    public void getNextPokemon(int position) {
    }

    @Override
    public int[] getNextPokemonID() {
        return null;
    }

    @Override
    public TextComponentBase getName() {
        String key = "";
        if (!this.controlledPokemon.isEmpty()) {
            key = "pixelmon." + ((PixelmonWrapper)this.controlledPokemon.get((int)0)).pokemon.getLocalizedName().toLowerCase() + ".name";
        }
        return new TextComponentTranslation(key, new Object[0]);
    }

    @Override
    public MoveChoice getMove(PixelmonWrapper pw) {
        if (this.bc == null) {
            return null;
        }
        if (!pw.getMoveset().isEmpty()) {
            return this.getBattleAI().getNextMove(pw);
        }
        this.bc.setFlee(pw.getPokemonID());
        return null;
    }

    @Override
    public PixelmonWrapper switchPokemon(PixelmonWrapper pw, int[] newPixelmonId) {
        return null;
    }

    @Override
    public boolean checkPokemon() {
        boolean allGood = true;
        for (PixelmonWrapper pw : this.controlledPokemon) {
            if (!pw.getMoveset().isEmpty()) continue;
            pw.pokemon.loadMoveset();
            pw.reloadMoveset();
            if (!pw.getMoveset().isEmpty()) continue;
            if (PixelmonConfig.printErrors) {
                Pixelmon.LOGGER.info("Couldn't load " + pw.pokemon.getLocalizedName() + "'s moves.");
            }
            allGood = false;
        }
        return allGood;
    }

    @Override
    public void updatePokemon(PixelmonWrapper pw) {
    }

    public EntityLiving getEntity() {
        if (this.controlledPokemon.isEmpty()) {
            return null;
        }
        return ((PixelmonWrapper)this.controlledPokemon.get((int)0)).pokemon;
    }

    @Override
    public void updateOtherPokemon() {
    }

    @Override
    public void setPosition(double[] ds) {
    }

    @Override
    public String getDisplayName() {
        Iterator iterator = this.controlledPokemon.iterator();
        if (iterator.hasNext()) {
            PixelmonWrapper pw = (PixelmonWrapper)iterator.next();
            return pw.getNickname();
        }
        return super.getDisplayName();
    }
}

