/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.rules.clauses;

import com.pixelmonmod.pixelmon.battles.rules.clauses.AbilityClause;
import com.pixelmonmod.pixelmon.battles.rules.clauses.AbilityComboClause;
import com.pixelmonmod.pixelmon.battles.rules.clauses.BatonPass1Clause;
import com.pixelmonmod.pixelmon.battles.rules.clauses.BattleClause;
import com.pixelmonmod.pixelmon.battles.rules.clauses.BattleClauseAny;
import com.pixelmonmod.pixelmon.battles.rules.clauses.BattleClauseSingleAll;
import com.pixelmonmod.pixelmon.battles.rules.clauses.ItemClause;
import com.pixelmonmod.pixelmon.battles.rules.clauses.ItemPreventClause;
import com.pixelmonmod.pixelmon.battles.rules.clauses.MoveClause;
import com.pixelmonmod.pixelmon.battles.rules.clauses.PokemonClause;
import com.pixelmonmod.pixelmon.battles.rules.clauses.SkyBattle;
import com.pixelmonmod.pixelmon.battles.rules.clauses.SpeciesClause;
import com.pixelmonmod.pixelmon.battles.rules.clauses.SpeedPassClause;
import com.pixelmonmod.pixelmon.battles.rules.clauses.tiers.EnumTier;
import com.pixelmonmod.pixelmon.battles.rules.clauses.tiers.Tier;
import com.pixelmonmod.pixelmon.battles.rules.clauses.tiers.TierHierarchical;
import com.pixelmonmod.pixelmon.battles.rules.teamselection.TeamSelection;
import com.pixelmonmod.pixelmon.entities.npcs.registry.PokemonForm;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Chlorophyll;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Drizzle;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Drought;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Moody;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.SandRush;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.SandStream;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.SandVeil;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.ShadowTag;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.SnowCloak;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.SnowWarning;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.SwiftSwim;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public final class BattleClauseRegistry<T extends BattleClause> {
    private final Map<String, T> clauses = new HashMap<String, T>();
    private final List<T> customClauses = new ArrayList<T>();
    public static final String BAG_CLAUSE = "bag";
    public static final String FORFEIT_CLAUSE = "forfeit";
    public static final String INVERSE_BATTLE = "inverse";
    public static final String SKY_BATTLE = "sky";
    public static final String SLEEP_CLAUSE = "sleep";
    private static int clauseVersion;
    private static final BattleClauseRegistry<BattleClause> clauseRegistry;
    private static final BattleClauseRegistry<Tier> tierRegistry;
    private Function<String, T> getDefault;

    private BattleClauseRegistry(Function<String, T> getDefault) {
        this.getDefault = getDefault;
    }

    public static BattleClauseRegistry<BattleClause> getClauseRegistry() {
        return clauseRegistry;
    }

    public static BattleClauseRegistry<Tier> getTierRegistry() {
        return tierRegistry;
    }

    private static void registerDefaultClauses() {
        super.registerClause(new BattleClause(BAG_CLAUSE));
        MoveClause batonPassClause = new MoveClause("batonpass", "Baton Pass");
        super.registerClause(batonPassClause);
        super.registerClause(new BatonPass1Clause());
        super.registerClause(new MoveClause("chatter", "Chatter"));
        super.registerClause(new AbilityClause("drizzle", Drizzle.class));
        AbilityComboClause drizzleSwimClause = new AbilityComboClause("drizzleswim", Drizzle.class, SwiftSwim.class);
        super.registerClause(drizzleSwimClause);
        super.registerClause(new AbilityClause("drought", Drought.class));
        super.registerClause(new BattleClauseSingleAll("endlessbattle", new ItemPreventClause("", EnumHeldItems.leppa), new MoveClause("", "Recycle"), new MoveClause("", "Fling", "Heal Pulse", "Pain Split")));
        super.registerClause(new AbilityClause("evasionability", SandVeil.class, SnowCloak.class));
        super.registerClause(new MoveClause("evasion", "Double Team", "Minimize"));
        super.registerClause(new BattleClause(FORFEIT_CLAUSE));
        super.registerClause(new BattleClause(INVERSE_BATTLE));
        super.registerClause(new ItemClause());
        super.registerClause(new PokemonClause("legendary", EnumPokemon.LEGENDARY_ENUMS));
        super.registerClause(new ItemPreventClause("mega", EnumHeldItems.megaStone));
        super.registerClause(new AbilityClause("moody", Moody.class));
        super.registerClause(new MoveClause("ohko", "Fissure", "Guillotine", "Horn Drill", "Sheer Cold"));
        super.registerClause(new AbilityClause("sandstream", SandStream.class));
        super.registerClause(new AbilityClause("shadowtag", ShadowTag.class));
        super.registerClause(new SkyBattle());
        super.registerClause(new BattleClause(SLEEP_CLAUSE));
        super.registerClause(new BattleClauseSingleAll("smashpass", batonPassClause, new MoveClause("", "Shell Smash")));
        super.registerClause(new AbilityClause("snowwarning", SnowWarning.class));
        super.registerClause(new BattleClauseSingleAll("souldew", new PokemonClause("", EnumPokemon.Latias, EnumPokemon.Latios), new ItemPreventClause("", EnumHeldItems.soulDew)));
        super.registerClause(new SpeciesClause());
        super.registerClause(new SpeedPassClause());
        super.registerClause(new MoveClause("swagger", "Swagger"));
        super.registerClause(new BattleClauseAny("weatherspeed", drizzleSwimClause, new AbilityComboClause("", Drought.class, Chlorophyll.class), new AbilityComboClause("", SandStream.class, SandRush.class)));
    }

    private static void registerDefaultTiers() {
        TierHierarchical lastTier = null;
        for (EnumTier tier : EnumTier.values()) {
            lastTier = new TierHierarchical(tier.getTierID(), new HashSet<PokemonForm>(), lastTier);
            super.registerClause(lastTier);
        }
    }

    public T getClause(String id) {
        BattleClause clause = (BattleClause)this.clauses.get(id);
        if (clause == null) {
            clause = (BattleClause)this.getDefault.apply(id);
        }
        return (T)clause;
    }

    public boolean hasClause(String id) {
        return this.clauses.containsKey(id);
    }

    private void registerClause(T newClause) {
        String newClauseID = ((BattleClause)newClause).getID();
        if (newClauseID == null || newClauseID.isEmpty()) {
            throw new IllegalArgumentException("Clause must have a key to be registered.");
        }
        if (this.clauses.containsKey(newClauseID)) {
            throw new IllegalArgumentException("Clause is already registered: " + newClauseID);
        }
        for (String reserved : TeamSelection.getReservedKeys()) {
            if (!reserved.equals(newClauseID)) continue;
            throw new IllegalArgumentException("Clause cannot used reserved ID: " + reserved);
        }
        this.clauses.put(newClauseID, newClause);
    }

    public void registerCustomClause(T newClause) {
        this.registerClause(newClause);
        this.customClauses.add(newClause);
        BattleClauseRegistry.incrementVersion();
    }

    public static void incrementVersion() {
        ++clauseVersion;
    }

    public void replaceCustomClauses(List<T> newClauses) {
        this.replaceCustomClauses(newClauses, clauseVersion + 1);
    }

    public void replaceCustomClauses(List<T> newClauses, int newClauseVersion) {
        this.removeCustomClauses();
        for (BattleClause clause : newClauses) {
            this.registerCustomClause(clause);
        }
        clauseVersion = newClauseVersion;
    }

    public void removeCustomClauses() {
        for (BattleClause clause : this.customClauses) {
            this.clauses.remove(clause.getID());
        }
        this.customClauses.clear();
    }

    public List<T> getCustomClauses() {
        return new ArrayList<T>(this.customClauses);
    }

    public List<T> getClauseList() {
        ArrayList<T> clauseList = new ArrayList<T>();
        clauseList.addAll(this.clauses.values());
        Collections.sort(clauseList);
        return clauseList;
    }

    public static int getClauseVersion() {
        return clauseVersion;
    }

    static {
        clauseRegistry = new BattleClauseRegistry<BattleClause>(id -> new BattleClause((String)id));
        tierRegistry = new BattleClauseRegistry<Tier>(id -> null);
        BattleClauseRegistry.registerDefaultClauses();
        BattleClauseRegistry.registerDefaultTiers();
    }
}

