/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.rules.clauses.tiers;

import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.rules.clauses.BattleClause;
import com.pixelmonmod.pixelmon.entities.npcs.registry.PokemonForm;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity3HasStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import com.pixelmonmod.pixelmon.items.heldItems.ItemMegaStone;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class Tier
extends BattleClause {
    protected Predicate<PokemonForm> condition;
    private static final Set<EnumPokemon> ignoreForms = new HashSet<EnumPokemon>(Arrays.asList(EnumPokemon.Burmy, EnumPokemon.Castform, EnumPokemon.Gastrodon, EnumPokemon.Shellos, EnumPokemon.Unown));

    public Tier(String id) {
        this(id, p -> true);
    }

    public Tier(String id, Predicate<PokemonForm> condition) {
        super(id);
        this.condition = condition;
    }

    @Override
    public final boolean validateSingle(PokemonLink pokemon) {
        ItemHeld heldItem;
        PokemonForm pokemonForm = pokemon.getPokemonForm();
        EnumPokemon species = pokemonForm.pokemon;
        if (pokemonForm.form != -1 && (ignoreForms.contains((Object)species) || !Entity3HasStats.hasForms(species))) {
            pokemonForm.form = -1;
        }
        if (PixelmonWrapper.canMegaEvolve(heldItem = pokemon.getHeldItem(), species, pokemonForm.form) && heldItem instanceof ItemMegaStone) {
            ItemMegaStone megaStone = (ItemMegaStone)heldItem;
            pokemonForm.form = megaStone.form;
        }
        return this.condition.test(pokemonForm);
    }

    @Override
    public final boolean validateTeam(List<PokemonLink> team) {
        return super.validateTeam(team);
    }

    public String getTierDescription() {
        return this.getLocalizedName();
    }
}

