/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.rules.teamselection;

import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.NBTLink;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;

class ParticipantSelection {
    final PlayerStorage storage;
    List<PokemonLink> team = new ArrayList<PokemonLink>();
    final boolean isNPC;
    boolean confirmed;
    String[] disabled = new String[6];

    ParticipantSelection(PlayerStorage storage) {
        this.storage = storage;
        boolean bl = this.isNPC = storage.trainer != null;
        if (this.isNPC) {
            this.confirmed = true;
        }
    }

    void setTeam(int[] selection) {
        ArrayList<PokemonLink> team = new ArrayList<PokemonLink>();
        for (int s : selection) {
            if (s <= -1) continue;
            team.add(null);
        }
        for (int i = 0; i < selection.length; ++i) {
            int s = selection[i];
            if (s <= -1) continue;
            NBTTagCompound nbt = this.storage.partyPokemon[i];
            if (nbt == null) {
                return;
            }
            team.set(s, new NBTLink(nbt, this.storage));
        }
        for (PokemonLink link : team) {
            if (link != null) continue;
            return;
        }
        this.team = team;
    }

    void addTeamMember(int index) {
        NBTTagCompound nbt = this.storage.partyPokemon[index];
        if (PlayerStorage.canBattle(nbt)) {
            this.team.add(new NBTLink(nbt, this.storage));
        }
    }

    void removeTeamMember() {
        if (!this.team.isEmpty()) {
            this.team.remove(this.team.size() - 1);
        }
    }
}

