/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.enums.EnumType;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.util.text.TextComponentTranslation;

public class Confusion
extends StatusBase {
    private int effectTurns = RandomHelper.getRandomNumberBetween(2, 5);

    public Confusion() {
        super(StatusType.Confusion);
    }

    @Override
    protected void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        TextComponentTranslation message;
        if (this.checkChance() && !target.addStatus(new Confusion(), user, message = ChatHandler.getMessage("pixelmon.effect.becameconfused", target.getNickname())) && user.hasStatus(StatusType.Confusion) && user.attack.baseAttack.attackCategory == 2) {
            user.bc.sendToAll("pixelmon.effect.alreadyconfused", target.getNickname());
            user.attack.moveResult.result = AttackResult.failed;
        }
    }

    @Override
    public boolean canAttackThisTurn(PixelmonWrapper user, Attack a) {
        if (--this.effectTurns <= 0) {
            user.removeStatus(this);
            return true;
        }
        user.bc.sendToAll("pixelmon.status.confused", user.getNickname());
        if (RandomHelper.getRandomChance(0.25f)) {
            user.bc.sendToAll("pixelmon.status.confusionhurtself", user.getNickname());
            user.doBattleDamage(user, this.calculateConfusionDamage(user), DamageTypeEnum.STATUS);
            return false;
        }
        return true;
    }

    private int calculateConfusionDamage(PixelmonWrapper user) {
        Attack attack = new Attack(new AttackBase(EnumType.Mystery, 40, 0));
        return attack.doDamageCalc(user, user, 1.0);
    }

    @Override
    public String getCureMessage() {
        return "pixelmon.status.confusionsnap";
    }

    @Override
    public String getCureMessageItem() {
        return "pixelmon.status.confusioncureitem";
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        boolean hitsAlly = userChoice.hitsAlly();
        boolean offensive = userChoice.isOffensiveMove();
        if (!hitsAlly) {
            Iterator<PixelmonWrapper> var9 = userChoice.targets.iterator();
            while (true) {
                if (!var9.hasNext()) {
                    return;
                }
                PixelmonWrapper target = var9.next();
                if (offensive && hitsAlly || !target.addStatus(new Confusion(), pw)) continue;
                userChoice.raiseWeight(this.getWeightWithChance(40.0f));
            }
        }
    }
}

