/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import java.util.ArrayList;
import net.minecraft.util.text.TextComponentTranslation;

public class Disable
extends StatusBase {
    Attack disabledMove;
    int effectiveTurns = 4;

    public Disable() {
        super(StatusType.Disable);
    }

    public Disable(Attack attack) {
        super(StatusType.Disable);
        this.disabledMove = attack;
    }

    @Override
    protected void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        Attack lastAttack = target.lastAttack;
        if (target.hasStatus(StatusType.Disable)) {
            target.bc.sendToAll("pixelmon.effect.alreadydisabled", target.getNickname());
            user.attack.moveResult.result = AttackResult.failed;
            return;
        }
        if (lastAttack != null) {
            TextComponentTranslation message = ChatHandler.getMessage("pixelmon.status.disable", target.getNickname(), lastAttack.baseAttack.getLocalizedName());
            target.addStatus(new Disable(lastAttack), user, message);
        } else {
            target.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
        }
    }

    @Override
    public boolean canAttackThisTurn(PixelmonWrapper user, Attack a) {
        if (a.equals(this.disabledMove)) {
            user.bc.sendToAll("pixelmon.status.disabled", user.getNickname(), a.baseAttack.getLocalizedName());
            return false;
        }
        return true;
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        if (--this.effectiveTurns <= 0) {
            pw.bc.sendToAll("pixelmon.status.nolongerdisabled", pw.getNickname(), this.disabledMove.baseAttack.getLocalizedName());
            pw.removeStatus(this);
        } else {
            pw.getMoveset().stream().filter(attack -> attack.equals(this.disabledMove)).forEach(attack -> attack.setDisabled(true, pw));
        }
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        for (PixelmonWrapper target : userChoice.targets) {
            String attackName;
            String string = attackName = target.lastAttack == null ? "" : target.lastAttack.baseAttack.getLocalizedName();
            if (!MoveChoice.canOutspeed(bestOpponentChoices, pw, bestUserChoices) && !MoveChoice.hasSuccessfulAttackChoice(bestOpponentChoices, attackName)) continue;
            userChoice.raiseWeight(40.0f);
        }
    }
}

