/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Sleep;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Terrain;
import com.pixelmonmod.pixelmon.battles.status.Yawn;
import com.pixelmonmod.pixelmon.enums.EnumType;
import java.util.List;

public class ElectricTerrain
extends Terrain {
    public ElectricTerrain() {
        super(StatusType.ElectricTerrain, "pixelmon.status.electricterrain", "pixelmon.status.electricterrainend");
    }

    @Override
    public Terrain getNewInstance() {
        return new ElectricTerrain();
    }

    @Override
    public int[] modifyPowerAndAccuracyTarget(int power, int accuracy, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        if (this.affectsPokemon(user) && a.baseAttack.attackType == EnumType.Electric) {
            power = (int)((double)power * 1.5);
        }
        return new int[]{power, accuracy};
    }

    @Override
    public boolean stopsStatusChange(StatusType t, PixelmonWrapper target, PixelmonWrapper user) {
        if (this.affectsPokemon(user) && (t == StatusType.Sleep || t == StatusType.Yawn)) {
            if (user != target && user.attack.baseAttack.attackCategory == 2) {
                target.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            }
            return true;
        }
        return false;
    }

    @Override
    protected int countBenefits(PixelmonWrapper user, PixelmonWrapper target) {
        int benefits = 0;
        if (this.affectsPokemon(target)) {
            List<Attack> moveset = user.getBattleAI().getMoveset(target);
            if (Attack.hasOffensiveAttackType(moveset, EnumType.Electric)) {
                ++benefits;
            }
            if (target.hasStatus(StatusType.Yawn)) {
                ++benefits;
            }
            if (Attack.hasAttack(moveset, "Rest")) {
                --benefits;
            }
            block0: for (Attack move : moveset) {
                for (EffectBase e : move.baseAttack.effects) {
                    if (!(e instanceof Sleep) && !(e instanceof Yawn)) continue;
                    --benefits;
                    continue block0;
                }
            }
        }
        return benefits;
    }
}

