/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Protect;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.ArrayList;

public class MatBlock
extends StatusBase {
    public MatBlock() {
        super(StatusType.MatBlock);
    }

    @Override
    protected void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.isFirstTurn() && !user.bc.isLastMover() && user.addTeamStatus(new MatBlock(), user)) {
            user.bc.sendToAll("pixelmon.status.matblock", user.getNickname());
        } else {
            user.bc.sendToAll("pixelmon.effect.effectfailed", user.getNickname());
            user.attack.moveResult.result = AttackResult.failed;
        }
    }

    @Override
    public boolean isTeamStatus() {
        return true;
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        pw.removeTeamStatus(this);
    }

    @Override
    public boolean stopsIncomingAttack(PixelmonWrapper pokemon, PixelmonWrapper user) {
        return user.attack.baseAttack.attackCategory != 2;
    }

    @Override
    public void stopsIncomingAttackMessage(PixelmonWrapper pokemon, PixelmonWrapper user) {
        user.bc.sendToAll("pixelmon.status.matblocked", pokemon.attack.baseAttack.getLocalizedName());
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        for (ArrayList<MoveChoice> choices : MoveChoice.splitChoices(pw.getOpponentPokemon(), bestOpponentChoices)) {
            if (!MoveChoice.canOutspeed(choices, pw, bestUserChoices)) continue;
            return;
        }
        Protect protect = new Protect();
        protect.weightEffect(pw, userChoice, userChoices, bestUserChoices, opponentChoices, bestOpponentChoices);
        if (pw.bc.rules.battleType.numPokemon > 1) {
            userChoice.raiseWeight(20 * pw.bc.rules.battleType.numPokemon);
        }
    }
}

