/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.Feint;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Vanish;

public abstract class ProtectVariation
extends StatusBase {
    public ProtectVariation(StatusType type) {
        super(type);
    }

    @Override
    protected void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.bc.simulateMode) {
            return;
        }
        float successChance = 1.0f / (float)Math.pow(3.0, user.protectsInARow);
        boolean successful = true;
        if (this.canFail()) {
            successful = RandomHelper.getRandomChance(successChance);
        }
        boolean bl = successful = successful && !user.bc.isLastMover() && this.addStatus(user);
        if (successful) {
            if (user.protectsInARow < 6) {
                ++user.protectsInARow;
            }
            this.displayMessage(user);
        } else {
            user.protectsInARow = 0;
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
        }
    }

    @Override
    public boolean stopsIncomingAttack(PixelmonWrapper pokemon, PixelmonWrapper user) {
        if (user.attack.baseAttack.targetingInfo.hitsAll && user.attack.baseAttack.targetingInfo.hitsSelf) {
            return false;
        }
        if (!pokemon.getTeamPokemon().contains(user)) {
            for (EffectBase e : user.attack.baseAttack.effects) {
                if (!(e instanceof Vanish) && !(e instanceof Feint)) continue;
                return false;
            }
        }
        return true;
    }

    protected abstract boolean addStatus(PixelmonWrapper var1);

    protected abstract void displayMessage(PixelmonWrapper var1);

    protected boolean canFail() {
        return true;
    }
}

