/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Weather;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Chlorophyll;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.DrySkin;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.FlowerGift;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Harvest;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.LeafGuard;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.SolarPower;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import java.util.List;

public class Sunny
extends Weather {
    public Sunny() {
        this(5);
    }

    public Sunny(int turnsToGo) {
        super(StatusType.Sunny, turnsToGo, EnumHeldItems.heatRock, "pixelmon.effect.harshsunlight", "pixelmon.status.brightlight", "pixelmon.status.sunlightfaded");
    }

    @Override
    protected Weather getNewInstance(int turns) {
        return new Sunny(turns);
    }

    @Override
    public int[] modifyPowerAndAccuracyTarget(int power, int accuracy, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        if (a.baseAttack.attackType == EnumType.Fire) {
            power = (int)((double)power * 1.5);
        } else if (a.baseAttack.attackType == EnumType.Water) {
            power = (int)((double)power * 0.5);
        }
        return new int[]{power, accuracy};
    }

    @Override
    protected int countBenefits(PixelmonWrapper user, PixelmonWrapper target) {
        int benefits = 0;
        AbilityBase ability = target.getBattleAbility();
        if (ability instanceof Chlorophyll || ability instanceof FlowerGift || ability instanceof Harvest || ability instanceof LeafGuard || ability instanceof SolarPower) {
            ++benefits;
        } else if (ability instanceof DrySkin) {
            --benefits;
        }
        List<Attack> moveset = user.getBattleAI().getMoveset(target);
        if (Attack.hasOffensiveAttackType(moveset, EnumType.Fire) || Attack.hasAttack(moveset, "Weather Ball")) {
            ++benefits;
        }
        if (Attack.hasAttack(moveset, "SolarBeam")) {
            ++benefits;
        }
        if (Attack.hasAttack(moveset, "Moonlight", "Morning Sun", "Synthesis")) {
            ++benefits;
        }
        if (Attack.hasAttack(moveset, "Growth")) {
            ++benefits;
        }
        if (Attack.hasOffensiveAttackType(moveset, EnumType.Water)) {
            --benefits;
        }
        if (Attack.hasAttack(moveset, "Hurricane")) {
            --benefits;
        }
        if (Attack.hasAttack(moveset, "Thunder")) {
            --benefits;
        }
        return benefits;
    }
}

