/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.ProtectVariationTeam;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.ArrayList;

public class WideGuard
extends ProtectVariationTeam {
    public WideGuard() {
        super(StatusType.WideGuard);
    }

    @Override
    public ProtectVariationTeam getNewInstance() {
        return new WideGuard();
    }

    @Override
    protected void displayMessage(PixelmonWrapper user) {
        user.bc.sendToAll("pixelmon.status.wideguard", user.getNickname());
    }

    @Override
    public boolean stopsIncomingAttack(PixelmonWrapper pokemon, PixelmonWrapper user) {
        return super.stopsIncomingAttack(pokemon, user) && user.attack.baseAttack.attackCategory != 2 && user.attack.baseAttack.targetingInfo.hitsAll && user.attack.baseAttack.targetingInfo.hitsAdjacentFoe;
    }

    @Override
    public void stopsIncomingAttackMessage(PixelmonWrapper pokemon, PixelmonWrapper user) {
        user.bc.sendToAll("pixelmon.status.wideguardprotect", pokemon.getNickname());
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        if (MoveChoice.canBreakProtect(pw.getOpponentPokemon(), bestOpponentChoices)) {
            return;
        }
        if (pw.bc.rules.battleType.numPokemon > 1 && MoveChoice.hasSpreadMove(bestOpponentChoices)) {
            userChoice.raiseWeight(75.0f);
        }
    }
}

