/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Sleep;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.ArrayList;

public class Yawn
extends StatusBase {
    int effectTurns = 0;

    public Yawn() {
        super(StatusType.Yawn);
    }

    @Override
    public boolean cantMiss(PixelmonWrapper user) {
        return true;
    }

    @Override
    protected void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (target.hasStatus(StatusType.Sleep)) {
            user.bc.sendToAll("pixelmon.effect.alreadysleeping", target.getNickname());
            user.attack.moveResult.result = AttackResult.failed;
        } else if (target.hasStatus(StatusType.Yawn)) {
            user.bc.sendToAll("pixelmon.effect.alreadydrowsy", target.getNickname());
            user.attack.moveResult.result = AttackResult.failed;
        } else if (!target.hasPrimaryStatus()) {
            if (target.addStatus(new Yawn(), user)) {
                user.bc.sendToAll("pixelmon.effect.becamedrowsy", target.getNickname());
            } else {
                user.attack.moveResult.result = AttackResult.failed;
            }
        } else {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            user.attack.moveResult.result = AttackResult.failed;
        }
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        if (++this.effectTurns >= 2) {
            if (pw.addStatus(new Sleep(), pw)) {
                pw.bc.sendToAll("pixelmon.status.fellasleep", pw.getNickname());
            }
            pw.removeStatus(this);
        }
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        if (!userChoice.hitsAlly()) {
            userChoice.raiseWeight(40.0f);
        }
    }
}

