/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.BerryEvent;
import com.pixelmonmod.pixelmon.blocks.GenericRotatableModelBlock;
import com.pixelmonmod.pixelmon.blocks.enums.EnumBlockPos;
import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityBerryTree;
import com.pixelmonmod.pixelmon.enums.EnumBerry;
import com.pixelmonmod.pixelmon.util.helpers.BlockHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BlockBerryTree
extends GenericRotatableModelBlock
implements IGrowable,
IPlantable {
    public static final PropertyEnum<EnumBlockPos> BLOCKPOS = PropertyEnum.func_177709_a((String)"blockpos", EnumBlockPos.class);
    private final byte ordinal;

    public BlockBerryTree(EnumBerry type) {
        super(Material.field_151575_d);
        this.ordinal = (byte)type.ordinal();
    }

    public Material func_149688_o(IBlockState state) {
        return Material.field_151585_k;
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        TileEntityBerryTree tile;
        if (state.func_177229_b(BLOCKPOS) == EnumBlockPos.TOP) {
            pos = pos.func_177977_b();
        }
        if ((tile = BlockHelper.getTileEntity(TileEntityBerryTree.class, (IBlockAccess)world, pos)) != null && tile.getStage() < 2) {
            return 1.0f;
        }
        return 2.0f;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(this.getType().getBerry());
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        TileEntityBerryTree tile = BlockHelper.getTileEntity(TileEntityBerryTree.class, world, pos);
        if (tile == null) {
            return drops;
        }
        byte stage = tile.getStage();
        if (stage > 1 && stage < 5) {
            return drops;
        }
        if (world instanceof World) {
            ItemStack stack = new ItemStack(tile.getType().getBerry());
            stack.func_190920_e((int)(stage == 1 ? (short)1 : tile.getProjectedYield()));
            drops.add(stack);
        }
        return drops;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        if (state.func_177229_b(BLOCKPOS) == EnumBlockPos.BOTTOM) {
            return new TileEntityBerryTree(this.ordinal);
        }
        return null;
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return null;
    }

    public EnumBerry getType() {
        return EnumBerry.values()[this.ordinal];
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityBerryTree tile;
        if (world.field_72995_K) {
            return true;
        }
        if (state.func_177229_b(BLOCKPOS) == EnumBlockPos.TOP) {
            pos = pos.func_177977_b();
            state = world.func_180495_p(pos);
        }
        if ((tile = BlockHelper.getTileEntity(TileEntityBerryTree.class, (IBlockAccess)world, pos)) == null) {
            return false;
        }
        byte stage = tile.getStage();
        if (stage == 5) {
            Item berry = EnumBerry.values()[this.ordinal].getBerry();
            if (berry == null) {
                return true;
            }
            this.removedByPlayer(state, world, pos, player, false);
            return true;
        }
        return false;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, BLOCKPOS});
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int b0 = 0;
        int i = b0 | ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        return i |= ((EnumBlockPos)((Object)state.func_177229_b(BLOCKPOS))).toMeta() << 2;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a(BLOCKPOS, (Comparable)((Object)EnumBlockPos.fromMeta((meta & 0xF) >> 2)));
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        if (placer instanceof EntityPlayer) {
            ItemBlock.func_179224_a((World)worldIn, (EntityPlayer)((EntityPlayer)placer), (BlockPos)pos, (ItemStack)stack);
        }
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        TileEntityBerryTree tile;
        EnumBlockPos blockpos = (EnumBlockPos)((Object)state.func_177229_b(BLOCKPOS));
        BlockPos loc = pos;
        if (blockpos == EnumBlockPos.TOP) {
            loc = pos.func_177977_b();
        }
        return (tile = BlockHelper.getTileEntity(TileEntityBerryTree.class, (IBlockAccess)world, loc)) != null && !tile.isGrowthBoosted() && tile.getStage() != 5;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return this.func_176473_a(worldIn, pos, state, worldIn.field_72995_K);
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        TileEntityBerryTree tile;
        EnumBlockPos blockpos = (EnumBlockPos)((Object)state.func_177229_b(BLOCKPOS));
        BlockPos loc = pos;
        if (blockpos == EnumBlockPos.TOP) {
            loc = pos.func_177977_b();
        }
        if ((tile = BlockHelper.getTileEntity(TileEntityBerryTree.class, (IBlockAccess)world, loc)) != null) {
            tile.boostGrowth();
        }
    }

    public void growStage(World world, Random rand, BlockPos pos, IBlockState state) {
        TileEntityBerryTree tile;
        EnumBlockPos blockpos = (EnumBlockPos)((Object)state.func_177229_b(BLOCKPOS));
        if (blockpos == EnumBlockPos.TOP) {
            pos = pos.func_177977_b();
        }
        if ((tile = BlockHelper.getTileEntity(TileEntityBerryTree.class, (IBlockAccess)world, pos)) == null) {
            return;
        }
        int stage = tile.getStage();
        if (stage < 5) {
            tile.setStage((byte)(++stage));
            if (stage == 5) {
                Pixelmon.EVENT_BUS.post((Event)new BerryEvent.BerryReady(this.getType(), pos, tile));
            }
            if (stage >= 3 && world.func_180495_p(pos.func_177984_a()).func_177230_c() != this && this.getType().height > 1) {
                world.func_180501_a(pos.func_177984_a(), state.func_177226_a(BLOCKPOS, (Comparable)((Object)EnumBlockPos.TOP)), 2);
            }
            ((WorldServer)world).func_184164_w().func_180244_a(pos);
        }
    }

    public void replant(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityBerryTree tile;
        EnumBlockPos blockpos = (EnumBlockPos)((Object)state.func_177229_b(BLOCKPOS));
        if (blockpos == EnumBlockPos.TOP) {
            pos = pos.func_177977_b();
        }
        if ((tile = BlockHelper.getTileEntity(TileEntityBerryTree.class, (IBlockAccess)worldIn, pos)) == null) {
            return;
        }
        byte stage = tile.getStage();
        tile.setStage((byte)1);
        if (stage >= 3 && this.getType().height > 1) {
            worldIn.func_175656_a(pos.func_177984_a(), Blocks.field_150350_a.func_176223_P());
        }
        ((WorldServer)worldIn).func_184164_w().func_180244_a(pos);
    }

    public boolean canBlockStay(World worldIn, BlockPos pos, IBlockState state) {
        BlockPos down = pos.func_177977_b();
        Block soil = worldIn.func_180495_p(down).func_177230_c();
        if (soil == this) {
            soil = worldIn.func_180495_p(down.func_177977_b()).func_177230_c();
        }
        return this.canPlaceBlockOn(soil);
    }

    protected void checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(worldIn, pos, state)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    protected boolean canPlaceBlockOn(Block ground) {
        return ground == Blocks.field_150349_c || ground == Blocks.field_150346_d || ground == Blocks.field_150458_ak;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        BlockPos upPos;
        EnumBlockPos multiPos = (EnumBlockPos)((Object)state.func_177229_b(BLOCKPOS));
        if (multiPos == EnumBlockPos.TOP) {
            pos = pos.func_177977_b();
        }
        this.func_176226_b(world, pos, state, 0);
        if (world.func_180495_p(pos).func_177230_c() != this) {
            world.func_180501_a(pos.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 3);
            return super.removedByPlayer(state, world, pos, player, willHarvest);
        }
        if (this.getType().height > 1 && world.func_180495_p(upPos = pos.func_177984_a()).func_177230_c() == this) {
            world.func_180501_a(upPos, Blocks.field_150350_a.func_176223_P(), 3);
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Plains;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_176223_P();
        }
        return state;
    }

    public boolean canGrowStage(World worldObj, BlockPos pos, IBlockState state, int stage) {
        IBlockState topBlock;
        if (stage != 2 || this.getType().height == 1) {
            return true;
        }
        EnumBlockPos blockpos = (EnumBlockPos)((Object)state.func_177229_b(BLOCKPOS));
        BlockPos loc = pos;
        if (blockpos == EnumBlockPos.BOTTOM) {
            loc = pos.func_177984_a();
        }
        return (topBlock = worldObj.func_180495_p(loc)).func_177230_c() == Blocks.field_150350_a && worldObj.func_175678_i(pos.func_177984_a());
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkAndDropBlock(worldIn, pos, state);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.checkAndDropBlock(worldIn, pos, state);
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }
}

