/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.blocks.GenericModelBlock;
import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityPicketFenceNormal;
import com.pixelmonmod.pixelmon.config.PixelmonBlocks;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemLead;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPicketFence
extends GenericModelBlock {
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    protected static final AxisAlignedBB[] BOUNDING_BOXES = new AxisAlignedBB[]{new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.375, 0.625, 1.0, 0.625), new AxisAlignedBB(0.0, 0.0, 0.375, 0.625, 1.0, 1.0), new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 0.625), new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.625, 1.0, 0.625), new AxisAlignedBB(0.0, 0.0, 0.0, 0.625, 1.0, 1.0), new AxisAlignedBB(0.375, 0.0, 0.375, 1.0, 1.0, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625), new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 1.0), new AxisAlignedBB(0.375, 0.0, 0.0, 1.0, 1.0, 0.625), new AxisAlignedBB(0.375, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.625), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};
    public static final AxisAlignedBB PILLAR_AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.5, 0.625);
    public static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.375, 0.0, 0.625, 0.625, 1.5, 1.0);
    public static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.375, 0.375, 1.5, 0.625);
    public static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.5, 0.375);
    public static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.625, 0.0, 0.375, 1.0, 1.5, 0.625);

    public BlockPicketFence() {
        super(Material.field_151575_d);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149663_c("picket_fence_normal");
    }

    public void addCollisionBoxToList(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn) {
        state = state.func_185899_b((IBlockAccess)worldIn, pos);
        BlockPicketFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)PILLAR_AABB);
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            BlockPicketFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            BlockPicketFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            BlockPicketFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            BlockPicketFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST_AABB);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = this.func_176221_a(state, source, pos);
        return BOUNDING_BOXES[BlockPicketFence.getBoundingBoxIdx(state)];
    }

    private static int getBoundingBoxIdx(IBlockState state) {
        int i = 0;
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            i |= 1 << EnumFacing.NORTH.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            i |= 1 << EnumFacing.EAST.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            i |= 1 << EnumFacing.SOUTH.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            i |= 1 << EnumFacing.WEST.func_176736_b();
        }
        return i;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public boolean canConnectTo(IBlockAccess worldIn, BlockPos pos) {
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        return block instanceof BlockPicketFence;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return worldIn.field_72995_K || ItemLead.func_180618_a((EntityPlayer)playerIn, (World)worldIn, (BlockPos)pos);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos.func_177978_c()))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos.func_177974_f()))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos.func_177968_d()))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos.func_177976_e())));
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)EAST)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)NORTH));
            }
            case CLOCKWISE_90: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)NORTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)EAST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)SOUTH));
            }
        }
        return state;
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH));
            }
            case FRONT_BACK: {
                return state.func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)EAST));
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, WEST, SOUTH});
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(PixelmonItems.picketFenceItem);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return PixelmonBlocks.itemMapping.get((Object)this);
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityPicketFenceNormal();
    }
}

