/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.achievement.PixelmonAchievements;
import com.pixelmonmod.pixelmon.api.enums.ReceiveType;
import com.pixelmonmod.pixelmon.api.events.PixelmonReceivedEvent;
import com.pixelmonmod.pixelmon.blocks.BlockPokegift;
import com.pixelmonmod.pixelmon.blocks.PokeGiftHandler;
import com.pixelmonmod.pixelmon.blocks.tileEntities.EnumPokegiftType;
import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityPokegift;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.IVStore;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumNature;
import com.pixelmonmod.pixelmon.enums.EnumPokegiftEventType;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.items.EnumPokeballs;
import com.pixelmonmod.pixelmon.sounds.PixelSounds;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import com.pixelmonmod.pixelmon.util.helpers.BlockHelper;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BlockPokegiftEvent
extends BlockPokegift {
    public BlockPokegiftEvent(Class<? extends TileEntityPokegift> tileEntityClass) {
        super(tileEntityClass);
        this.TYPE = EnumPokegiftType.EVENT;
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K || hand == EnumHand.OFF_HAND) {
            return true;
        }
        if (PixelmonConfig.doPokegiftEvents) {
            TileEntityPokegift tile = BlockHelper.getTileEntity(TileEntityPokegift.class, (IBlockAccess)world, pos);
            UUID blockOwner = tile.getOwner();
            UUID playerID = player.func_110124_au();
            if (playerID != blockOwner) {
                state.func_177230_c().func_176201_c(state);
                if (tile.canClaim(playerID)) {
                    if (tile.shouldBreakBlock()) {
                        world.func_175698_g(pos);
                    }
                    if (tile.getSpecialPixelmon().isEmpty()) {
                        ChatHandler.sendChat((Entity)player, "pixelutilities.blocks.emptygift", this.itemName);
                        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187576_at, SoundCategory.BLOCKS, 0.7f, 1.0f);
                        return true;
                    }
                    ChatHandler.sendChat((Entity)player, "pixelmon.blocks.chestfound", this.itemName);
                    player.func_71064_a(PixelmonAchievements.pokeGift, 1);
                    Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage((EntityPlayerMP)player);
                    if (optstorage.isPresent()) {
                        for (EntityPixelmon p : tile.getSpecialPixelmon()) {
                            Pixelmon.EVENT_BUS.post((Event)new PixelmonReceivedEvent((EntityPlayerMP)player, ReceiveType.PokeBall, p));
                            optstorage.get().addToParty(p);
                        }
                    }
                    tile.addClaimer(playerID);
                    world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PixelSounds.pokelootObtained, SoundCategory.BLOCKS, 0.2f, 1.0f);
                } else {
                    ChatHandler.sendChat((Entity)player, "pixelmon.blocks.claimedloot", new Object[0]);
                }
            }
        } else {
            ChatHandler.sendChat((Entity)player, "pixelutilities.event.noevents", new Object[0]);
        }
        return true;
    }

    @Override
    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase player) {
        PokeGiftHandler handler = new PokeGiftHandler();
        if (handler.checkTime() == EnumPokegiftEventType.Christmas) {
            this.itemName = I18n.func_74838_a((String)"pixelmon.blocks.christmaspokegift");
        } else if (handler.checkTime() == EnumPokegiftEventType.Halloween) {
            this.itemName = I18n.func_74838_a((String)"pixelmon.blocks.halloweenpokegift");
        } else if (handler.checkTime() == EnumPokegiftEventType.Custom) {
            this.itemName = I18n.func_74838_a((String)"pixelmon.blocks.custompokegift");
        }
        return super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, player);
    }

    @Override
    public TileEntity func_149915_a(World world, int var1) {
        try {
            TileEntityPokegift tileP = (TileEntityPokegift)((Object)this.pokeChestTileEntityClass.newInstance());
            tileP.setChestOneTime(false);
            tileP.setOwner(null);
            tileP.setAllSpecialPixelmon(this.generatePixelmon(world));
            return tileP;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private ArrayList<EntityPixelmon> generatePixelmon(World world) {
        ArrayList<EntityPixelmon> pixelmon = new ArrayList<EntityPixelmon>();
        Random rng = world.field_73012_v;
        int max = PixelmonConfig.pokegiftEventMaxPokes;
        int numberToCreate = rng.nextInt(max);
        if (numberToCreate == 0 || numberToCreate > 6 || numberToCreate > max) {
            numberToCreate = 1;
        }
        for (int i = 0; i < numberToCreate; ++i) {
            String name = "";
            name = PixelmonConfig.pokegiftEventLegendaries ? EnumPokemon.randomPoke((boolean)false).name : EnumPokemon.randomPoke((boolean)true).name;
            EntityPixelmon p = (EntityPixelmon)PixelmonEntityList.createEntityByName(name, world);
            p.getLvl().setLevel(5);
            p.setGrowth(EnumGrowth.getRandomGrowth());
            if (PixelmonConfig.pokegiftEventShinies && rng.nextInt(PixelmonConfig.pokegiftEventShinyRate) == 0) {
                p.setIsShiny(true);
            }
            p.setNature(EnumNature.getRandomNature());
            p.caughtBall = EnumPokeballs.CherishBall;
            p.friendship.setFriendship(150);
            p.baseStats.baseFriendship = 150;
            IVStore.CreateNewIVs();
            pixelmon.add(p);
        }
        return pixelmon;
    }
}

