/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.blocks.BlockPokegift;
import com.pixelmonmod.pixelmon.blocks.tileEntities.EnumPokegiftType;
import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityPokegift;
import com.pixelmonmod.pixelmon.config.PixelmonBlocks;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.enums.EnumPokegiftEventType;
import com.pixelmonmod.pixelmon.spawning.EnumBiomeType;
import com.pixelmonmod.pixelmon.spawning.PixelmonBiomeDictionary;
import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkProviderServer;

public class PokeGiftHandler {
    private int x;
    private int y;
    private int z = 0;
    private BlockPos pos;
    Block underBlock;
    private Biome biome;
    private boolean goodBiome = true;
    private World world;
    private EnumPokegiftEventType type = EnumPokegiftEventType.None;
    List<String> coords = PixelmonConfig.pokegiftEventCoords;

    public void generate(World world) {
        this.type = this.checkTime();
        if (this.type == EnumPokegiftEventType.None) {
            return;
        }
        this.world = world;
        String[] blankArray = new String[]{"notConfigured"};
        if (!PixelmonConfig.pokegiftEventCoords.isEmpty()) {
            this.coords = PixelmonConfig.pokegiftEventCoords;
        }
        if (!this.coords.contains(blankArray)) {
            this.placeEvent(world);
        }
        BlockPos spawnPoint = world.func_175694_M();
        ChunkProviderServer ccServer = (ChunkProviderServer)world.func_72863_F();
        if (!ccServer.func_73149_a(spawnPoint.func_177958_n(), spawnPoint.func_177952_p())) {
            ccServer.func_186028_c(spawnPoint.func_177958_n(), spawnPoint.func_177952_p());
            if (!ccServer.func_73149_a(spawnPoint.func_177958_n(), spawnPoint.func_177952_p())) {
                return;
            }
        }
        if (this.type == EnumPokegiftEventType.Christmas) {
            this.x = spawnPoint.func_177958_n() + 5;
            this.z = spawnPoint.func_177952_p() + 5;
            this.y = world.func_175645_m(new BlockPos(this.x, 0, this.z)).func_177956_o();
            this.pos = new BlockPos(this.x, this.y, this.z);
            if (!this.verifyCoords()) {
                return;
            }
        } else if (this.type == EnumPokegiftEventType.Halloween) {
            this.x = spawnPoint.func_177958_n() - 5;
            this.z = spawnPoint.func_177952_p() - 5;
            this.y = world.func_175645_m(new BlockPos(this.x, 0, this.z)).func_177956_o();
            this.pos = new BlockPos(this.x, this.y, this.z);
            if (!this.verifyCoords()) {
                return;
            }
        } else if (this.type == EnumPokegiftEventType.Custom) {
            this.x = spawnPoint.func_177958_n() + 5;
            this.z = spawnPoint.func_177952_p() - 5;
            this.y = world.func_175645_m(new BlockPos(this.x, 0, this.z)).func_177956_o();
            this.pos = new BlockPos(this.x, this.y, this.z);
            if (!this.verifyCoords()) {
                return;
            }
        } else {
            return;
        }
        this.underBlock = world.func_180495_p(new BlockPos(this.pos.func_177958_n(), this.pos.func_177956_o() - 1, this.pos.func_177952_p())).func_177230_c();
        if (this.underBlock instanceof BlockPokegift) {
            PixelmonConfig.disableEventLoading();
            return;
        }
        this.biome = world.func_180494_b(new BlockPos(spawnPoint.func_177958_n() * 16, this.pos.func_177956_o(), spawnPoint.func_177952_p() * 16));
        while (this.underBlock == Blocks.field_150362_t || this.underBlock == Blocks.field_150364_r || world.func_175623_d(new BlockPos(this.pos.func_177958_n(), this.pos.func_177956_o() - 1, this.pos.func_177952_p()))) {
            --this.y;
            this.pos = new BlockPos(this.x, this.y, this.z);
            try {
                this.underBlock = world.func_180495_p(new BlockPos(this.pos.func_177958_n(), this.pos.func_177956_o() - 1, this.pos.func_177952_p())).func_177230_c();
                if (!(this.underBlock instanceof BlockPokegift)) continue;
                PixelmonConfig.disableEventLoading();
                return;
            }
            catch (Exception e) {
                return;
            }
        }
        ArrayList<EnumBiomeType> invalidTypes = new ArrayList<EnumBiomeType>();
        invalidTypes.add(EnumBiomeType.RIVER);
        invalidTypes.add(EnumBiomeType.OCEAN);
        boolean bl = this.goodBiome = !PixelmonBiomeDictionary.getBiomeIDsMatchingAnyTag(invalidTypes).contains(Biome.func_185362_a((Biome)this.biome));
        if (this.goodBiome && this.underBlock != Blocks.field_150355_j && this.underBlock != Blocks.field_150358_i && this.underBlock != Blocks.field_150356_k && this.underBlock != Blocks.field_150353_l) {
            world.func_175656_a(this.pos, PixelmonBlocks.pokegiftEventBlock.func_176223_P());
            Pixelmon.LOGGER.info("Pokegift Event spawned at " + this.x + ", " + this.y + ", " + this.z);
            PixelmonConfig.disableEventLoading();
        } else {
            if (!this.verifyCoords()) {
                return;
            }
            try {
                world.func_175656_a(this.pos, PixelmonBlocks.pokegiftEventBlock.func_176223_P());
                Pixelmon.LOGGER.info("Pokegift Event spawned at " + this.x + ", " + this.y + ", " + this.z);
                PixelmonConfig.disableEventLoading();
            }
            catch (Exception e) {
                Pixelmon.LOGGER.catching((Throwable)e);
                Pixelmon.LOGGER.error("Pokegift Event failed!");
            }
        }
    }

    private boolean verifyCoords() {
        TileEntityPokegift te;
        if (this.world.func_175625_s(this.pos) != null && this.world.func_175625_s(this.pos) instanceof TileEntityPokegift && (te = (TileEntityPokegift)this.world.func_175625_s(this.pos)).getType() == EnumPokegiftType.EVENT) {
            return false;
        }
        Block b = this.world.func_180495_p(this.pos).func_177230_c();
        while (b != Blocks.field_150350_a) {
            if (this.type == EnumPokegiftEventType.Halloween) {
                --this.x;
                --this.z;
                this.y = this.world.func_175645_m(new BlockPos(this.x, 0, this.z)).func_177956_o();
                this.pos = new BlockPos(this.x, this.y, this.z);
            }
            if (this.type == EnumPokegiftEventType.Christmas) {
                ++this.x;
                ++this.z;
                this.y = this.world.func_175645_m(new BlockPos(this.x, 0, this.z)).func_177956_o();
                this.pos = new BlockPos(this.x, this.y, this.z);
            }
            if (this.type == EnumPokegiftEventType.Custom) {
                ++this.x;
                --this.z;
                this.y = this.world.func_175645_m(new BlockPos(this.x, 0, this.z)).func_177956_o();
                this.pos = new BlockPos(this.x, this.y, this.z);
            }
            b = this.world.func_180495_p(this.pos).func_177230_c();
        }
        return true;
    }

    public boolean placeEvent(World world) {
        this.world = world;
        try {
            String[] blankArray = new String[]{"notConfigured"};
            if (!this.coords.contains(blankArray)) {
                this.coords = PixelmonConfig.pokegiftEventCoords;
                this.x = Integer.parseInt(this.coords.get(0));
                this.y = Integer.parseInt(this.coords.get(1));
                this.z = Integer.parseInt(this.coords.get(2));
                BlockPos pos = new BlockPos(this.x, this.y, this.z);
                world.func_175656_a(pos, PixelmonBlocks.pokegiftEventBlock.func_176223_P());
                return true;
            }
        }
        catch (Exception e) {
            Pixelmon.LOGGER.catching((Throwable)e);
        }
        return false;
    }

    public EnumPokegiftEventType checkTime() {
        LocalDate localDate = LocalDate.now();
        String[] dayMonth = PixelmonConfig.customPokegiftEventTime.split("/");
        if (dayMonth.length == 2 && !dayMonth[0].equalsIgnoreCase("D") && !dayMonth[1].equalsIgnoreCase("M")) {
            int day = Integer.parseInt(dayMonth[0]);
            int month = Integer.parseInt(dayMonth[1]);
            if (localDate.getMonthValue() == month && localDate.getDayOfMonth() == day) {
                return EnumPokegiftEventType.Custom;
            }
        }
        if (localDate.getMonth() == Month.OCTOBER && localDate.getDayOfMonth() > 12 && localDate.getDayOfMonth() < 26) {
            return EnumPokegiftEventType.Halloween;
        }
        if (localDate.getMonth() == Month.DECEMBER && localDate.getDayOfMonth() > 7 && localDate.getDayOfMonth() < 30) {
            return EnumPokegiftEventType.Christmas;
        }
        return EnumPokegiftEventType.None;
    }
}

