/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.spawning;

import com.pixelmonmod.pixelmon.blocks.enums.EnumSpawnerAggression;
import com.pixelmonmod.pixelmon.blocks.machines.PokemonRarity;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.database.SpawnLocation;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.EnumAggression;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.spawning.spawners.SpawnerAir;
import com.pixelmonmod.pixelmon.spawning.spawners.SpawnerLand;
import com.pixelmonmod.pixelmon.spawning.spawners.SpawnerUnderWater;
import com.pixelmonmod.pixelmon.spawning.spawners.SpawnerUnderground;
import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityPixelmonSpawner
extends TileEntity
implements ITickable {
    public ArrayList<PokemonRarity> pokemonList = new ArrayList();
    public int spawnTick = 40;
    public int spawnRadius = 8;
    public int maxSpawns = 5;
    public int levelMin = 5;
    public int levelMax = 10;
    public boolean fireOnTick = true;
    public boolean spawnRandom = false;
    public EnumSpawnerAggression aggression = EnumSpawnerAggression.Default;
    public int bossRatio = 100;
    public ArrayList<EntityPixelmon> spawnedPokemon = new ArrayList();
    public SpawnLocation spawnLocation = SpawnLocation.Land;
    public static SpawnerLand spawnerLand = new SpawnerLand();
    public static SpawnerAir spawnerAir = new SpawnerAir();
    public static SpawnerUnderground spawnerUnderground = new SpawnerUnderground();
    public static SpawnerUnderWater spawnerUnderwater = new SpawnerUnderWater();
    private boolean editing = false;
    private int tick = -1;

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("spawnTick", this.spawnTick);
        nbt.func_74777_a("spawnRadius", (short)this.spawnRadius);
        nbt.func_74777_a("maxSpawns", (short)this.maxSpawns);
        nbt.func_74777_a("levelMin", (short)this.levelMin);
        nbt.func_74777_a("levelMax", (short)this.levelMax);
        nbt.func_74757_a("fireOnTick", this.fireOnTick);
        nbt.func_74757_a("spawnRandom", this.spawnRandom);
        nbt.func_74777_a("aggression", (short)this.aggression.ordinal());
        nbt.func_74777_a("bossRatio", (short)this.bossRatio);
        nbt.func_74777_a("numPokemon", (short)this.pokemonList.size());
        nbt.func_74777_a("spawnLocation", (short)this.spawnLocation.ordinal());
        for (int i = 0; i < this.pokemonList.size(); ++i) {
            nbt.func_74778_a("pokemonName" + i, this.pokemonList.get((int)i).pokemon.name);
            nbt.func_74777_a("rarity" + i, (short)this.pokemonList.get((int)i).rarity);
        }
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.spawnTick = nbt.func_74762_e("spawnTick");
        this.spawnRadius = nbt.func_74765_d("spawnRadius");
        this.maxSpawns = nbt.func_74765_d("maxSpawns");
        if (nbt.func_74764_b("levelMin")) {
            this.levelMin = nbt.func_74765_d("levelMin");
        }
        if (nbt.func_74764_b("levelMax")) {
            this.levelMax = nbt.func_74765_d("levelMax");
        }
        if (nbt.func_74764_b("fireOnTick")) {
            this.fireOnTick = nbt.func_74767_n("fireOnTick");
        }
        if (nbt.func_74764_b("spawnRandom")) {
            this.spawnRandom = nbt.func_74767_n("spawnRandom");
        }
        if (nbt.func_74764_b("aggression")) {
            this.aggression = EnumSpawnerAggression.getFromOrdinal(nbt.func_74765_d("aggression"));
        }
        if (nbt.func_74764_b("bossRatio")) {
            this.bossRatio = nbt.func_74765_d("bossRatio");
        }
        if (nbt.func_74764_b("spawnLocation")) {
            this.spawnLocation = SpawnLocation.getFromIndex(nbt.func_74765_d("spawnLocation"));
        }
        int numPokemon = nbt.func_74765_d("numPokemon");
        this.pokemonList.clear();
        for (int i = 0; i < numPokemon; ++i) {
            if (!nbt.func_74764_b("pokemonName" + i)) continue;
            this.pokemonList.add(new PokemonRarity(EnumPokemon.getFromName(nbt.func_74779_i("pokemonName" + i)).get(), nbt.func_74765_d("rarity" + i)));
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.fireOnTick && !this.editing) {
            this.doSpawning(false);
        }
    }

    private void spawnPixelmon(EnumPokemon p) {
        Integer ytmp;
        this.checkForDead();
        if (this.spawnedPokemon.size() >= this.maxSpawns) {
            return;
        }
        if (this.spawnLocation == null) {
            return;
        }
        int x = this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextInt(this.spawnRadius * 2 + 1) - this.spawnRadius;
        int y = this.field_174879_c.func_177956_o() - 1;
        int z = this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextInt(this.spawnRadius * 2 + 1) - this.spawnRadius;
        boolean valid = false;
        if (this.spawnLocation == SpawnLocation.Land) {
            y = this.getTopSolidBlock(x, y, z);
            valid = spawnerLand.canPokemonSpawnHere(this.field_145850_b, new BlockPos(x, y, z));
        } else if (this.spawnLocation == SpawnLocation.Air) {
            y = this.getTopSolidBlock(x, y, z);
            valid = spawnerLand.canPokemonSpawnHere(this.field_145850_b, new BlockPos(x, y, z));
        } else if (this.spawnLocation == SpawnLocation.AirPersistent) {
            ytmp = this.getFirstAirBlock(x, y, z);
            if (ytmp != null) {
                y = ytmp;
                valid = spawnerAir.canPokemonSpawnHere(this.field_145850_b, new BlockPos(x, y, z));
            }
        } else if (this.spawnLocation == SpawnLocation.Water) {
            ytmp = this.getFirstWaterBlock(x, y, z);
            if (ytmp != null) {
                y = ytmp;
                valid = spawnerUnderwater.canPokemonSpawnHere(this.field_145850_b, new BlockPos(x, y + 1, z));
            }
        } else if (this.spawnLocation == SpawnLocation.UnderGround) {
            y = this.getTopSolidBlock(x, y, z);
            valid = spawnerUnderground.canPokemonSpawnHere(this.field_145850_b, new BlockPos(x, y, z));
        }
        if (valid) {
            EntityPixelmon pokemon = (EntityPixelmon)PixelmonEntityList.createEntityByName(p.name, this.field_145850_b);
            pokemon.func_70107_b(x, y, z);
            if (this.bossRatio > 0 && this.field_145850_b.field_73012_v.nextInt(this.bossRatio) == 0) {
                pokemon.setBoss(EnumBossMode.getRandomMode());
            }
            if (this.aggression != EnumSpawnerAggression.Default) {
                if (this.aggression == EnumSpawnerAggression.Timid) {
                    pokemon.aggression = EnumAggression.timid;
                } else if (this.aggression == EnumSpawnerAggression.Passive) {
                    pokemon.aggression = EnumAggression.passive;
                } else if (this.aggression == EnumSpawnerAggression.Aggressive) {
                    pokemon.aggression = EnumAggression.aggressive;
                }
            }
            int level = this.field_145850_b.field_73012_v.nextInt(this.levelMax + 1 - this.levelMin) + this.levelMin;
            pokemon.setSpawnLocation(this.spawnLocation);
            pokemon.getLvl().setLevel(level);
            pokemon.setSpawnerParent(this);
            this.field_145850_b.func_72838_d((Entity)pokemon);
            this.spawnedPokemon.add(pokemon);
        }
    }

    private int getTopSolidBlock(int x, int y, int z) {
        Material blockMaterial;
        BlockPos pos;
        int i;
        boolean valid = false;
        for (i = 1; i <= this.spawnRadius / 2; ++i) {
            pos = new BlockPos(x, y + i, z);
            blockMaterial = this.field_145850_b.func_180495_p(pos).func_185904_a();
            if (blockMaterial != Material.field_151579_a && blockMaterial != Material.field_151597_y || !this.isSolidSurface(this.field_145850_b, pos)) continue;
            y += i;
            valid = true;
            break;
        }
        if (!valid) {
            for (i = 1; i <= this.spawnRadius / 2; ++i) {
                pos = new BlockPos(x, y - i, z);
                blockMaterial = this.field_145850_b.func_180495_p(pos).func_185904_a();
                if (blockMaterial != Material.field_151579_a && blockMaterial != Material.field_151597_y || !this.isSolidSurface(this.field_145850_b, pos)) continue;
                y -= i;
                break;
            }
        }
        return y;
    }

    private boolean isSolidSurface(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos, EnumFacing.UP) && !worldIn.func_180495_p(pos).func_185904_a().func_76220_a() && !worldIn.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a();
    }

    private Integer getFirstAirBlock(int x, int y, int z) {
        int i = 0;
        while (this.field_145850_b.func_180495_p(new BlockPos(x, y + i, z)).func_185904_a() != Material.field_151579_a) {
            if (i > this.spawnRadius / 2) {
                return null;
            }
            ++i;
        }
        return y + i;
    }

    private Integer getFirstWaterBlock(int x, int y, int z) {
        int i = 0;
        while (this.field_145850_b.func_180495_p(new BlockPos(x, y + i, z)).func_185904_a() != Material.field_151586_h) {
            if (this.field_145850_b.func_180495_p(new BlockPos(x, y + i, z)).func_185904_a() == Material.field_151579_a) {
                return null;
            }
            ++i;
        }
        return y + i;
    }

    private void doSpawning(boolean override) {
        if (this.tick == 0 || override) {
            EnumPokemon p = this.selectPokemonForSpawn();
            if (p == null) {
                return;
            }
            this.spawnPixelmon(p);
            this.resetSpawnTick();
            if (override) {
                return;
            }
        }
        if (this.tick == -1) {
            this.resetSpawnTick();
        }
        --this.tick;
    }

    private void checkForDead() {
        for (int i = 0; i < this.spawnedPokemon.size(); ++i) {
            EntityPixelmon p = this.spawnedPokemon.get(i);
            if (p.isLoaded(false) && !p.field_70128_L) continue;
            this.spawnedPokemon.remove(i);
            --i;
        }
    }

    private void resetSpawnTick() {
        this.tick = (int)((double)this.spawnTick * (1.0 + (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 0.2));
    }

    private EnumPokemon selectPokemonForSpawn() {
        int total = 0;
        for (PokemonRarity aPokemonList1 : this.pokemonList) {
            total += aPokemonList1.rarity;
        }
        if (this.spawnRandom) {
            return EnumPokemon.randomPoke();
        }
        if (total <= 0) {
            return null;
        }
        int rand = this.field_145850_b.field_73012_v.nextInt(total);
        total = 0;
        for (PokemonRarity aPokemonList : this.pokemonList) {
            if (rand >= (total += aPokemonList.rarity)) continue;
            return aPokemonList.pokemon;
        }
        return null;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return nbt;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void updateRedstone() {
        if (!this.fireOnTick && !this.editing) {
            this.doSpawning(true);
        }
    }

    public void onActivate() {
        this.editing = true;
    }

    public void finishEdit() {
        this.editing = false;
        this.resetSpawnTick();
        while (!this.spawnedPokemon.isEmpty()) {
            this.spawnedPokemon.get(0).unloadEntity();
            this.spawnedPokemon.remove(0);
        }
    }

    public void despawnAllPokemon() {
        while (!this.spawnedPokemon.isEmpty()) {
            this.spawnedPokemon.get(0).unloadEntity();
            this.spawnedPokemon.remove(0);
        }
    }
}

