/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileEntities;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.BreedEvent;
import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityRanchBase;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ranch.EnumRanchClientPacketMode;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ranch.RanchBlockClientPacket;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity10CanBreed;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.storage.PCServer;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerComputerStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import com.pixelmonmod.pixelmon.storage.deepstorage.DeepStorageManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityRanchBlock
extends TileEntityRanchBase {
    private UUID ownerUUID = null;
    private String playerName = "";
    private NBTTagCompound egg = null;

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.egg != null) {
            nbt.func_74782_a("egg", (NBTBase)this.egg);
        }
        if (this.ownerUUID != null) {
            nbt.func_74772_a("UUIDMost", this.ownerUUID.getMostSignificantBits());
            nbt.func_74772_a("UUIDLeast", this.ownerUUID.getLeastSignificantBits());
        }
        if (!this.playerName.equals("")) {
            nbt.func_74778_a("playerName", this.playerName);
        }
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.egg = nbt.func_74764_b("egg") ? (NBTTagCompound)nbt.func_74781_a("egg") : null;
        if (nbt.func_74764_b("playerName")) {
            this.playerName = nbt.func_74779_i("playerName");
        }
        this.ownerUUID = nbt.func_150297_b("UUIDMost", 4) && nbt.func_150297_b("UUIDLeast", 4) ? new UUID(nbt.func_74763_f("UUIDMost"), nbt.func_74763_f("UUIDLeast")) : null;
    }

    public boolean hasEgg() {
        return this.egg != null;
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return nbt;
    }

    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    @Override
    public void onActivate(EntityPlayer player) {
        if (!enabled) {
            ChatHandler.sendChat((Entity)player, "pixelmon.general.disabledblock", new Object[0]);
            return;
        }
        this.updateStatus();
        PCServer.sendContentsToPlayer((EntityPlayerMP)player);
        RanchBlockClientPacket vrb = new RanchBlockClientPacket(this, EnumRanchClientPacketMode.ViewBlock);
        Pixelmon.network.sendTo((IMessage)vrb, (EntityPlayerMP)player);
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.updateStatus();
    }

    @Override
    public void updateStatus() {
        super.updateStatus();
        for (EntityPixelmon p : this.entities) {
            if (this.hasBreedingPartner(p)) {
                EntityPixelmon q = this.getFirstBreedingPartner(p);
                if (q == null || this.egg != null || !p.readyToMakeEgg() || !q.readyToMakeEgg()) continue;
                EntityPixelmon pokemon = new EntityPixelmon(p.field_70170_p);
                pokemon.makeEntityIntoEgg(p, q);
                if (!EnumPokemon.hasPokemon(pokemon.func_70005_c_())) {
                    return;
                }
                BreedEvent.MakeEgg eggEvent = new BreedEvent.MakeEgg(p.func_184753_b(), this.ranchBounds.ranch, pokemon, p, q);
                if (!Pixelmon.EVENT_BUS.post((Event)eggEvent)) {
                    pokemon = eggEvent.getEgg();
                    this.egg = new NBTTagCompound();
                    if (!p.originalTrainer.equals(q.originalTrainer) && PixelmonConfig.shinyRate > 0.0f && pokemon.func_70681_au().nextFloat() < 2.0f / PixelmonConfig.shinyRate) {
                        pokemon.setIsShiny(true);
                    }
                    pokemon.func_189511_e(this.egg);
                }
                p.resetBreedingLevel();
                q.resetBreedingLevel();
                ((WorldServer)this.field_145850_b).func_184164_w().func_180244_a(this.field_174879_c);
                this.func_145831_w().func_175685_c(this.field_174879_c, this.func_145838_q(), true);
                continue;
            }
            p.resetBreedingLevel();
        }
        this.func_145831_w().func_175685_c(this.field_174879_c, this.func_145838_q(), true);
    }

    @Override
    public boolean hasBreedingPartner(EntityPixelmon pixelmon) {
        for (EntityPixelmon p : this.entities) {
            if (p == pixelmon || !Entity10CanBreed.canBreed(pixelmon, p)) continue;
            return true;
        }
        return false;
    }

    @Override
    public EntityPixelmon getFirstBreedingPartner(EntityPixelmon pixelmon) {
        ArrayList possiblePartners = (ArrayList)this.entities.stream().filter(p -> p != pixelmon).filter(p -> Entity10CanBreed.canBreed(pixelmon, p)).collect(Collectors.toList());
        if (possiblePartners.size() == 1) {
            return (EntityPixelmon)((Object)possiblePartners.get(0));
        }
        if (possiblePartners.size() > 1) {
            EntityPixelmon highestPartner = (EntityPixelmon)((Object)possiblePartners.get(0));
            for (int i = 1; i < possiblePartners.size(); ++i) {
                if (((EntityPixelmon)((Object)possiblePartners.get(i))).getNumBreedingLevels() <= highestPartner.getNumBreedingLevels()) continue;
                highestPartner = (EntityPixelmon)((Object)possiblePartners.get(i));
            }
            return highestPartner;
        }
        return null;
    }

    @Override
    public boolean isRanchOwnerInGame() {
        return this.ownerUUID != null && this.field_145850_b.func_152378_a(this.ownerUUID) != null;
    }

    public void setOwner(EntityPlayerMP entity) {
        this.ownerUUID = entity.func_110124_au();
        this.playerName = entity.getDisplayNameString();
    }

    @Override
    public void claimEgg(EntityPlayerMP player) {
        Optional<PlayerStorage> optstorage;
        if (this.egg != null && (optstorage = PixelmonStorage.pokeBallManager.getPlayerStorageFromUUID(player.func_184102_h(), this.ownerUUID)).isPresent()) {
            EntityPixelmon pokemon = (EntityPixelmon)PixelmonEntityList.createEntityFromNBT(this.egg, this.field_145850_b);
            BreedEvent.CollectEgg collectEggEvent = new BreedEvent.CollectEgg(player.func_110124_au(), this.ranchBounds.ranch, pokemon);
            Pixelmon.EVENT_BUS.post((Event)collectEggEvent);
            optstorage.get().addToParty(collectEggEvent.getEgg());
            this.egg = null;
            this.updateStatus();
            ((WorldServer)this.field_145850_b).func_184164_w().func_180244_a(this.field_174879_c);
        }
    }

    public PixelmonData getPokemonEggData() {
        if (this.egg != null) {
            if (!EnumPokemon.hasPokemonAnyCase(this.egg.func_74779_i("Name"))) {
                DeepStorageManager.getOrCreateDeepStorage(this.ownerUUID).put(this.egg);
                DeepStorageManager.save(this.ownerUUID);
                this.egg = null;
                return null;
            }
            return new PixelmonData(this.egg);
        }
        return null;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    @Override
    protected void checkAboveGround() {
        if (this.aboveGround && this.percentAbove < 100) {
            this.percentAbove += 5;
        } else if (!this.aboveGround && this.percentAbove > 0) {
            this.percentAbove -= 5;
        }
        if (this.tick % 20 == 0) {
            int x = this.field_174879_c.func_177958_n();
            int y = this.field_174879_c.func_177956_o();
            int z = this.field_174879_c.func_177952_p();
            List closePlayers = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)(x - 5), (double)(y - 5), (double)(z - 5), (double)(x + 5), (double)(y + 5), (double)(z + 5)));
            this.aboveGround = false;
            for (EntityPlayer closePlayer : closePlayers) {
                if (!closePlayer.func_110124_au().equals(this.ownerUUID)) continue;
                this.aboveGround = true;
                break;
            }
        }
    }

    @Override
    public void onDestroy() {
        if (!this.field_145850_b.field_72995_K && this.hasEgg()) {
            try {
                PlayerComputerStorage storage = PixelmonStorage.computerManager.getPlayerStorageFromUUID(this.field_145850_b, this.ownerUUID);
                if (storage != null) {
                    storage.addToComputer((EntityPixelmon)PixelmonEntityList.createEntityFromNBT(this.egg, this.field_145850_b));
                    if (storage.isOffline()) {
                        PixelmonStorage.computerManager.savePlayer(storage);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.onDestroy();
    }
}

