/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileEntities;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.blocks.BlockRotation;
import com.pixelmonmod.pixelmon.blocks.machines.BlockTimespaceAltar;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.RotateEntity;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.config.PixelmonItemsHeld;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.items.heldItems.ItemTimespaceOrb;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityTimespaceAltar
extends TileEntity
implements ITickable {
    public int orbIn = 0;
    public boolean chainIn = false;
    public boolean flutePlayed = false;
    private boolean spawning = false;
    public int timeSpent = 0;
    private EntityPlayer summoningPlayer = null;
    private IBlockState summoningState = null;

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("OrbIn", this.orbIn);
        nbt.func_74757_a("ChainIn", this.chainIn);
        nbt.func_74757_a("FlutePlayed", this.flutePlayed);
        nbt.func_74768_a("TimeSpent", this.timeSpent);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.orbIn = nbt.func_74762_e("OrbIn");
        this.chainIn = nbt.func_74767_n("ChainIn");
        this.flutePlayed = nbt.func_74767_n("FlutePlayed");
        this.timeSpent = nbt.func_74762_e("TimeSpent");
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_189515_b(tagCompound);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, tagCompound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void activate(EntityPlayer player, BlockTimespaceAltar block, IBlockState state, ItemStack item) {
        if (!(this.orbIn <= 0 && !this.chainIn || !player.func_70093_af() || this.orbIn > 0 && this.chainIn)) {
            if (this.orbIn > 0) {
                switch (this.orbIn) {
                    case 1: {
                        player.func_191521_c(new ItemStack(PixelmonItemsHeld.lustrous_orb));
                        break;
                    }
                    case 2: {
                        player.func_191521_c(new ItemStack(PixelmonItemsHeld.adamant_orb));
                        break;
                    }
                    case 3: {
                        player.func_191521_c(new ItemStack(PixelmonItemsHeld.griseous_orb));
                        break;
                    }
                }
                this.orbIn = 0;
            }
            if (this.chainIn) {
                player.func_191521_c(new ItemStack(PixelmonItems.redchain));
                this.chainIn = false;
            }
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            return;
        }
        if (item != null && item != ItemStack.field_190927_a) {
            if (item.func_77973_b() instanceof ItemTimespaceOrb || item.func_77973_b() == PixelmonItems.redchain) {
                if (!player.field_70170_p.field_72995_K) {
                    if (this.timeSpent == 0) {
                        if (item.func_77973_b() instanceof ItemTimespaceOrb) {
                            if (this.orbIn == 1) {
                                player.func_191521_c(new ItemStack(PixelmonItemsHeld.lustrous_orb, 1));
                            } else if (this.orbIn == 2) {
                                player.func_191521_c(new ItemStack(PixelmonItemsHeld.adamant_orb, 1));
                            } else if (this.orbIn == 3) {
                                player.func_191521_c(new ItemStack(PixelmonItemsHeld.griseous_orb, 1));
                            }
                        }
                        if (item.func_77973_b() == PixelmonItemsHeld.lustrous_orb) {
                            if (!this.chainIn) {
                                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.timespace.needchain", new Object[0]);
                                return;
                            }
                            this.orbIn = 1;
                        } else if (item.func_77973_b() == PixelmonItemsHeld.adamant_orb) {
                            if (!this.chainIn) {
                                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.timespace.needchain", new Object[0]);
                                return;
                            }
                            this.orbIn = 2;
                        } else if (item.func_77973_b() == PixelmonItemsHeld.griseous_orb) {
                            if (!this.chainIn) {
                                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.timespace.needchain", new Object[0]);
                                return;
                            }
                            this.orbIn = 3;
                        } else if (item.func_77973_b() == PixelmonItems.redchain) {
                            this.chainIn = true;
                        }
                        if (!player.func_184812_l_()) {
                            item.func_190918_g(1);
                        }
                    }
                    if (this.orbIn > 0 && this.chainIn && !this.spawning) {
                        this.summoningPlayer = player;
                        this.summoningState = state;
                        this.spawning = true;
                    }
                    this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
                }
            } else if (this.chainIn && !this.spawning) {
                this.chainIn = false;
                this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
                player.func_191521_c(new ItemStack(PixelmonItems.redchain));
            } else {
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.timespace.notorb", new Object[0]);
            }
        }
    }

    public void func_73660_a() {
        if (this.spawning && !this.field_145850_b.field_72995_K) {
            ++this.timeSpent;
            this.field_145850_b.func_184138_a(this.field_174879_c, this.summoningState, this.summoningState, 3);
            if (this.timeSpent > 200) {
                EntityPixelmon pixelmonEntity = null;
                switch (this.orbIn) {
                    case 1: {
                        pixelmonEntity = (EntityPixelmon)PixelmonEntityList.createEntityByName(EnumPokemon.Palkia.name, this.summoningPlayer.field_70170_p);
                        pixelmonEntity.setHeldItem(new ItemStack(PixelmonItemsHeld.lustrous_orb));
                        break;
                    }
                    case 2: {
                        pixelmonEntity = (EntityPixelmon)PixelmonEntityList.createEntityByName(EnumPokemon.Dialga.name, this.summoningPlayer.field_70170_p);
                        pixelmonEntity.setHeldItem(new ItemStack(PixelmonItemsHeld.adamant_orb));
                        break;
                    }
                    case 3: {
                        pixelmonEntity = (EntityPixelmon)PixelmonEntityList.createEntityByName(EnumPokemon.Giratina.name, this.summoningPlayer.field_70170_p);
                        pixelmonEntity.setHeldItem(new ItemStack(PixelmonItemsHeld.griseous_orb));
                        break;
                    }
                    default: {
                        this.field_145850_b.func_184138_a(this.field_174879_c, this.summoningState, this.summoningState, 3);
                        return;
                    }
                }
                pixelmonEntity.setGrowth(EnumGrowth.Ordinary);
                Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage((EntityPlayerMP)this.summoningPlayer);
                if (optstorage.isPresent()) {
                    float spawnRot;
                    double zOffset;
                    double xOffset;
                    PlayerStorage storage = optstorage.get();
                    this.field_145850_b.func_184138_a(this.field_174879_c, this.summoningState, this.summoningState, 3);
                    BlockRotation rot = BlockRotation.getRotationFromMetadata(this.func_145832_p());
                    if (rot == BlockRotation.Normal) {
                        xOffset = 0.5;
                        zOffset = 5.5;
                        spawnRot = 0.0f;
                    } else if (rot == BlockRotation.Rotate180) {
                        xOffset = 0.5;
                        zOffset = -5.5;
                        spawnRot = 180.0f;
                    } else if (rot == BlockRotation.CW) {
                        xOffset = -5.5;
                        zOffset = 0.5;
                        spawnRot = 90.0f;
                    } else {
                        xOffset = 5.5;
                        zOffset = 0.5;
                        spawnRot = 270.0f;
                    }
                    if (storage.getFirstAblePokemon(((EntityPlayerMP)this.summoningPlayer).field_70170_p) == null || BattleRegistry.getBattle(this.summoningPlayer) != null) {
                        this.spawnEntity(pixelmonEntity, (double)this.field_174879_c.func_177958_n() + xOffset, this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + zOffset, spawnRot);
                        this.orbIn = 0;
                        this.chainIn = false;
                        this.spawning = false;
                        this.timeSpent = 0;
                        this.summoningState = null;
                        this.summoningPlayer = null;
                        return;
                    }
                    EntityPixelmon startingPixelmon = storage.getFirstAblePokemon(((EntityPlayerMP)this.summoningPlayer).field_70170_p);
                    this.spawnEntity(pixelmonEntity, (double)this.field_174879_c.func_177958_n() + xOffset, this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + zOffset, spawnRot);
                    PlayerParticipant playerParticipant = new PlayerParticipant((EntityPlayerMP)this.summoningPlayer, startingPixelmon);
                    WildPixelmonParticipant wildPixelmonParticipant = new WildPixelmonParticipant(true, pixelmonEntity);
                    wildPixelmonParticipant.startedBattle = true;
                    BattleControllerBase battleControllerBase = new BattleControllerBase(playerParticipant, wildPixelmonParticipant);
                } else if (pixelmonEntity != null) {
                    pixelmonEntity.func_70106_y();
                }
                this.orbIn = 0;
                this.chainIn = false;
                this.spawning = false;
                this.timeSpent = 0;
                this.summoningState = null;
                this.summoningPlayer = null;
            }
        }
    }

    public void spawnEntity(EntityPixelmon pixelmonEntity, double x, double y, double z, float rotation) {
        pixelmonEntity.func_70080_a(x, y, z, rotation, pixelmonEntity.field_70125_A);
        this.func_145831_w().func_72838_d((Entity)pixelmonEntity);
        Pixelmon.network.sendToDimension((IMessage)new RotateEntity(pixelmonEntity.func_145782_y(), rotation, pixelmonEntity.field_70125_A), pixelmonEntity.field_71093_bK);
        pixelmonEntity.func_70091_d(null, 0.1, 0.1, 0.1);
        pixelmonEntity.field_70126_B = rotation;
        pixelmonEntity.field_70177_z = rotation;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

