/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.pixelmonmod.pixelmon.CommonProxy;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.battles.animations.particles.ParticleBreeding;
import com.pixelmonmod.pixelmon.battles.animations.particles.ParticleGastly;
import com.pixelmonmod.pixelmon.blocks.GenericModelBlock;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.blocks.multiBlocks.BlockGenericModelMultiblock;
import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityMechanicalAnvil;
import com.pixelmonmod.pixelmon.client.PixelmonStateMapper;
import com.pixelmonmod.pixelmon.client.PlayerExtraDataStore;
import com.pixelmonmod.pixelmon.client.RenderInvisibleCamera;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.camera.EntityCamera;
import com.pixelmonmod.pixelmon.client.comm.ClientPacketProcessing;
import com.pixelmonmod.pixelmon.client.gui.GuiCameraOverlay;
import com.pixelmonmod.pixelmon.client.gui.GuiChatOverlay;
import com.pixelmonmod.pixelmon.client.gui.GuiDoctor;
import com.pixelmonmod.pixelmon.client.gui.GuiEvolve;
import com.pixelmonmod.pixelmon.client.gui.GuiHealer;
import com.pixelmonmod.pixelmon.client.gui.GuiItemDrops;
import com.pixelmonmod.pixelmon.client.gui.GuiMegaItem;
import com.pixelmonmod.pixelmon.client.gui.GuiPixelmonOverlay;
import com.pixelmonmod.pixelmon.client.gui.GuiTrading;
import com.pixelmonmod.pixelmon.client.gui.battles.ClientBattleManager;
import com.pixelmonmod.pixelmon.client.gui.battles.GuiAcceptDeny;
import com.pixelmonmod.pixelmon.client.gui.battles.GuiBattle;
import com.pixelmonmod.pixelmon.client.gui.battles.rules.GuiBattleRulesFixed;
import com.pixelmonmod.pixelmon.client.gui.battles.rules.GuiBattleRulesPlayer;
import com.pixelmonmod.pixelmon.client.gui.battles.rules.GuiTeamSelect;
import com.pixelmonmod.pixelmon.client.gui.chooseMoveset.GuiChooseMoveset;
import com.pixelmonmod.pixelmon.client.gui.cosmetics.GuiCosmetics;
import com.pixelmonmod.pixelmon.client.gui.custom.GuiInputScreen;
import com.pixelmonmod.pixelmon.client.gui.custom.overlays.CustomNoticeOverlay;
import com.pixelmonmod.pixelmon.client.gui.custom.overlays.CustomOverlay;
import com.pixelmonmod.pixelmon.client.gui.custom.overlays.CustomScoreboardOverlay;
import com.pixelmonmod.pixelmon.client.gui.dialogue.GuiDialogue;
import com.pixelmonmod.pixelmon.client.gui.inventory.InventoryDetectionTickHandler;
import com.pixelmonmod.pixelmon.client.gui.machines.mechanicalanvil.GuiMechanicalAnvil;
import com.pixelmonmod.pixelmon.client.gui.npc.GuiChattingNPC;
import com.pixelmonmod.pixelmon.client.gui.npc.GuiNPCTrader;
import com.pixelmonmod.pixelmon.client.gui.npc.GuiRelearner;
import com.pixelmonmod.pixelmon.client.gui.npc.GuiShopkeeper;
import com.pixelmonmod.pixelmon.client.gui.npc.GuiTradeYesNo;
import com.pixelmonmod.pixelmon.client.gui.npc.GuiTutor;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.GuiChattingNPCEditor;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.GuiChooseNPC;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.GuiShopkeeperEditor;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.GuiTradeEditor;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.GuiTrainerEditor;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.GuiTutorEditor;
import com.pixelmonmod.pixelmon.client.gui.pc.GuiPC;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.GuiScreenPokeChecker;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.GuiScreenPokeCheckerMoves;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.GuiScreenPokeCheckerStats;
import com.pixelmonmod.pixelmon.client.gui.pokedex.GuiPokedex;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.GuiEditedPlayer;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.GuiPokemonEditorParty;
import com.pixelmonmod.pixelmon.client.gui.ranchblock.GuiExtendRanch;
import com.pixelmonmod.pixelmon.client.gui.ranchblock.GuiPCRanch;
import com.pixelmonmod.pixelmon.client.gui.ranchblock.GuiRanchBlock;
import com.pixelmonmod.pixelmon.client.gui.selectPokemon.GuiSelectPokemon;
import com.pixelmonmod.pixelmon.client.gui.spawner.GuiPixelmonSpawner;
import com.pixelmonmod.pixelmon.client.gui.starter.GuiChooseStarter;
import com.pixelmonmod.pixelmon.client.gui.statueEditor.GuiStatueEditor;
import com.pixelmonmod.pixelmon.client.gui.vendingmachine.GuiVendingMachine;
import com.pixelmonmod.pixelmon.client.keybindings.ActionKey;
import com.pixelmonmod.pixelmon.client.keybindings.CosmeticsKey;
import com.pixelmonmod.pixelmon.client.keybindings.Descend;
import com.pixelmonmod.pixelmon.client.keybindings.ExternalMoveKey;
import com.pixelmonmod.pixelmon.client.keybindings.MinimizeMaximizeOverlayKey;
import com.pixelmonmod.pixelmon.client.keybindings.MovementHandler;
import com.pixelmonmod.pixelmon.client.keybindings.NextExternalMoveKey;
import com.pixelmonmod.pixelmon.client.keybindings.NextPokemonKey;
import com.pixelmonmod.pixelmon.client.keybindings.OptionsKey;
import com.pixelmonmod.pixelmon.client.keybindings.PokedexKey;
import com.pixelmonmod.pixelmon.client.keybindings.PreviousPokemonKey;
import com.pixelmonmod.pixelmon.client.keybindings.SendPokemonKey;
import com.pixelmonmod.pixelmon.client.keybindings.SpectateKey;
import com.pixelmonmod.pixelmon.client.keybindings.WikiKey;
import com.pixelmonmod.pixelmon.client.listener.MouseOverPlayer;
import com.pixelmonmod.pixelmon.client.listener.UnderWaterFog;
import com.pixelmonmod.pixelmon.client.models.items.ItemPixelmonSpriteModel;
import com.pixelmonmod.pixelmon.client.particle.ParticleEvents;
import com.pixelmonmod.pixelmon.client.render.ParticleBlocks;
import com.pixelmonmod.pixelmon.client.render.RenderHook;
import com.pixelmonmod.pixelmon.client.render.RenderNPC;
import com.pixelmonmod.pixelmon.client.render.RenderPixelmon;
import com.pixelmonmod.pixelmon.client.render.RenderPokeball;
import com.pixelmonmod.pixelmon.client.render.RenderStatue;
import com.pixelmonmod.pixelmon.client.render.custom.RenderPixelmonPainting;
import com.pixelmonmod.pixelmon.client.render.item.ItemRendererShrineOrb;
import com.pixelmonmod.pixelmon.client.render.layers.LayerHat;
import com.pixelmonmod.pixelmon.client.render.layers.LayerMegaBracelet;
import com.pixelmonmod.pixelmon.client.render.layers.LayerSash;
import com.pixelmonmod.pixelmon.client.render.player.PixelRenderPlayer;
import com.pixelmonmod.pixelmon.client.render.tileEntities.RanchBlockHighlightRender;
import com.pixelmonmod.pixelmon.commands.NewRedeem;
import com.pixelmonmod.pixelmon.commands.Redeem;
import com.pixelmonmod.pixelmon.config.PixelmonBlocks;
import com.pixelmonmod.pixelmon.config.PixelmonBlocksApricornTrees;
import com.pixelmonmod.pixelmon.config.TileEntityRegistry;
import com.pixelmonmod.pixelmon.entities.EntityLegendFinder;
import com.pixelmonmod.pixelmon.entities.custom.EntityPixelmonPainting;
import com.pixelmonmod.pixelmon.entities.npcs.NPCChatting;
import com.pixelmonmod.pixelmon.entities.npcs.NPCNurseJoy;
import com.pixelmonmod.pixelmon.entities.npcs.NPCRelearner;
import com.pixelmonmod.pixelmon.entities.npcs.NPCShopkeeper;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrader;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTutor;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityStatue;
import com.pixelmonmod.pixelmon.entities.pokeballs.EntityPokeBall;
import com.pixelmonmod.pixelmon.entities.projectiles.EntityHook;
import com.pixelmonmod.pixelmon.enums.EnumBreedingParticles;
import com.pixelmonmod.pixelmon.enums.EnumGui;
import com.pixelmonmod.pixelmon.enums.EnumPixelmonParticles;
import com.pixelmonmod.pixelmon.storage.PCClientStorage;
import com.pixelmonmod.pixelmon.util.helpers.RCFileHelper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    public static ClientBattleManager battleManager = new ClientBattleManager();
    public static EntityCamera camera;
    public static ActionKey actionKeyBind;
    public static ExternalMoveKey externalKeyBind;
    public static PokedexKey pokedexKeyBind;
    public static WikiKey wikiKeyBind;
    public static SpectateKey spectateKeyBind;
    public static CosmeticsKey cosmeticsKeyBind;
    ClientPacketProcessing cpp = new ClientPacketProcessing();
    static ConcurrentHashMap<String, ResourceLocation> cachedSkins;
    static List<String> invaildSkins;

    @Override
    public void preInit() {
        this.addPokemonRenderers();
        MinecraftForge.EVENT_BUS.register((Object)new ParticleEvents());
    }

    @Override
    public void init() {
        super.init();
        MinecraftForge.EVENT_BUS.register(GuiCameraOverlay.class);
        PlayerExtraDataStore.loadClientData();
    }

    @Override
    public void registerBlockModels() {
        PixelmonBlocks.registerModels();
    }

    @Override
    public void registerRenderers() {
        TileEntityRegistry.registerRenderers();
        MinecraftForge.EVENT_BUS.register((Object)new CustomOverlay());
        MinecraftForge.EVENT_BUS.register((Object)new GuiPixelmonOverlay());
        MinecraftForge.EVENT_BUS.register((Object)new GuiChatOverlay(Minecraft.func_71410_x()));
        MinecraftForge.EVENT_BUS.register((Object)new UnderWaterFog());
        MinecraftForge.EVENT_BUS.register((Object)new RanchBlockHighlightRender());
        MinecraftForge.EVENT_BUS.register((Object)new MouseOverPlayer());
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        renderManager.field_178636_l.remove("default");
        renderManager.field_178636_l.remove("slim");
        renderManager.field_178636_l.put("default", new PixelRenderPlayer(renderManager));
        renderManager.field_178636_l.put("slim", new PixelRenderPlayer(renderManager, true));
        RenderPlayer rp = (RenderPlayer)renderManager.field_178636_l.get("default");
        rp.func_177094_a((LayerRenderer)new LayerHat(rp, rp.func_177087_b().field_78116_c));
        rp.func_177094_a((LayerRenderer)new LayerSash(rp));
        rp.func_177094_a((LayerRenderer)new LayerMegaBracelet(rp));
        rp = (RenderPlayer)renderManager.field_178636_l.get("slim");
        rp.func_177094_a((LayerRenderer)new LayerMegaBracelet(rp));
        rp.func_177094_a((LayerRenderer)new LayerHat(rp, rp.func_177087_b().field_78116_c));
        rp.func_177094_a((LayerRenderer)new LayerSash(rp));
    }

    @SubscribeEvent
    public void onModelBakeEvent(ModelBakeEvent event) {
        this.bakeOrb(event, ItemRendererShrineOrb.uno);
        this.bakeOrb(event, ItemRendererShrineOrb.dos);
        this.bakeOrb(event, ItemRendererShrineOrb.tres);
        this.bakePixelmonSprites(event);
    }

    private void bakePixelmonSprites(ModelBakeEvent event) {
        Object object = event.getModelRegistry().func_82594_a((Object)ItemPixelmonSpriteModel.modelResourceLocation);
        if (object instanceof IBakedModel) {
            IBakedModel existingModel = (IBakedModel)object;
            ItemPixelmonSpriteModel customModel = new ItemPixelmonSpriteModel(existingModel);
            event.getModelRegistry().func_82595_a((Object)ItemPixelmonSpriteModel.modelResourceLocation, (Object)customModel);
        }
    }

    private void bakeOrb(ModelBakeEvent event, ModelResourceLocation resourceLocation) {
        Object resource = event.getModelRegistry().func_82594_a((Object)resourceLocation);
        if (resource != null) {
            IBakedModel existingModel = (IBakedModel)resource;
            ItemRendererShrineOrb customModel = new ItemRendererShrineOrb(existingModel);
            event.getModelRegistry().func_82595_a((Object)resourceLocation, (Object)customModel);
        }
    }

    @SubscribeEvent
    public void stitcherEventPre(TextureStitchEvent.Pre event) {
        event.getMap().func_174942_a(new ResourceLocation("pixelmon:items/back"));
        event.getMap().func_174942_a(new ResourceLocation("pixelmon:items/front"));
        event.getMap().func_174942_a(new ResourceLocation("pixelmon:items/unoorb"));
        event.getMap().func_174942_a(new ResourceLocation("pixelmon:items/dosorb"));
        event.getMap().func_174942_a(new ResourceLocation("pixelmon:items/tresorb"));
        this.loadImagesToAtlas("sprites/eggs", event);
        this.loadImagesToAtlas("sprites/pokemon", event);
        this.loadImagesToAtlas("sprites/shinypokemon", event);
    }

    public void loadImagesToAtlas(String textureSubDir, TextureStitchEvent.Pre event) {
        try {
            Path path = RCFileHelper.pathFromResourceLocation(new ResourceLocation("pixelmon", "textures/" + textureSubDir));
            List<Path> pngPaths = RCFileHelper.listFilesRecursively(path, entry -> entry.getFileName().toString().endsWith(".png"), false);
            for (Path pngPath : pngPaths) {
                String fileName = pngPath.getFileName().toString();
                event.getMap().func_174942_a(new ResourceLocation("pixelmon", textureSubDir + "/" + fileName.substring(0, fileName.length() - 4)));
            }
        }
        catch (Exception var8) {
            var8.printStackTrace();
        }
    }

    @Override
    public void fixModelDefs() {
        Block block;
        PixelmonStateMapper pixelmonStateMapper = new PixelmonStateMapper();
        ModelLoader.setCustomStateMapper((Block)PixelmonBlocks.hiddenIronDoor, (IStateMapper)pixelmonStateMapper);
        ModelLoader.setCustomStateMapper((Block)PixelmonBlocks.hiddenWoodenDoor, (IStateMapper)pixelmonStateMapper);
        ModelLoader.setCustomStateMapper((Block)PixelmonBlocks.masterChest, (IStateMapper)pixelmonStateMapper);
        ModelLoader.setCustomStateMapper((Block)PixelmonBlocks.pokeChest, (IStateMapper)pixelmonStateMapper);
        ModelLoader.setCustomStateMapper((Block)PixelmonBlocks.ultraChest, (IStateMapper)pixelmonStateMapper);
        ModelLoader.setCustomStateMapper((Block)PixelmonBlocks.mechanicalAnvil, (IStateMapper)pixelmonStateMapper);
        ModelLoader.setCustomStateMapper((Block)PixelmonBlocks.hiddenPressurePlate, (IStateMapper)pixelmonStateMapper);
        for (Field field : PixelmonBlocks.class.getFields()) {
            try {
                if (!(field.get(null) instanceof Block) || ((block = (Block)field.get(null)) == null || !(block instanceof MultiBlock)) && block.func_149645_b(block.func_176223_P()) != EnumBlockRenderType.INVISIBLE && !(block instanceof GenericModelBlock) && !(block instanceof BlockGenericModelMultiblock)) continue;
                ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)pixelmonStateMapper);
            }
            catch (IllegalAccessException var8) {
                var8.printStackTrace();
            }
        }
        for (Field field : PixelmonBlocksApricornTrees.class.getFields()) {
            try {
                if (!(field.get(null) instanceof Block) || ((block = (Block)field.get(null)) == null || !(block instanceof MultiBlock)) && block.func_149645_b(block.func_176223_P()) != EnumBlockRenderType.MODEL) continue;
                ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)pixelmonStateMapper);
            }
            catch (IllegalAccessException var7) {
                var7.printStackTrace();
            }
        }
    }

    @Override
    public World GetClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void registerKeyBindings() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        SendPokemonKey k1 = new SendPokemonKey();
        ClientRegistry.registerKeyBinding((KeyBinding)k1);
        MinecraftForge.EVENT_BUS.register((Object)k1);
        NextPokemonKey k2 = new NextPokemonKey();
        ClientRegistry.registerKeyBinding((KeyBinding)k2);
        MinecraftForge.EVENT_BUS.register((Object)k2);
        PreviousPokemonKey k3 = new PreviousPokemonKey();
        ClientRegistry.registerKeyBinding((KeyBinding)k3);
        MinecraftForge.EVENT_BUS.register((Object)k3);
        MinimizeMaximizeOverlayKey k4 = new MinimizeMaximizeOverlayKey();
        ClientRegistry.registerKeyBinding((KeyBinding)k4);
        MinecraftForge.EVENT_BUS.register((Object)k4);
        Descend k5 = new Descend();
        ClientRegistry.registerKeyBinding((KeyBinding)k5);
        MinecraftForge.EVENT_BUS.register((Object)k5);
        spectateKeyBind = new SpectateKey();
        ClientRegistry.registerKeyBinding((KeyBinding)spectateKeyBind);
        MinecraftForge.EVENT_BUS.register((Object)spectateKeyBind);
        actionKeyBind = new ActionKey();
        ClientRegistry.registerKeyBinding((KeyBinding)actionKeyBind);
        MinecraftForge.EVENT_BUS.register((Object)actionKeyBind);
        externalKeyBind = new ExternalMoveKey();
        ClientRegistry.registerKeyBinding((KeyBinding)externalKeyBind);
        MinecraftForge.EVENT_BUS.register((Object)externalKeyBind);
        NextExternalMoveKey nextExternalKeyBind = new NextExternalMoveKey();
        ClientRegistry.registerKeyBinding((KeyBinding)nextExternalKeyBind);
        MinecraftForge.EVENT_BUS.register((Object)nextExternalKeyBind);
        pokedexKeyBind = new PokedexKey();
        ClientRegistry.registerKeyBinding((KeyBinding)pokedexKeyBind);
        MinecraftForge.EVENT_BUS.register((Object)pokedexKeyBind);
        wikiKeyBind = new WikiKey();
        ClientRegistry.registerKeyBinding((KeyBinding)wikiKeyBind);
        MinecraftForge.EVENT_BUS.register((Object)wikiKeyBind);
        MinecraftForge.EVENT_BUS.register((Object)new MovementHandler());
        OptionsKey k6 = new OptionsKey();
        ClientRegistry.registerKeyBinding((KeyBinding)k6);
        MinecraftForge.EVENT_BUS.register((Object)k6);
    }

    @Override
    public void registerCommands() {
        ClientCommandHandler.instance.func_71560_a((ICommand)new Redeem());
        ClientCommandHandler.instance.func_71560_a((ICommand)new NewRedeem());
    }

    private void addPokemonRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityPokeBall.class, RenderPokeball::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityHook.class, RenderHook::new);
        RenderingRegistry.registerEntityRenderingHandler(NPCTrainer.class, RenderNPC::new);
        RenderingRegistry.registerEntityRenderingHandler(NPCChatting.class, RenderNPC::new);
        RenderingRegistry.registerEntityRenderingHandler(NPCTrader.class, RenderNPC::new);
        RenderingRegistry.registerEntityRenderingHandler(NPCRelearner.class, RenderNPC::new);
        RenderingRegistry.registerEntityRenderingHandler(NPCTutor.class, RenderNPC::new);
        RenderingRegistry.registerEntityRenderingHandler(NPCNurseJoy.class, RenderNPC::new);
        RenderingRegistry.registerEntityRenderingHandler(NPCShopkeeper.class, RenderNPC::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityStatue.class, RenderStatue::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityPixelmon.class, RenderPixelmon::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityCamera.class, RenderInvisibleCamera::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityPixelmonPainting.class, RenderPixelmonPainting::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityLegendFinder.class, (IRenderFactory)new EntityLegendFinder.EntityLegendFactory());
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        EnumGui gui = EnumGui.getFromOrdinal(ID);
        if (!Minecraft.func_71410_x().func_152345_ab()) {
            System.out.println("Dodgy gui call from non-main thread for " + gui.toString());
        }
        switch (gui) {
            case ChooseStarter: {
                return new GuiChooseStarter();
            }
            case SelectPokemon: {
                return new GuiSelectPokemon();
            }
            case LearnMove: 
            case LevelUp: 
            case Battle: 
            case ChooseRelearnMove: 
            case ChooseTutor: {
                return new GuiBattle();
            }
            case Pokedex: {
                return new GuiPokedex(player.func_145748_c_().func_150254_d(), x);
            }
            case PC: {
                return new GuiPC();
            }
            case Healer: {
                return new GuiHealer();
            }
            case HealerNurseJoy: {
                return new GuiHealer(x, y, z);
            }
            case PokeChecker: {
                if (x == -1) {
                    return new GuiScreenPokeChecker(GuiPC.selected, true, y);
                }
                return new GuiScreenPokeChecker(ServerStorageDisplay.get(new int[]{x, y}), false);
            }
            case PokeCheckerStats: {
                if (x == -1) {
                    return new GuiScreenPokeCheckerStats(GuiPC.selected, true, y);
                }
                return new GuiScreenPokeCheckerStats(ServerStorageDisplay.get(new int[]{x, y}), false);
            }
            case PokeCheckerMoves: {
                if (x == -1) {
                    return new GuiScreenPokeCheckerMoves(GuiPC.selected, true, y);
                }
                return new GuiScreenPokeCheckerMoves(ServerStorageDisplay.get(new int[]{x, y}), false);
            }
            case Trading: {
                return new GuiTrading(x, y, z);
            }
            case Doctor: {
                return new GuiDoctor();
            }
            case AcceptDeny: {
                return new GuiAcceptDeny(x);
            }
            case Evolution: {
                return new GuiEvolve();
            }
            case ItemDrops: {
                return new GuiItemDrops();
            }
            case PixelmonSpawner: {
                return new GuiPixelmonSpawner(x, y, z);
            }
            case TrainerEditor: {
                return new GuiTrainerEditor(x);
            }
            case TradeYesNo: {
                return new GuiTradeYesNo(x);
            }
            case NPCTrade: {
                return new GuiTradeEditor(x);
            }
            case NPCTraderGui: {
                return new GuiNPCTrader(x);
            }
            case ChooseMoveset: {
                return new GuiChooseMoveset(ServerStorageDisplay.get(new int[]{x, y}));
            }
            case RanchBlock: {
                return new GuiRanchBlock();
            }
            case ExtendRanch: {
                return new GuiExtendRanch();
            }
            case PCNoParty: {
                return new GuiPCRanch();
            }
            case StatueEditor: {
                return new GuiStatueEditor(x);
            }
            case MechaAnvil: {
                return new GuiMechanicalAnvil(player.field_71071_by, (TileEntityMechanicalAnvil)world.func_175625_s(new BlockPos(x, y, z)));
            }
            case InputScreen: {
                return new GuiInputScreen();
            }
            case SelectNPCType: {
                return new GuiChooseNPC(new BlockPos(x, y, z));
            }
            case NPCChatEditor: {
                return new GuiChattingNPCEditor(x);
            }
            case NPCChat: {
                return new GuiChattingNPC(x);
            }
            case Relearner: {
                return new GuiRelearner(ServerStorageDisplay.get(new int[]{x, y}));
            }
            case Tutor: {
                return new GuiTutor(ServerStorageDisplay.get(new int[]{x, y}));
            }
            case TutorEditor: {
                return new GuiTutorEditor(x);
            }
            case Shopkeeper: {
                return new GuiShopkeeper(x);
            }
            case ShopkeeperEditor: {
                return new GuiShopkeeperEditor(x);
            }
            case VendingMachine: {
                return new GuiVendingMachine(new BlockPos(x, y, z));
            }
            case PokemonEditor: {
                return new GuiPokemonEditorParty();
            }
            case EditedPlayer: {
                return new GuiEditedPlayer();
            }
            case MegaItem: {
                return new GuiMegaItem(x == 1);
            }
            case BattleRulesPlayer: {
                return new GuiBattleRulesPlayer(x, y == 1);
            }
            case BattleRulesFixed: {
                return new GuiBattleRulesFixed();
            }
            case TeamSelect: {
                return new GuiTeamSelect();
            }
            case Dialogue: {
                return new GuiDialogue();
            }
            case Cosmetics: {
                return new GuiCosmetics();
            }
        }
        return null;
    }

    public static File getMinecraftDir() {
        return Minecraft.func_71410_x().field_71412_D;
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        ServerStorageDisplay.clear();
        PCClientStorage.clearList();
        CustomNoticeOverlay.resetNotice();
        CustomScoreboardOverlay.resetBoard();
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        Pixelmon.freeze = false;
        ClientProxy.battleManager.battleEnded = true;
        ServerStorageDisplay.clear();
        PCClientStorage.clearList();
        CustomNoticeOverlay.resetNotice();
        CustomScoreboardOverlay.resetBoard();
    }

    public static void spawnParticle(World w, double d1, double d2, double d3, Block stone) {
        ParticleBlocks fx = new ParticleBlocks(w, d1, d2, d3, 0.0, 0.0, 0.0, w.func_180495_p(new BlockPos(d1, d2, d3)));
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((Particle)fx);
    }

    public static void spawnParticle(EnumPixelmonParticles particle, World worldObj, double posX, double posY, double posZ, boolean isShiny) {
        try {
            ParticleGastly fx = particle.particleClass == ParticleGastly.class ? new ParticleGastly(worldObj, posX, posY, posZ, 0.0, 0.0, 0.0, isShiny) : particle.particleClass.getConstructor(World.class, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE).newInstance(worldObj, posX, posY, posZ, 0.0, 0.0, 0.0);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)fx);
        }
        catch (Exception var10) {
            var10.printStackTrace();
        }
    }

    public static void spawnParticle(EnumBreedingParticles particle, World worldObj, double posX, double posY, double posZ, boolean isShiny) {
        try {
            ParticleBreeding fx = new ParticleBreeding(worldObj, posX, posY, posZ, 0.0, 0.0, 0.0, particle);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)fx);
        }
        catch (Exception var10) {
            var10.printStackTrace();
        }
    }

    @Override
    public void registerTickHandlers() {
        MinecraftForge.EVENT_BUS.register((Object)new InventoryDetectionTickHandler());
        MinecraftForge.EVENT_BUS.register((Object)battleManager);
    }

    @Override
    public ClientPacketProcessing getClientPacketProcessor() {
        return this.cpp;
    }

    public static ResourceLocation bindPlayerTexture(String username) {
        if (!username.isEmpty() && !invaildSkins.contains(username)) {
            if (cachedSkins.containsKey(username)) {
                return cachedSkins.get(username);
            }
            GameProfile profile = new GameProfile(null, username);
            if ((profile = TileEntitySkull.func_174884_b((GameProfile)profile)).isComplete() && profile.getId().version() == 4 && profile.getProperties().containsKey((Object)"textures")) {
                ResourceLocation resourcelocation;
                Minecraft minecraft = Minecraft.func_71410_x();
                Map map = minecraft.func_152342_ad().func_152788_a(profile);
                if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                    resourcelocation = minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                    cachedSkins.put(username, resourcelocation);
                } else {
                    resourcelocation = DefaultPlayerSkin.func_177335_a();
                }
                return resourcelocation;
            }
            invaildSkins.add(username);
            return DefaultPlayerSkin.func_177335_a();
        }
        return DefaultPlayerSkin.func_177335_a();
    }

    @Override
    public boolean resourceLocationExists(ResourceLocation resourceLocation) {
        try {
            return Minecraft.func_71410_x().func_110442_L().func_110536_a(resourceLocation).func_110527_b() != null;
        }
        catch (IOException var3) {
            return false;
        }
    }

    @Override
    public BufferedInputStream getStreamForResourceLocation(ResourceLocation resourceLocation) {
        try {
            return new BufferedInputStream(Minecraft.func_71410_x().func_110442_L().func_110536_a(resourceLocation).func_110527_b());
        }
        catch (IOException var3) {
            throw new RuntimeException(var3);
        }
    }

    @Override
    public void resetMouseOver() {
        Minecraft.func_71410_x().field_71476_x = null;
    }

    public static void spawnBoostedTreeParticles(World worldObj, int x, int y, int z, int stage) {
        for (int i = 0; i < 20; ++i) {
            float yplus = worldObj.field_73012_v.nextFloat();
            if (stage <= 3) {
                yplus *= 2.0f;
            }
            ClientProxy.spawnParticle(EnumPixelmonParticles.shiny, worldObj, (double)((float)x + worldObj.field_73012_v.nextFloat()), (double)((float)y + yplus), (double)((float)z + worldObj.field_73012_v.nextFloat()), true);
        }
    }

    static {
        cachedSkins = new ConcurrentHashMap();
        invaildSkins = new ArrayList<String>();
    }
}

