/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.PlayerExtrasPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.RequestExtraData;
import com.pixelmonmod.pixelmon.entities.pixelmon.EnumSpecialTexture;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.storage.PlayerExtraData;
import com.pixelmonmod.pixelmon.storage.PlayerExtras;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PlayerExtraDataStore {
    private static PlayerExtraData client = new PlayerExtraData(Minecraft.func_71410_x().func_110432_I().func_148256_e().getId());
    private static final List<PlayerExtraData> playerExtras = new ArrayList<PlayerExtraData>();

    public static void add(PlayerExtraData data) {
        if (data.id.equals(PlayerExtraDataStore.client.id)) {
            return;
        }
        for (int i = 0; i < playerExtras.size(); ++i) {
            if (!PlayerExtraDataStore.playerExtras.get((int)i).id.equals(data.id)) continue;
            playerExtras.set(i, data);
            return;
        }
        playerExtras.add(data);
    }

    public static PlayerExtraData get(EntityPlayer player) {
        if (player.func_110124_au().equals(PlayerExtraDataStore.client.id)) {
            return client;
        }
        for (PlayerExtraData d : playerExtras) {
            if (!d.id.equals(player.func_110124_au())) continue;
            return d;
        }
        PlayerExtraData d = new PlayerExtraData(player);
        playerExtras.add(d);
        Pixelmon.network.sendToServer((IMessage)new RequestExtraData(player));
        return d;
    }

    public static boolean canSeeTexture(EntityPlayer owner, EnumPokemon pokemon) {
        return owner != null && PlayerExtraDataStore.get(owner).canSeeTexture(pokemon);
    }

    public static short validateTexture(short specialTexture, EntityPlayer owner, EnumPokemon pokemon) {
        if (specialTexture == EnumSpecialTexture.Online.id && !PlayerExtraDataStore.canSeeTexture(owner, pokemon)) {
            specialTexture = (short)EnumSpecialTexture.None.id;
        }
        return specialTexture;
    }

    public static void refreshClient() {
        UUID uuid = Minecraft.func_71410_x().func_110432_I().func_148256_e().getId();
        PlayerExtras.checkDataOnline(uuid, playerExtraData -> {
            client.setDataValues((PlayerExtraData)playerExtraData);
            PlayerExtraDataStore.saveClientData();
            if (playerExtraData.hasData()) {
                Pixelmon.network.sendToServer((IMessage)PlayerExtrasPacket.getRefreshPacket());
            }
        });
    }

    public static void sendDisplayPacket() {
        if (client.hasData()) {
            Pixelmon.network.sendToServer((IMessage)new PlayerExtrasPacket(client));
        }
    }

    static void loadClientData() {
        UUID uuid = Minecraft.func_71410_x().func_110432_I().func_148256_e().getId();
        PlayerExtraData data = null;
        File file = new File(Minecraft.func_71410_x().field_71412_D, "pixel.dat");
        if (file.exists()) {
            NBTTagCompound compound = new NBTTagCompound();
            try (FileInputStream in = new FileInputStream(file);){
                compound = CompressedStreamTools.func_74796_a((InputStream)in);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (compound.func_74764_b(uuid.toString())) {
                NBTTagCompound nbt = compound.func_74775_l(uuid.toString());
                data = new PlayerExtraData(uuid);
                data.readFromNBT(nbt);
            }
        }
        if (data == null || data.shouldRefresh()) {
            client = new PlayerExtraData(uuid);
            PlayerExtras.checkDataOnline(uuid, playerExtraData -> {
                client.setDataValues((PlayerExtraData)playerExtraData);
                PlayerExtraDataStore.saveClientData();
            });
        } else {
            client = data;
        }
    }

    public static void saveClientData() {
        File file = new File(Minecraft.func_71410_x().field_71412_D, "pixel.dat");
        NBTTagCompound compound = new NBTTagCompound();
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        try (FileInputStream in = new FileInputStream(file);){
            compound = CompressedStreamTools.func_74796_a((InputStream)in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        NBTTagCompound nbt = new NBTTagCompound();
        client.writeToNBT(nbt);
        compound.func_74782_a(PlayerExtraDataStore.client.id.toString(), (NBTBase)nbt);
        try (FileOutputStream out = new FileOutputStream(file);){
            CompressedStreamTools.func_74799_a((NBTTagCompound)compound, (OutputStream)out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

