/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui;

import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.PixelmonMovesetData;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.EnumSpecialTexture;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.util.helpers.SpriteHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector4f;
import scala.actors.threadpool.Arrays;

public class GuiHelper {
    public static boolean isMouseOverButton(GuiButton button, int mouseX, int mouseY) {
        return mouseX >= button.field_146128_h && mouseY >= button.field_146129_i && mouseX < button.field_146128_h + button.field_146120_f && mouseY < button.field_146129_i + button.field_146121_g;
    }

    public static void drawStringRightAligned(String text, float x, float y, int color) {
        GuiHelper.drawStringRightAligned(text, x, y, color, false);
    }

    public static void drawStringRightAligned(String text, float x, float y, int color, boolean dropShadow) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.func_175065_a(text, x -= (float)fontRenderer.func_78256_a(text), y, color, dropShadow);
    }

    public static void drawImageQuad(double x, double y, double w, float h, double us, double vs, double ue, double ve, float zLevel) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(x, y + (double)h, (double)zLevel).func_187315_a(us, ve).func_181675_d();
        buffer.func_181662_b(x + w, y + (double)h, (double)zLevel).func_187315_a(ue, ve).func_181675_d();
        buffer.func_181662_b(x + w, y, (double)zLevel).func_187315_a(ue, vs).func_181675_d();
        buffer.func_181662_b(x, y, (double)zLevel).func_187315_a(us, vs).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void bindPokemonSprite(PixelmonData pkt, Minecraft mc) {
        if (pkt == null) {
            return;
        }
        GuiHelper.bindPokemonSprite(pkt.getNationalPokedexNumber(), pkt.form, pkt.gender, pkt.specialTexture, pkt.isShiny, pkt.isEgg, pkt.eggCycles, mc);
    }

    public static void bindPokemonSprite(int pokedexNumber, int form, Gender gender, int specialTexture, boolean isShiny, boolean isEgg, int eggCycles, Minecraft mc) {
        EnumPokemon pokemon = EnumPokemon.getFromDex(pokedexNumber).get();
        if (isEgg) {
            if (pokemon.name.equalsIgnoreCase("Togepi")) {
                if (eggCycles > 10) {
                    mc.field_71446_o.func_110577_a(GuiResources.eggTogepi1);
                } else if (eggCycles > 5) {
                    mc.field_71446_o.func_110577_a(GuiResources.eggTogepi2);
                } else {
                    mc.field_71446_o.func_110577_a(GuiResources.eggTogepi3);
                }
            } else if (pokemon.name.equalsIgnoreCase("Manaphy")) {
                if (eggCycles > 10) {
                    mc.field_71446_o.func_110577_a(GuiResources.eggManaphy1);
                } else if (eggCycles > 5) {
                    mc.field_71446_o.func_110577_a(GuiResources.eggManaphy2);
                } else {
                    mc.field_71446_o.func_110577_a(GuiResources.eggManaphy3);
                }
            } else if (eggCycles > 10) {
                mc.field_71446_o.func_110577_a(GuiResources.eggNormal1);
            } else if (eggCycles > 5) {
                mc.field_71446_o.func_110577_a(GuiResources.eggNormal2);
            } else {
                mc.field_71446_o.func_110577_a(GuiResources.eggNormal3);
            }
        } else {
            GuiHelper.bindPokemonSprite(pokedexNumber, form, gender, specialTexture, isShiny, mc);
        }
    }

    public static void bindPokemonSprite(int pokedexNumber, int form, Gender gender, boolean isShiny, Minecraft mc) {
        GuiHelper.bindPokemonSprite(pokedexNumber, form, gender, EnumSpecialTexture.None.id, isShiny, mc);
    }

    public static void bindPokemonSprite(int pokedexNumber, int form, Gender gender, int specialTexture, boolean isShiny, Minecraft mc) {
        if (specialTexture > 0) {
            isShiny = false;
        }
        GuiHelper.bindPokemonSprite(pokedexNumber, isShiny, mc, SpriteHelper.getSpriteExtra(EnumPokemon.getFromDex((int)pokedexNumber).get().name, form, gender, specialTexture));
    }

    public static void bindPokemonSprite(int npn, boolean isShiny, Minecraft mc) {
        GuiHelper.bindPokemonSprite(npn, isShiny, mc, "");
    }

    public static void bindPokemonSprite(int npn, boolean isShiny, Minecraft mc, String extra) {
        String numString = String.format("%03d", npn);
        if (isShiny) {
            mc.field_71446_o.func_110577_a(GuiResources.shinySprite(numString + extra));
        } else {
            mc.field_71446_o.func_110577_a(GuiResources.sprite(numString + extra));
        }
    }

    public static void drawScoreboard(int top, int right, int alpha, String title, Collection<String> lines, Collection<String> scores) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int tempWidth = GuiHelper.getLongestStringWidth(lines);
        if (scores != null) {
            tempWidth += GuiHelper.getLongestStringWidth(scores) + 20;
        }
        if (fontRenderer.func_78256_a(title) > tempWidth) {
            tempWidth = fontRenderer.func_78256_a(title);
        }
        int left = right - tempWidth - 3;
        int boxHeight = (lines.size() + 1) * 10;
        Gui.func_73734_a((int)left, (int)top, (int)right, (int)(top + boxHeight), (int)alpha);
        GuiHelper.drawCenteredString(title, left + tempWidth / 2, top, -1);
        int y = top;
        for (String line : lines) {
            fontRenderer.func_175063_a(line, (float)(left + 3), (float)(y += 10), -1);
        }
        y = top;
        if (scores != null) {
            for (String line : scores) {
                fontRenderer.func_175063_a(line, (float)(right - 3 - fontRenderer.func_78256_a(line)), (float)(y += 10), -1);
            }
        }
    }

    public static int getLongestStringWidth(Collection<String> lines) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int longestStringWidth = 0;
        for (String line : lines) {
            int currentStringWidth = fontRenderer.func_78256_a(line);
            if (currentStringWidth <= longestStringWidth) continue;
            longestStringWidth = currentStringWidth;
        }
        return longestStringWidth;
    }

    public static Optional<int[]> renderTooltip(int x, int y, int gradient1, int background, int alpha, boolean centerBox, boolean centerText, String ... tooltipData) {
        List tooltipCollection = Arrays.asList((Object[])tooltipData);
        return GuiHelper.renderTooltip(x, y, tooltipCollection, gradient1, background, alpha, centerBox, centerText);
    }

    public static Optional<int[]> renderTooltip(int x, int y, Collection<String> tooltipData, int gradient1, int background, int alpha, boolean centerBox, boolean centerText) {
        if (tooltipData.isEmpty()) {
            return Optional.empty();
        }
        boolean lighting = GL11.glGetBoolean((int)2896);
        if (lighting) {
            RenderHelper.func_74518_a();
        }
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int longestStringWidth = GuiHelper.getLongestStringWidth(tooltipData);
        int left = x;
        int top = y;
        if (centerBox) {
            left -= longestStringWidth / 2;
        }
        int boxHeight = 8;
        if (tooltipData.size() > 1) {
            boxHeight += (tooltipData.size() - 1) * 10;
        }
        float z = 300.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
        background = background & 0xFFFFFF | alpha << 24;
        Gui.func_73734_a((int)(left - 3), (int)(top - 4), (int)(left + longestStringWidth + 3), (int)(top - 3), (int)background);
        Gui.func_73734_a((int)(left - 3), (int)(top + boxHeight + 3), (int)(left + longestStringWidth + 3), (int)(top + boxHeight + 4), (int)background);
        Gui.func_73734_a((int)(left - 3), (int)(top - 3), (int)(left + longestStringWidth + 3), (int)(top + boxHeight + 3), (int)background);
        Gui.func_73734_a((int)(left - 4), (int)(top - 3), (int)(left - 3), (int)(top + boxHeight + 3), (int)background);
        Gui.func_73734_a((int)(left + longestStringWidth + 3), (int)(top - 3), (int)(left + longestStringWidth + 4), (int)(top + boxHeight + 3), (int)background);
        int gradient2 = (gradient1 & 0xFFFFFF) >> 1 | gradient1 & 0xFF000000;
        GuiHelper.drawGradientRect(left - 3, top - 3 + 1, z, left - 3 + 1, top + boxHeight + 3 - 1, gradient1, gradient2);
        GuiHelper.drawGradientRect(left + longestStringWidth + 2, top - 3 + 1, z, left + longestStringWidth + 3, top + boxHeight + 3 - 1, gradient1, gradient2);
        GuiHelper.drawGradientRect(left - 3, top - 3, z, left + longestStringWidth + 3, top - 3 + 1, gradient1, gradient1);
        GuiHelper.drawGradientRect(left - 3, top + boxHeight + 2, z, left + longestStringWidth + 3, top + boxHeight + 3, gradient2, gradient2);
        for (String line : tooltipData) {
            if (!centerText) {
                fontRenderer.func_175063_a(line, (float)left, (float)top, -1);
            } else {
                GuiHelper.drawCenteredString(line, left + longestStringWidth / 2, top, -1);
            }
            top += 10;
        }
        GlStateManager.func_179121_F();
        if (!lighting) {
            RenderHelper.func_74518_a();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return Optional.of(new int[]{left - 4, top - 4, left + longestStringWidth + 4, top + boxHeight + 4});
    }

    public static void drawCenteredString(String text, float x, float y, int color) {
        GuiHelper.drawCenteredString(text, x, y, color, false);
    }

    public static void drawCenteredString(String text, float x, float y, int color, boolean dropShadow) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.func_175065_a(text, x - (float)(fontRenderer.func_78256_a(text) / 2), y, color, dropShadow);
    }

    public static void drawCenteredSplitString(String text, float x, float y, int maxLength, int color) {
        GuiHelper.drawCenteredSplitString(text, x, y, maxLength, color, true);
    }

    public static void drawCenteredSplitString(String text, float x, float y, int maxLength, int color, boolean dropShadow) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int textWidth = fontRenderer.func_78256_a(text);
        int numLines = Math.max(1, (int)Math.ceil((float)textWidth / (float)maxLength));
        int lineWidth = text.length() / numLines;
        ArrayList<String> splitStrings = new ArrayList<String>(numLines);
        int lastIndex = 0;
        for (int i = 0; i < numLines - 1; ++i) {
            int spaceIndex = text.indexOf(" ", lastIndex + lineWidth);
            if (spaceIndex <= -1) continue;
            splitStrings.add(text.substring(lastIndex, spaceIndex + 1));
            lastIndex = spaceIndex + 1;
        }
        if (lastIndex < text.length()) {
            splitStrings.add(text.substring(lastIndex));
        }
        numLines = splitStrings.size();
        int currentY = (int)y - 6 * (numLines - 1);
        for (int i = 0; i < numLines; ++i) {
            GuiHelper.drawCenteredString((String)splitStrings.get(i), x, currentY, color, dropShadow);
            currentY += 12;
        }
    }

    public static void drawCenteredLimitedString(String text, float x, float y, int maxLength, int color) {
        GuiHelper.drawCenteredString(GuiHelper.getLimitedString(text, maxLength), x, y, color, true);
    }

    public static String getLimitedString(String text, int maxLength) {
        String ellipses = "...";
        if (maxLength <= 3) {
            return ellipses;
        }
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int textLength = text.length();
        String drawText = text;
        if (textLength >= 4) {
            int textWidth = 0;
            for (int i = 0; i < text.length(); ++i) {
                if ((textWidth += fontRenderer.func_78263_a(text.charAt(i))) <= maxLength) continue;
                drawText = text.substring(0, i - 3) + ellipses;
                break;
            }
        }
        return drawText;
    }

    public static List<String> splitString(String text, int maxLength) {
        ArrayList<String> splitString = new ArrayList<String>();
        if (text.isEmpty()) {
            splitString.add("");
        } else {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            int lineLength = 0;
            int lineStart = 0;
            int textLength = text.length();
            for (int i = 0; i < text.length(); ++i) {
                char currentChar = text.charAt(i);
                if (currentChar == '\n') {
                    splitString.add(text.substring(lineStart, i + 1));
                    lineStart = i + 1;
                    lineLength = 0;
                    continue;
                }
                int charWidth = fontRenderer.func_78263_a(currentChar);
                if ((lineLength += charWidth) <= maxLength) continue;
                splitString.add(text.substring(lineStart, i));
                lineStart = i;
                lineLength = charWidth;
            }
            if (lineStart < textLength || text.charAt(textLength - 1) == '\n') {
                splitString.add(text.substring(lineStart, textLength));
            }
        }
        return splitString;
    }

    public static String removeNewLine(String string) {
        int length = string.length();
        if (length > 0 && string.charAt(length - 1) == '\n') {
            return string.substring(0, length - 1);
        }
        return string;
    }

    public static void drawGradientRect(int left, int top, float zLevel, int right, int bottom, int startColour, int endColour) {
        GuiHelper.drawGradientRect(left, top, zLevel, right, bottom, startColour, endColour, false);
    }

    public static void drawGradientRect(int left, int top, float zLevel, int right, int bottom, int startColour, int endColour, boolean horizontal) {
        float startAlpha = (float)(startColour >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColour >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColour >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColour & 0xFF) / 255.0f;
        float endAlpha = (float)(endColour >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColour >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColour >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColour & 0xFF) / 255.0f;
        GuiHelper.drawGradientRect(left, top, zLevel, right, bottom, new Vector4f(startRed, startGreen, startBlue, startAlpha), new Vector4f(endRed, endGreen, endBlue, endAlpha), horizontal);
    }

    public static void drawGradientRect(int left, int top, float zLevel, int right, int bottom, Vector4f startColour, Vector4f endColour, boolean horizontal) {
        float startAlpha = startColour.getW();
        float startRed = startColour.getX();
        float startGreen = startColour.getY();
        float startBlue = startColour.getZ();
        float endAlpha = endColour.getW();
        float endRed = endColour.getX();
        float endGreen = endColour.getY();
        float endBlue = endColour.getZ();
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)left, (double)top, (double)zLevel).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        if (horizontal) {
            buffer.func_181662_b((double)left, (double)bottom, (double)zLevel).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        } else {
            buffer.func_181662_b((double)left, (double)bottom, (double)zLevel).func_181666_a(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        }
        buffer.func_181662_b((double)right, (double)bottom, (double)zLevel).func_181666_a(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        if (horizontal) {
            buffer.func_181662_b((double)right, (double)top, (double)zLevel).func_181666_a(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        } else {
            buffer.func_181662_b((double)right, (double)top, (double)zLevel).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void drawEntity(EntityLivingBase ent, int x, int y, float scale, float rotationYaw, float rotationPitch) {
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f2 = ent.field_70761_aq;
        float f3 = ent.field_70177_z;
        float f4 = ent.field_70125_A;
        float f5 = ent.field_70758_at;
        float f6 = ent.field_70759_as;
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-((float)Math.atan(rotationPitch / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        ent.field_70761_aq = (float)Math.atan(rotationYaw / 40.0f) * 20.0f;
        ent.field_70177_z = (float)Math.atan(rotationYaw / 40.0f) * 40.0f;
        ent.field_70125_A = -((float)Math.atan(rotationPitch / 40.0f)) * 20.0f;
        ent.field_70759_as = ent.field_70177_z;
        ent.field_70758_at = ent.field_70177_z;
        GlStateManager.func_179109_b((float)0.0f, (float)((float)ent.func_70033_W()), (float)0.0f);
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        renderManager.field_78735_i = 180.0f;
        renderManager.func_188391_a((Entity)ent, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        ent.field_70761_aq = f2;
        ent.field_70177_z = f3;
        ent.field_70125_A = f4;
        ent.field_70758_at = f5;
        ent.field_70759_as = f6;
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    public static void drawPokemonInfoPC(int x, int y, PixelmonData p, float zLevel) {
        if (p == null) {
            return;
        }
        GuiHelper.drawGradientRect(x - 104, y - 2, zLevel, x + 2, y + 20, -13158600, -13158600);
        String displayName = p.getNickname();
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.field_71466_p.func_78276_b(displayName, x - 102, y, 0xFFFFFF);
        minecraft.field_71446_o.func_110577_a(GuiResources.pixelmonOverlay);
        if (!p.isEgg) {
            if (p.gender != Gender.None) {
                if (p.gender == Gender.Male) {
                    minecraft.field_71446_o.func_110577_a(GuiResources.male);
                } else if (p.gender == Gender.Female) {
                    minecraft.field_71446_o.func_110577_a(GuiResources.female);
                }
                GuiHelper.drawImageQuad(minecraft.field_71466_p.func_78256_a(displayName) + x - 101, y, 5.0, 8.0f, 0.0, 0.0, 1.0, 1.0, 0.0f);
            }
            String levelString = I18n.func_135052_a((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " " + p.lvl;
            minecraft.field_71466_p.func_78276_b(levelString, x + -101, y + minecraft.field_71466_p.field_78288_b + 1, 0xFFFFFF);
            String healthString = "";
            healthString = p.health <= 0 ? I18n.func_135052_a((String)"gui.creativeinv.fainted", (Object[])new Object[0]) : I18n.func_135052_a((String)"nbt.hp.name", (Object[])new Object[0]) + " " + p.health + "/" + p.hp;
            minecraft.field_71466_p.func_78276_b(healthString, x - 97 + minecraft.field_71466_p.func_78256_a(levelString), y + minecraft.field_71466_p.field_78288_b + 1, 0xFFFFFF);
        }
    }

    public static void drawPokemonInfoChooseMove(PixelmonData pokemon, int width, int height, float zLevel) {
        Minecraft mc = Minecraft.func_71410_x();
        GuiHelper.bindPokemonSprite(EnumPokemon.getFromName(pokemon.name).get().getNationalPokedexInteger(), pokemon.form, pokemon.gender, pokemon.isShiny, mc);
        GuiHelper.drawImageQuad(width / 2 - 114, height / 2 - 76, 64.0, 64.0f, 0.0, 0.0, 1.0, 1.0, zLevel);
        GuiHelper.drawCenteredString(pokemon.getNickname(), width / 2 - 82, height / 2 + 8, 0xFFFFFF);
        EnumType type1 = pokemon.getType1();
        EnumType type2 = pokemon.getType2();
        float x = type1.textureX;
        float y = type1.textureY;
        float x1 = 0.0f;
        float y1 = 0.0f;
        if (type2 != null) {
            x1 = type2.textureX;
            y1 = type2.textureY;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.field_71446_o.func_110577_a(GuiResources.types);
        if (type2 != null && type2 != EnumType.Mystery) {
            GuiHelper.drawImageQuad(width / 2 - 83, height / 2 - 84, 21.0, 21.0f, x1 / 495.0f, y1 / 392.0f, (x1 + 98.0f) / 495.0f, (y1 + 98.0f) / 392.0f, zLevel);
            GuiHelper.drawImageQuad(width / 2 - 107, height / 2 - 84, 21.0, 21.0f, x / 495.0f, y / 392.0f, (x + 98.0f) / 495.0f, (y + 98.0f) / 392.0f, zLevel);
        } else {
            GuiHelper.drawImageQuad(width / 2 - 93, height / 2 - 84, 21.0, 21.0f, x / 495.0f, y / 392.0f, (x + 98.0f) / 495.0f, (y + 98.0f) / 392.0f, zLevel);
        }
        mc.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " " + pokemon.lvl, width / 2 - 80, height / 2 - 94, 0xFFFFFF);
        mc.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gui.screenpokechecker.number", (Object[])new Object[0]) + " " + String.valueOf(pokemon.getNationalPokedexNumber()), width / 2 - 122, height / 2 - 94, 0xFFFFFF);
    }

    public static void closeScreen() {
        Keyboard.enableRepeatEvents((boolean)false);
        Minecraft.func_71410_x().field_71439_g.func_71053_j();
    }

    public static void switchFocus(int keyInt, List<GuiTextField> textFields) {
        GuiTextField[] textFieldArray = new GuiTextField[textFields.size()];
        GuiHelper.switchFocus(keyInt, textFields.toArray(textFieldArray));
    }

    public static void switchFocus(int keyInt, GuiTextField ... textFields) {
        if (keyInt == 15) {
            for (int i = 0; i < textFields.length; ++i) {
                GuiTextField textField = textFields[i];
                if (!textField.func_146206_l()) continue;
                textField.func_146195_b(false);
                textFields[(i + 1) % textFields.length].func_146195_b(true);
                return;
            }
            textFields[0].func_146195_b(true);
        }
    }

    public static void drawAttackInfoBox(float zLevel, int width, int height) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71446_o.func_110577_a(GuiResources.cwPanel);
        GlStateManager.func_179124_c((float)0.5f, (float)0.5f, (float)0.5f);
        GuiHelper.drawImageQuad(width / 2 + 100, height / 2 - 90, 100.0, 140.0f, 0.0, 0.0, 1.0, 1.0, zLevel);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        String text = I18n.func_135052_a((String)"gui.choosemoveset.attackdetails", (Object[])new Object[0]);
        mc.field_71466_p.func_78276_b(text, width + 150 - mc.field_71466_p.func_78256_a(text) / 2, height - 92, 0);
    }

    public static void drawAttackInfoList(Attack a, int width, int height) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int y = height / 2 - 85;
        int x = width / 2 + 105;
        String powerString = I18n.func_135052_a((String)"gui.choosemoveset.power", (Object[])new Object[0]) + ": ";
        powerString = a.baseAttack.basePower > 0 ? powerString + a.baseAttack.basePower : powerString + "--";
        fontRenderer.func_78276_b(powerString, x, y + 3, 0);
        String accuracyString = I18n.func_135052_a((String)"gui.battle.accuracy", (Object[])new Object[0]) + ": ";
        accuracyString = a.baseAttack.accuracy > 0 ? accuracyString + a.baseAttack.accuracy : accuracyString + "--";
        fontRenderer.func_78276_b(accuracyString, x, y + 13, 0);
        fontRenderer.func_78276_b(I18n.func_135052_a((String)"nbt.pp.name", (Object[])new Object[0]) + " " + a.pp + "/" + a.ppBase, x, y + 23, 0);
        String typeString = I18n.func_135052_a((String)"gui.battle.type", (Object[])new Object[0]) + " ";
        fontRenderer.func_78276_b(typeString, x, y + 33, 0);
        fontRenderer.func_78276_b(a.baseAttack.attackType.toString(), x + fontRenderer.func_78256_a(typeString), y + 33, a.baseAttack.attackType.getColor());
        String category = Attack.getCategoryString(a.baseAttack.attackCategory);
        fontRenderer.func_78276_b(category, x, y + 43, 0);
        fontRenderer.func_78279_b(a.baseAttack.getLocalizedDescription(), x, y + 58, 95, 0);
    }

    public static void drawAttackInfoMoveset(Attack attack, int y, int width, int height) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.func_78276_b(I18n.func_135052_a((String)"gui.replaceattack.power", (Object[])new Object[0]), width / 2 - 120, height / 2 + 60, 0xFFFFFF);
        fontRenderer.func_78276_b(I18n.func_135052_a((String)"gui.replaceattack.accuracy", (Object[])new Object[0]), width / 2 - 120, height / 2 + 70, 0xFFFFFF);
        int bpextra = 0;
        int acextra = 0;
        if (attack.baseAttack.basePower >= 100) {
            bpextra = fontRenderer.func_78263_a('0');
        }
        if (attack.baseAttack.accuracy >= 100) {
            acextra = fontRenderer.func_78263_a('0');
        }
        String powerString = attack.baseAttack.basePower > 0 ? "" + attack.baseAttack.basePower : "--";
        fontRenderer.func_78276_b(powerString, width / 2 - 60 - bpextra, height / 2 + 60, 0xFFFFFF);
        String accuracyString = attack.baseAttack.accuracy > 0 ? "" + attack.baseAttack.accuracy : "--";
        fontRenderer.func_78276_b(accuracyString, width / 2 - 60 - acextra, height / 2 + 70, 0xFFFFFF);
        fontRenderer.func_78276_b(Attack.getCategoryString(attack.baseAttack.attackCategory), width / 2 - 120, height / 2 + 80, 0xFFFFFF);
        fontRenderer.func_78279_b(I18n.func_135052_a((String)("attack." + attack.baseAttack.getUnLocalizedName().toLowerCase() + ".description"), (Object[])new Object[0]), width / 2 - 20, y, 135, 0xFFFFFF);
    }

    public static void drawMoveset(PixelmonData pokemon, int width, int height, float zLevel) {
        Minecraft mc = Minecraft.func_71410_x();
        for (int i = 0; i < pokemon.numMoves; ++i) {
            PixelmonMovesetData move = pokemon.moveset[i];
            mc.field_71466_p.func_78276_b(move.getAttack().baseAttack.getLocalizedName(), width / 2 + 11, height / 2 - 85 + 22 * i, 0xFFFFFF);
            mc.field_71466_p.func_78276_b(move.pp + "/" + move.ppBase, width / 2 + 90, height / 2 - 83 + 22 * i, 0xFFFFFF);
            float x = move.type.textureX;
            float y = move.type.textureY;
            mc.field_71446_o.func_110577_a(GuiResources.types);
            GuiHelper.drawImageQuad(width / 2 - 23, height / 2 - 92 + 22 * i, 21.0, 21.0f, x / 495.0f, y / 392.0f, (x + 98.0f) / 495.0f, (y + 98.0f) / 392.0f, zLevel);
        }
    }

    public static void textboxKeyTypedLimited(GuiTextField textField, char key, int keyCode, int limit) {
        textField.func_146201_a(key, keyCode);
        String newText = textField.func_146179_b();
        if (newText.length() > limit) {
            newText = newText.substring(0, limit);
            textField.func_146180_a(newText);
        }
    }

    public static int toColourValue(float red, float green, float blue, float alpha) {
        int r = (int)(red * 255.0f) & 0xFF;
        int g = (int)(green * 255.0f) & 0xFF;
        int b = (int)(blue * 255.0f) & 0xFF;
        int a = (int)(alpha * 255.0f) & 0xFF;
        int rgb = (a << 24) + (r << 16) + (b << 8) + g;
        return rgb;
    }

    public static EntityPixelmon getEntity(int[] pokemonID) {
        Minecraft mc = Minecraft.func_71410_x();
        for (int i = 0; i < mc.field_71441_e.field_72996_f.size(); ++i) {
            EntityPixelmon pokemon;
            int[] existingID;
            Entity e = (Entity)mc.field_71441_e.field_72996_f.get(i);
            if (!(e instanceof EntityPixelmon) || (existingID = (pokemon = (EntityPixelmon)e).getPokemonId())[0] == -1 || !PixelmonMethods.isIDSame(pokemon, pokemonID)) continue;
            return pokemon;
        }
        return null;
    }

    public static void drawChatBox(GuiContainer container, String name, List<String> chatText, float zLevel) {
        container.field_146297_k.field_71446_o.func_110577_a(GuiResources.evo);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiHelper.drawImageQuad(container.field_146294_l / 2 - 120, container.field_146295_m / 4 - 40, 240.0, 80.0f, 0.0, 0.0, 1.0, 1.0, zLevel);
        container.field_146297_k.field_71466_p.func_78276_b(name, container.field_146294_l / 2 - 107, container.field_146295_m / 4 - 32, 0xFFFFFF);
        for (int index = 0; index < chatText.size(); ++index) {
            String page;
            int li;
            while (container.field_146297_k.field_71466_p.func_78256_a(chatText.get(index)) > 200 && (li = (page = chatText.get(index)).lastIndexOf(" ")) >= 0) {
                if (index + 1 == chatText.size()) {
                    chatText.add(page.substring(li + 1));
                } else {
                    chatText.set(index + 1, page.substring(li + 1) + " " + chatText.get(index + 1));
                }
                chatText.set(index, page.substring(0, li));
            }
            String currentText = chatText.get(index);
            container.field_146297_k.field_71466_p.func_78276_b(currentText, container.field_146294_l / 2 - container.field_146297_k.field_71466_p.func_78256_a(currentText) / 2, container.field_146295_m / 4 - 20 + index * 14, 0xFFFFFF);
        }
    }

    public static void drawBattleTimer(GuiContainer gui, int time) {
        time = Math.max(time, 0);
        String timerString = I18n.func_135052_a((String)"battlecontroller.afktimer", (Object[])new Object[0]) + time;
        int color = time <= 5 ? 0xFF0000 : 0xFFFFFF;
        gui.func_73731_b(gui.field_146297_k.field_71466_p, timerString, gui.field_146294_l - gui.field_146297_k.field_71466_p.func_78256_a(timerString) - 5, 5, color);
    }
}

