/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui;

import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.gui.GuiCameraOverlay;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiItemDrops;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.enums.items.EnumPokeballs;
import com.pixelmonmod.pixelmon.storage.playerData.ExternalMoveData;
import com.pixelmonmod.pixelmon.util.RegexPatterns;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class GuiPixelmonOverlay
extends Gui {
    public static boolean isGuiMinimized = false;
    public FontRenderer fontRenderer;
    public static int selectedPixelmon;
    public static boolean isVisible;
    private static int sideBarHeight;
    static int count;
    private static String messageName;
    private static String oldMessageName;
    private static UUID uuid;
    private static UUID lastUuid;
    private static int fadeInTicks;
    private static int fadeOutTicks;

    public GuiPixelmonOverlay() {
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (count++ >= 100) {
            count = 0;
            this.checkEntitysInWorld((World)mc.field_71441_e);
        }
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (mc.field_71462_r != null && !isVisible) {
            return;
        }
        if (mc.field_71462_r instanceof GuiInventory || mc.field_71474_y.field_74319_N || mc.field_71462_r instanceof GuiItemDrops) {
            return;
        }
        GuiCameraOverlay.checkCameraOn();
        ScaledResolution var5 = new ScaledResolution(mc);
        int screenWidth = var5.func_78326_a();
        int screenHeight = var5.func_78328_b();
        mc.field_71460_t.func_78478_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        if (GuiCameraOverlay.isCameraGuiOn) {
            GuiCameraOverlay.renderCamera(screenWidth, screenHeight, mc);
        } else {
            PixelmonData[] party;
            int topSideBar = screenHeight / 2 - sideBarHeight / 2;
            int topOffset = topSideBar + 5;
            float slotHeight = 30.0f;
            mc.field_71446_o.func_110577_a(GuiResources.dock);
            this.field_73735_i = -90.0f;
            GuiHelper.drawImageQuad(0.0, topSideBar, 22.0, 203.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
            int leftText = 30;
            this.fontRenderer.func_78264_a(true);
            int i = 0;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiPixelmonOverlay.checkSelection();
            for (PixelmonData p : party = ServerStorageDisplay.getPokemon()) {
                int offset = 0;
                int yPos = topOffset + (int)((float)i * slotHeight) + 9 + offset;
                if (p != null) {
                    if (!isGuiMinimized) {
                        mc.field_71446_o.func_110577_a(GuiResources.textbox);
                        GuiHelper.drawImageQuad(leftText - 28, yPos - 10, 123.0, 34.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                        float textureX = -1.0f;
                        float textureY = -1.0f;
                        if (p.status != null) {
                            float[] texturePair = StatusType.getTexturePos(p.status);
                            textureX = texturePair[0];
                            textureY = texturePair[1];
                        }
                        if (textureX != -1.0f && p.health > 0) {
                            mc.field_71446_o.func_110577_a(GuiResources.status);
                            GuiHelper.drawImageQuad(leftText + 46, yPos + 1, 14.72f, 6.44f, textureX / 299.0f, textureY / 210.0f, (textureX + 147.0f) / 299.0f, (textureY + 68.0f) / 210.0f, this.field_73735_i);
                        }
                    }
                    String displayName = p.getNickname();
                    i = p.order;
                    if (!isGuiMinimized) {
                        this.fontRenderer.func_78276_b(displayName, leftText - 2, yPos, 0xFFFFFF);
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        if (p.gender == Gender.Male && !p.isEgg) {
                            mc.field_71446_o.func_110577_a(GuiResources.male);
                            GuiHelper.drawImageQuad(this.fontRenderer.func_78256_a(displayName) + leftText - 1, yPos, 5.0, 8.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                        } else if (p.gender == Gender.Female && !p.isEgg) {
                            mc.field_71446_o.func_110577_a(GuiResources.female);
                            GuiHelper.drawImageQuad(this.fontRenderer.func_78256_a(displayName) + leftText - 1, yPos, 5.0, 8.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                        }
                    }
                    this.bindPokeballTexture(p.pokeball);
                    GuiHelper.drawImageQuad(-3.0, yPos - 7, 32.0, 32.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                    if (i == selectedPixelmon) {
                        if (p.isFainted) {
                            mc.field_71446_o.func_110577_a(GuiResources.faintedSelected);
                        } else if (p.outside) {
                            mc.field_71446_o.func_110577_a(GuiResources.releasedSelected);
                        } else {
                            mc.field_71446_o.func_110577_a(GuiResources.selected);
                        }
                    } else if (p.isFainted) {
                        mc.field_71446_o.func_110577_a(GuiResources.fainted);
                    } else if (p.outside) {
                        mc.field_71446_o.func_110577_a(GuiResources.released);
                    } else {
                        mc.field_71446_o.func_110577_a(GuiResources.normal);
                    }
                    GuiHelper.drawImageQuad(-3.0, yPos - 7, 32.0, 32.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                    this.drawPokemonSprite(p, yPos, mc);
                    if (!p.heldItem.func_190926_b()) {
                        mc.field_71446_o.func_110577_a(GuiResources.heldItem);
                        GuiHelper.drawImageQuad(18.0, yPos + 13, 6.0, 6.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                    }
                    if (!isGuiMinimized && !p.isEgg) {
                        String levelString = I18n.func_135052_a((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " " + p.lvl;
                        this.fontRenderer.func_78276_b(levelString, leftText - 1, yPos + 1 + this.fontRenderer.field_78288_b, 0xFFFFFF);
                        if (p.health <= 0) {
                            this.fontRenderer.func_78276_b(I18n.func_135052_a((String)"gui.creativeinv.fainted", (Object[])new Object[0]), leftText + 1 + this.fontRenderer.func_78256_a(levelString), yPos + 1 + this.fontRenderer.field_78288_b, 0xFFFFFF);
                        } else {
                            this.fontRenderer.func_78276_b(I18n.func_135052_a((String)"nbt.hp.name", (Object[])new Object[0]) + " " + p.health + "/" + p.hp, leftText + 2 + this.fontRenderer.func_78256_a(levelString), yPos + 1 + this.fontRenderer.field_78288_b, 0xFFFFFF);
                        }
                    }
                } else {
                    mc.field_71446_o.func_110577_a(GuiResources.available);
                    GuiHelper.drawImageQuad(5.0, yPos + 1, 16.0, 16.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                }
                ++i;
            }
            PixelmonData poke = party[selectedPixelmon];
            ScaledResolution eventResolution = event.getResolution();
            int scaledWidth = eventResolution.func_78326_a();
            if (PixelmonConfig.showTarget && poke != null && poke.outside) {
                mc.field_71446_o.func_110577_a(GuiResources.targetArea);
                GuiHelper.drawImageQuad(scaledWidth - 76, 2.0, 24.0, 24.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                this.fontRenderer.func_78276_b(GameSettings.func_74298_c((int)ClientProxy.actionKeyBind.func_151463_i()), scaledWidth - 50, 0, 0xFFFFFF);
                if (poke.targetId != -1) {
                    EntityLivingBase entity = (EntityLivingBase)mc.field_71441_e.func_73045_a(poke.targetId);
                    if (entity instanceof EntityPixelmon) {
                        EntityPixelmon pokemon = (EntityPixelmon)entity;
                        if (pokemon.baseStats == null) {
                            GuiHelper.bindPokemonSprite(1, false, mc);
                        } else {
                            GuiHelper.bindPokemonSprite(pokemon.getSpecies().getNationalPokedexInteger(), pokemon.getForm(), pokemon.getGender(), pokemon.getSpecialTextureIndex(), pokemon.getIsShiny(), mc);
                        }
                        GuiHelper.drawImageQuad(scaledWidth - 75, 3.0, 20.0, 20.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                    } else if (entity instanceof EntityPlayer) {
                        mc.func_175598_ae().field_78724_e.func_110577_a(((AbstractClientPlayer)entity).func_110306_p());
                        GuiHelper.drawImageQuad(scaledWidth - 73, 5.0, 18.0, 18.0f, 0.125, 0.125, 0.25, 0.25, this.field_73735_i);
                    } else if (entity instanceof NPCTrainer) {
                        mc.func_175598_ae().field_78724_e.func_110577_a(AbstractClientPlayer.func_110311_f((String)""));
                        GuiHelper.drawImageQuad(scaledWidth - 73, 5.0, 18.0, 18.0f, 0.125, 0.125, 0.25, 0.25, this.field_73735_i);
                    }
                } else {
                    mc.field_71446_o.func_110577_a(GuiResources.notarget);
                    GuiHelper.drawImageQuad(scaledWidth - 76, 2.0, 24.0, 24.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                }
                mc.field_71446_o.func_110577_a(GuiResources.targetAreaOver);
                GuiHelper.drawImageQuad(scaledWidth - 76, 2.0, 24.0, 24.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
            }
            if (poke != null && poke.outside && PixelmonConfig.allowExternalMoves) {
                ExternalMoveData[] moves = poke.getExternalMoves();
                short index = poke.selectedMoveIndex;
                if (moves != null) {
                    if (moves.length > index) {
                        mc.field_71446_o.func_110577_a(GuiResources.targetArea);
                        GuiHelper.drawImageQuad(scaledWidth - 42, 2.0, 24.0, 24.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                        ExternalMoveData move = moves[index];
                        mc.field_71446_o.func_110577_a(move.getBaseExternalMove().getIcon());
                        GuiHelper.drawImageQuad(scaledWidth - 42, 2.0, 24.0, 24.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                        mc.field_71446_o.func_110577_a(GuiResources.targetAreaOver);
                        GuiHelper.drawImageQuad(scaledWidth - 42, 2.0, 24.0, 24.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                        double cooldown = move.getBaseExternalMove().getCooldown(poke);
                        if ((double)mc.field_71441_e.func_82737_E() < (double)move.timeLastUsed + cooldown) {
                            double percentLeft = mc.field_71441_e.func_82737_E() - move.timeLastUsed;
                            percentLeft = 1.0 - percentLeft / cooldown;
                            mc.field_71446_o.func_110577_a(GuiResources.cooldown);
                            int pixels = (int)(percentLeft * 24.0);
                            GuiHelper.drawImageQuad(scaledWidth - 42, 26 - pixels, 24.0, pixels, 0.0, 1.0f - (float)pixels / 24.0f, 1.0, 1.0, this.field_73735_i);
                        }
                        this.fontRenderer.func_78276_b(GameSettings.func_74298_c((int)ClientProxy.externalKeyBind.func_151463_i()), scaledWidth - 17, 0, 0xFFFFFF);
                        String nameString = "";
                        nameString = move.moveIndex == 5 ? I18n.func_135052_a((String)"externalMove.forage.name", (Object[])new Object[0]) : (move.moveIndex == 99 ? I18n.func_135052_a((String)"externalMove.megaEvolution.name", (Object[])new Object[0]) : poke.moveset[move.moveIndex].getAttack().baseAttack.getLocalizedName());
                        this.fontRenderer.func_78276_b(nameString, scaledWidth - 30 - this.fontRenderer.func_78256_a(nameString) / 2, 24, 0xFFFFFF);
                    } else {
                        poke.selectedMoveIndex = 0;
                    }
                }
            }
            int scaledHeight = eventResolution.func_78328_b();
            if (ClientProxy.wikiKeyBind.func_151463_i() != 0) {
                this.fontRenderer.func_78276_b(GameSettings.func_74298_c((int)ClientProxy.wikiKeyBind.func_151463_i()), scaledWidth - 35, scaledHeight - 13, 0xFFFFFF);
                mc.field_71446_o.func_110577_a(GuiResources.wikiItemIcon);
                GuiHelper.drawImageQuad(scaledWidth - 55, scaledHeight - 30, 20.0, 20.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
            }
            if (ClientProxy.pokedexKeyBind.func_151463_i() != 0) {
                this.fontRenderer.func_78276_b(GameSettings.func_74298_c((int)ClientProxy.pokedexKeyBind.func_151463_i()), scaledWidth - 10, scaledHeight - 13, 0xFFFFFF);
                mc.field_71446_o.func_110577_a(GuiResources.pokedexItemIcon);
                GuiHelper.drawImageQuad(scaledWidth - 30, scaledHeight - 30, 20.0, 20.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
            }
            this.renderSpectateMessage(screenWidth, screenHeight);
        }
        this.fontRenderer.func_78264_a(false);
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
    }

    private void drawPokemonSprite(PixelmonData p, int yPos, Minecraft mc) {
        GuiHelper.bindPokemonSprite(p, mc);
        GuiHelper.drawImageQuad(1.0, yPos - 3 - (p.isGen6Sprite() ? 0 : 3), 24.0, 24.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
    }

    public void checkEntitysInWorld(World world) {
        PixelmonData[] party;
        for (PixelmonData p : party = ServerStorageDisplay.getPokemon()) {
            if (p == null) continue;
            p.outside = false;
        }
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            int[] existingID;
            Entity e = (Entity)world.field_72996_f.get(i);
            if (!(e instanceof EntityPixelmon) || (existingID = ((EntityPixelmon)e).getPokemonId())[0] == -1) continue;
            for (PixelmonData p : party) {
                if (p == null || !PixelmonMethods.isIDSame((EntityPixelmon)e, p.pokemonID)) continue;
                p.outside = true;
                p.outsideEntity = (EntityPixelmon)e;
            }
        }
    }

    public static void selectNextPixelmon() {
        if (ServerStorageDisplay.count() == 0 || ServerStorageDisplay.countNonEgg() == 0) {
            return;
        }
        if (++selectedPixelmon >= 6) {
            selectedPixelmon = 0;
        }
        PixelmonData[] party = ServerStorageDisplay.getPokemon();
        while (party[selectedPixelmon] == null || party[GuiPixelmonOverlay.selectedPixelmon].isEgg) {
            if (++selectedPixelmon < 6) continue;
            selectedPixelmon = 0;
        }
    }

    public static void selectPreviousPixelmon() {
        if (ServerStorageDisplay.count() == 0 || ServerStorageDisplay.countNonEgg() == 0) {
            return;
        }
        if (--selectedPixelmon < 0) {
            selectedPixelmon = 5;
        }
        PixelmonData[] party = ServerStorageDisplay.getPokemon();
        while (party[selectedPixelmon] == null || party[GuiPixelmonOverlay.selectedPixelmon].isEgg) {
            if (--selectedPixelmon >= 0) continue;
            selectedPixelmon = 5;
        }
    }

    public static void checkSelection() {
        PixelmonData current = ServerStorageDisplay.getPokemon()[selectedPixelmon];
        if ((current == null || current.isEgg) && !ClientProxy.battleManager.isBattling()) {
            GuiPixelmonOverlay.selectPreviousPixelmon();
        }
    }

    public static void selectNextExternalMove() {
        PixelmonData current = ServerStorageDisplay.getPokemon()[selectedPixelmon];
        if (current != null) {
            short index;
            ExternalMoveData[] moves = current.getExternalMoves();
            index = moves.length > (index = current.selectedMoveIndex) + 1 ? (short)(index + 1) : (short)0;
            current.selectedMoveIndex = index;
        }
    }

    private void bindPokeballTexture(EnumPokeballs ball) {
        ResourceLocation tex = null;
        switch (ball) {
            case DiveBall: {
                tex = GuiResources.dive;
                break;
            }
            case FastBall: {
                tex = GuiResources.fast;
                break;
            }
            case DuskBall: {
                tex = GuiResources.dusk;
                break;
            }
            case FriendBall: {
                tex = GuiResources.friend;
                break;
            }
            case GreatBall: {
                tex = GuiResources.great;
                break;
            }
            case HealBall: {
                tex = GuiResources.heal;
                break;
            }
            case HeavyBall: {
                tex = GuiResources.heavy;
                break;
            }
            case LevelBall: {
                tex = GuiResources.level;
                break;
            }
            case LoveBall: {
                tex = GuiResources.love;
                break;
            }
            case LuxuryBall: {
                tex = GuiResources.luxury;
                break;
            }
            case MasterBall: {
                tex = GuiResources.master;
                break;
            }
            case MoonBall: {
                tex = GuiResources.moon;
                break;
            }
            case NestBall: {
                tex = GuiResources.nest;
                break;
            }
            case NetBall: {
                tex = GuiResources.net;
                break;
            }
            case PokeBall: {
                tex = GuiResources.poke;
                break;
            }
            case PremierBall: {
                tex = GuiResources.premier;
                break;
            }
            case RepeatBall: {
                tex = GuiResources.repeat;
                break;
            }
            case SafariBall: {
                tex = GuiResources.safari;
                break;
            }
            case TimerBall: {
                tex = GuiResources.timer;
                break;
            }
            case UltraBall: {
                tex = GuiResources.ultra;
                break;
            }
            case CherishBall: {
                tex = GuiResources.cherish;
                break;
            }
            case GSBall: {
                tex = GuiResources.gs;
                break;
            }
            case LureBall: {
                tex = GuiResources.lure;
                break;
            }
            case ParkBall: {
                tex = GuiResources.park;
                break;
            }
            case QuickBall: {
                tex = GuiResources.quick;
                break;
            }
            case SportBall: {
                tex = GuiResources.sport;
                break;
            }
            case BeastBall: {
                tex = GuiResources.beast;
            }
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(tex);
    }

    public static void showSpectateMessage(UUID playerUuid) {
        EntityPlayer player = Minecraft.func_71410_x().field_71441_e.func_152378_a(playerUuid);
        if (player == null) {
            return;
        }
        messageName = player.getDisplayNameString();
        uuid = playerUuid;
        fadeInTicks = 20;
    }

    public static void hideSpectateMessage(UUID playerUuid) {
        if (uuid == null) {
            fadeOutTicks = 0;
            messageName = null;
            return;
        }
        EntityPlayer player = Minecraft.func_71410_x().field_71441_e.func_152378_a(uuid);
        if (player == null) {
            fadeOutTicks = 0;
            uuid = null;
            messageName = null;
            return;
        }
        fadeOutTicks = 15;
        oldMessageName = player.getDisplayNameString();
        lastUuid = uuid;
        if (uuid.equals(playerUuid)) {
            messageName = null;
            uuid = null;
        }
    }

    private void renderSpectateMessage(int screenWidth, int screenHeight) {
        int c;
        float alpha;
        int width;
        String spectateString;
        if (messageName != null) {
            spectateString = RegexPatterns.$_L_VAR.matcher(RegexPatterns.$_P_VAR.matcher(I18n.func_135052_a((String)"gui.spectate.spectateMessage", (Object[])new Object[0])).replaceAll(messageName)).replaceAll(GameSettings.func_74298_c((int)ClientProxy.spectateKeyBind.func_151463_i()));
            width = this.fontRenderer.func_78256_a(spectateString);
            alpha = 1.0f - (float)fadeInTicks / 20.0f * 0.7f;
            c = GuiHelper.toColourValue(0.7f, 0.7f, 0.7f, alpha);
            this.fontRenderer.func_78276_b(spectateString, screenWidth / 2 - width / 2, screenHeight / 2 + 30, c);
        }
        if (oldMessageName != null && fadeOutTicks > 0) {
            spectateString = RegexPatterns.$_L_VAR.matcher(RegexPatterns.$_P_VAR.matcher(I18n.func_135052_a((String)"gui.spectate.spectateMessage", (Object[])new Object[0])).replaceAll(oldMessageName)).replaceAll(GameSettings.func_74298_c((int)ClientProxy.spectateKeyBind.func_151463_i()));
            width = this.fontRenderer.func_78256_a(spectateString);
            alpha = (float)fadeOutTicks / 15.0f * 0.7f;
            c = GuiHelper.toColourValue(0.7f, 0.7f, 0.7f, alpha);
            this.fontRenderer.func_78276_b(spectateString, screenWidth / 2 - width / 2, screenHeight / 2 + 30, c);
        }
    }

    public static void onPlayerTick() {
        if (fadeInTicks > 0) {
            --fadeInTicks;
        }
        if (fadeOutTicks > 0) {
            --fadeOutTicks;
        }
    }

    public static UUID getCurrentSpectatingUUID() {
        if (uuid != null) {
            return uuid;
        }
        if (lastUuid != null && fadeOutTicks > 0) {
            return lastUuid;
        }
        return null;
    }

    static {
        isVisible = true;
        sideBarHeight = 200;
        count = 100;
        messageName = null;
        oldMessageName = null;
        fadeInTicks = 0;
        fadeOutTicks = 0;
    }
}

