/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.TargetingInfo;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.GlobalStatusController;
import com.pixelmonmod.pixelmon.battles.status.Weather;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.camera.GuiChattableCamera;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiPixelmonOverlay;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.client.gui.battles.ClientBattleManager;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.BattleScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.ChooseAttackScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.ChooseBag;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.ChooseTargets;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.LevelUpScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.MainMenu;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.MegaEvolution;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.UseBag;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.chooseMove.ChooseEther;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.chooseMove.ReplaceAttack;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.choosePokemon.ApplyToPokemon;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.choosePokemon.ChooseLearnMove;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.choosePokemon.ChoosePokemon;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.choosePokemon.EnforcedSwitch;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.yesNo.YesNoForfeit;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.yesNo.YesNoReplaceMove;
import com.pixelmonmod.pixelmon.client.gui.battles.pokemonOverlays.Overlay1v1;
import com.pixelmonmod.pixelmon.client.gui.battles.pokemonOverlays.Overlay2v2;
import com.pixelmonmod.pixelmon.client.gui.battles.pokemonOverlays.OverlayBase;
import com.pixelmonmod.pixelmon.client.gui.elements.GuiChatExtension;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.PixelmonMovesetData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.BattleGuiClosed;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.RemoveSpectator;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumGui;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.battle.BattleMode;
import com.pixelmonmod.pixelmon.storage.ClientData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;

public class GuiBattle
extends GuiChattableCamera {
    private int guiWidth = 300;
    private int guiHeight = 60;
    public ClientBattleManager bm;
    ArrayList<BattleScreen> screenList = new ArrayList();
    BattleScreen currentScreen = null;
    public OverlayBase pokemonOverlay = null;
    private GuiButton stopSpectateButton = null;
    private Queue<String> messageLog = new LinkedList<String>();
    private static final int NUM_MESSAGES = 4;
    private boolean isLevelScreenDrawn;
    boolean first = true;
    int flashCount = 0;
    public int mouseOverButton = 0;

    public GuiBattle() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        player.func_70637_d(false);
        player.func_70095_a(false);
        player.field_70702_br = 0.0f;
        player.field_191988_bg = 0.0f;
        GuiPixelmonOverlay.isVisible = false;
        this.bm = ClientProxy.battleManager;
        this.screenList.add(new ApplyToPokemon(this));
        this.screenList.add(new ChooseAttackScreen(this));
        this.screenList.add(new ChooseBag(this));
        this.screenList.add(new ChooseEther(this));
        this.screenList.add(new ChooseLearnMove(this, BattleMode.ChooseRelearnMove));
        this.screenList.add(new ChooseLearnMove(this, BattleMode.ChooseTutor));
        this.screenList.add(new ChoosePokemon(this));
        this.screenList.add(new ChooseTargets(this));
        this.screenList.add(new EnforcedSwitch(this));
        this.screenList.add(new LevelUpScreen(this));
        this.screenList.add(new MainMenu(this));
        this.screenList.add(new MegaEvolution(this));
        this.screenList.add(new ReplaceAttack(this));
        this.screenList.add(new UseBag(this));
        this.screenList.add(new YesNoForfeit(this));
        this.screenList.add(new YesNoReplaceMove(this));
        if (this.bm.teamPokemon != null && this.bm.displayedEnemyPokemon != null) {
            if (this.bm.teamPokemon.length == 1 && this.bm.displayedEnemyPokemon.length == 1) {
                this.pokemonOverlay = new Overlay1v1(this);
            } else if (this.bm.teamPokemon.length == 2 || this.bm.displayedEnemyPokemon.length == 2) {
                this.pokemonOverlay = new Overlay2v2(this);
            }
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.bm.isSpectating) {
            this.addStopSpectateButton();
            this.messageLog.clear();
        }
    }

    private void addStopSpectateButton() {
        this.stopSpectateButton = new GuiButton(0, this.field_146294_l / 2 - 50, 0, 100, 20, I18n.func_74838_a((String)"gui.spectate.stopspectate"));
        this.field_146292_n.add(this.stopSpectateButton);
    }

    public void restoreSettingsAndClose() {
        this.bm.restoreSettingsAndClose();
        this.field_146297_k.field_71439_g.func_71053_j();
        GuiPixelmonOverlay.isVisible = true;
        if (ServerStorageDisplay.bossDrops != null) {
            Minecraft.func_71410_x().field_71439_g.openGui((Object)Pixelmon.instance, EnumGui.ItemDrops.getIndex().intValue(), (World)Minecraft.func_71410_x().field_71441_e, 0, 0, 0);
        } else if (!this.bm.evolveList.isEmpty()) {
            Minecraft.func_71410_x().field_71439_g.openGui((Object)Pixelmon.instance, EnumGui.Evolution.getIndex().intValue(), (World)Minecraft.func_71410_x().field_71441_e, 0, 0, 0);
        } else if (ClientData.openMegaItemGui) {
            Minecraft.func_71410_x().field_71439_g.openGui((Object)Pixelmon.instance, EnumGui.MegaItem.getIndex().intValue(), (World)Minecraft.func_71410_x().field_71441_e, 1, 0, 0);
        } else {
            Pixelmon.network.sendToServer((IMessage)new BattleGuiClosed());
        }
    }

    private void selectScreen() {
        for (BattleScreen bs : this.screenList) {
            if (!bs.isScreen()) continue;
            this.currentScreen = bs;
            break;
        }
    }

    public void selectScreenImmediate(BattleMode mode) {
        this.bm.mode = mode;
        this.selectScreen();
    }

    private void drawPokemonOverlays() {
        if (this.pokemonOverlay != null) {
            this.pokemonOverlay.draw(this.field_146294_l, this.field_146295_m, this.guiWidth, this.guiHeight);
        }
    }

    private void drawMessageScreen() {
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.battleGui3);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = this.getGuiWidth();
        GuiHelper.drawImageQuad(this.field_146294_l / 2 - guiWidth / 2, this.field_146295_m - this.guiHeight, guiWidth, this.guiHeight, 0.0, 0.0, 1.0, 0.30416667461395264, this.field_73735_i);
        if (this.bm.isSpectating) {
            if (this.bm.hasMoreMessages()) {
                String message = this.bm.getNextMessage();
                this.bm.removeMessage();
                this.addToMessageLog(message);
            }
            if (this.messageLog.isEmpty()) {
                this.drawWaiting();
            } else {
                int i = 4 - this.messageLog.size();
                int messageHeight = (this.guiHeight - 6) / 4;
                for (String message : this.messageLog) {
                    int color = 0xFFFFFF;
                    if (i == 3) {
                        color = 0xFFFF00;
                    }
                    GuiHelper.drawCenteredLimitedString(message, this.field_146294_l / 2, this.field_146295_m - (i + 1) * messageHeight, 280, color);
                    ++i;
                }
            }
        } else if (this.bm.hasMoreMessages()) {
            String message = this.bm.getNextMessage();
            GuiHelper.drawCenteredSplitString(message, this.field_146294_l / 2, this.field_146295_m - 35, 280, 0xFFFFFF);
            ++this.flashCount;
            if (this.flashCount > 30) {
                int continueTime;
                this.field_146297_k.field_71446_o.func_110577_a(GuiResources.battleGui3);
                GuiHelper.drawImageQuad(this.field_146294_l / 2 + 130, this.field_146295_m - 15, 10.0, 6.0f, 0.9546874761581421, 0.31041666865348816, 0.98125f, 0.33125f, this.field_73735_i);
                int n = continueTime = this.bm.afkActive ? 30 : 480;
                if (this.flashCount > continueTime) {
                    this.continueMessages();
                }
            }
        } else {
            this.drawWaiting();
        }
    }

    private void drawWaiting() {
        ++this.flashCount;
        if (this.flashCount >= 160) {
            this.flashCount = 0;
        }
        String ellipses = "";
        if (this.flashCount < 80) {
            ellipses = ".";
        } else if (this.flashCount < 120) {
            ellipses = "..";
        } else if (this.flashCount < 160) {
            ellipses = "...";
        }
        this.func_73732_a(this.field_146297_k.field_71466_p, I18n.func_74838_a((String)"gui.guiDoctor.waiting") + ellipses, this.field_146294_l / 2, this.field_146295_m - 35, 0xFFFFFF);
        this.bm.waitingText = true;
    }

    private void addToMessageLog(String message) {
        this.messageLog.add(message);
        if (this.messageLog.size() > 4) {
            this.messageLog.remove();
        }
    }

    public static void drawHealthBar(int x, int y, int width, int height, float health, int maxHealth) {
        float b;
        float g;
        float r;
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179090_x();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        int barWidth = width - 6;
        buffer.func_181662_b((double)x, (double)y, 0.0).func_181666_a(0.4f, 0.4f, 0.4f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)x, (double)(y + height), 0.0).func_181666_a(0.4f, 0.4f, 0.4f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)(x + barWidth), (double)(y + height), 0.0).func_181666_a(0.4f, 0.4f, 0.4f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)(x + barWidth), (double)y, 0.0).func_181666_a(0.4f, 0.4f, 0.4f, 1.0f).func_181675_d();
        float Percent = health / (float)maxHealth;
        float CurWidth = Percent * (float)barWidth;
        if (health <= (float)(maxHealth / 5)) {
            r = 0.8f;
            g = 0.0f;
            b = 0.0f;
        } else if (health <= (float)(maxHealth / 2)) {
            r = 1.0f;
            g = 1.0f;
            b = 0.4f;
        } else {
            r = 0.2f;
            g = 1.0f;
            b = 0.2f;
        }
        buffer.func_181662_b((double)x, (double)y, 0.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
        buffer.func_181662_b((double)x, (double)(y + height), 0.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
        buffer.func_181662_b((double)((float)x + CurWidth), (double)(y + height), 0.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
        buffer.func_181662_b((double)((float)x + CurWidth), (double)y, 0.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
        GlStateManager.func_179101_C();
        GlStateManager.func_179119_h();
    }

    public void drawButton(BattleMode mode, int x, int y, int buttonWidth, int buttonHeight, String string, int mouseX, int mouseY, int ind) {
        this.drawButton(mode, x, y, buttonWidth, buttonHeight, string, false, mouseX, mouseY, ind);
    }

    public void drawButton(BattleMode mode, int x, int y, int buttonWidth, int buttonHeight, String string, boolean isDisabled, int mouseX, int mouseY, int ind) {
        int guiHeight = this.getGuiHeight();
        int guiWidth = this.getGuiWidth();
        if (mode == BattleMode.MainMenu) {
            if (mouseX > x && mouseX < x + buttonWidth && mouseY > y && mouseY < y + buttonHeight) {
                GuiHelper.drawImageQuad(x, y, buttonWidth, buttonHeight, 0.604687511920929, 0.3291666805744171, 0.7640625238418579, 0.40833333134651184, this.field_73735_i);
            }
        } else if (mode == BattleMode.ChooseAttack) {
            GuiHelper.drawImageQuad(x, y, buttonWidth, buttonHeight, 0.321875f, 0.3166666626930237, 0.614062488079071, 0.4208333194255829, this.field_73735_i);
            if (mouseX > x && mouseX < x + buttonWidth && mouseY > y && mouseY < y + buttonHeight) {
                GuiHelper.drawImageQuad(x + 2, y + 2, buttonWidth - 5, buttonHeight - 4, 0.0359375f, 0.3229166567325592, 0.3125, 0.40625, this.field_73735_i);
                this.mouseOverButton = ind;
                PixelmonData poke = this.bm.getUserPokemonPacket();
                PixelmonMovesetData[] moves = poke.moveset;
                this.field_146297_k.field_71446_o.func_110577_a(new ResourceLocation("pixelmon:textures/gui/battle-description.png"));
                GuiHelper.drawImageQuad((double)(this.field_146294_l / 2 - guiWidth / 2) - 170.0, this.field_146295_m - guiHeight, 170.0, 71.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                if (ind < 4) {
                    this.field_146289_q.func_78279_b(moves[ind].getAttack().baseAttack.getLocalizedDescription(), this.field_146294_l / 2 - guiWidth / 2 - 164, this.field_146295_m - guiHeight + 6, 160, 0xFFFFFF);
                } else {
                    this.field_146289_q.func_78279_b(I18n.func_74838_a((String)"gui.battle.mega.description"), this.field_146294_l / 2 - guiWidth / 2 - 164, this.field_146295_m - guiHeight + 6, 160, 0xFFFFFF);
                }
            }
        }
        if (!isDisabled) {
            this.func_73732_a(this.field_146297_k.field_71466_p, string, x + buttonWidth / 2, y + buttonHeight / 2 - 3, 0xFFFFFF);
        } else {
            this.field_146297_k.field_71466_p.func_78276_b(string, x + buttonWidth / 2 - this.field_146297_k.field_71466_p.func_78256_a(string) / 2, y + buttonHeight / 2 - 3, 0xCCCCCC);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public void func_146282_l() {
        if (Keyboard.getEventKeyState()) {
            int i = Keyboard.getEventKey();
            char c0 = Keyboard.getEventCharacter();
            this.func_73869_a(c0, i);
        }
        try {
            super.func_146282_l();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void func_73869_a(char key, int keyCode) {
        try {
            super.func_73869_a(key, keyCode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!GuiChatExtension.chatOpen && keyCode == 28 && this.bm.hasMoreMessages()) {
            this.continueMessages();
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        try {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.bm.hasMoreMessages() && !this.isLevelScreenDrawn) {
            this.continueMessages();
        } else if (this.bm.mode != BattleMode.Waiting && this.currentScreen != null) {
            this.currentScreen.click(this.field_146294_l, this.field_146295_m, mouseX, mouseY);
        }
    }

    private boolean isLevelingUp() {
        return this.bm.mode == BattleMode.LevelUp || this.bm.mode == BattleMode.ReplaceAttack || this.bm.mode == BattleMode.YesNoReplaceMove || this.bm.hasNewAttacks();
    }

    protected void continueMessages() {
        this.flashCount = 0;
        this.bm.removeMessage();
        this.bm.checkClearedMessages();
    }

    @Override
    public void func_146278_c(int par1) {
    }

    @Override
    public void func_146276_q_() {
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float par3) {
        Weather weather;
        GlobalStatusController controller;
        BattleControllerBase bc;
        EntityPixelmon pokemon;
        super.func_73863_a(mouseX, mouseY, par3);
        this.func_146276_q_();
        if (this.bm.mode != BattleMode.YesNoReplaceMove) {
            if (this.bm.hasLevelUps()) {
                if (this.bm.mode != BattleMode.LevelUp) {
                    this.bm.oldMode = this.bm.mode;
                    this.bm.mode = BattleMode.LevelUp;
                }
            } else if (this.bm.hasNewAttacks() && this.bm.mode != BattleMode.ReplaceAttack) {
                this.bm.oldMode = this.bm.mode;
                this.bm.mode = BattleMode.ReplaceAttack;
            }
        }
        if ((this.bm.mode == BattleMode.MainMenu || this.bm.mode == BattleMode.ChooseAttack || this.bm.mode == BattleMode.ApplyToPokemon) && (pokemon = this.bm.getUserPokemon()) != null && (bc = BattleRegistry.getBattle(this.bm.battleControllerIndex)) != null && (controller = bc.globalStatusController) != null && (weather = controller.getWeather()) != null) {
            this.field_146297_k.field_71446_o.func_110577_a(new ResourceLocation("pixelmon:textures/gui/weather/" + weather.type.name().toLowerCase() + ".png"));
            GuiHelper.drawImageQuad(this.field_146294_l - 35, (double)this.field_146295_m - 35.0, 32.0, 32.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        }
        this.selectScreen();
        if (this.first) {
            this.first = false;
            if (ClientProxy.camera != null && !this.bm.battleEnded) {
                this.bm.setCameraToPlayer();
            }
        }
        if (!(this.bm.hasMoreMessages() || !this.bm.battleEnded || this.bm.hasLevelUps() || this.bm.hasNewAttacks() || this.bm.choosingPokemon)) {
            this.restoreSettingsAndClose();
        } else {
            boolean hasMoreMessages;
            RenderHelper.func_74518_a();
            GlStateManager.func_179147_l();
            boolean overlayDrawn = false;
            if (!(this.bm.hasLevelUps() || this.bm.hasNewAttacks() || this.bm.mode != BattleMode.Waiting && this.bm.mode != BattleMode.MainMenu && this.bm.mode != BattleMode.ChooseAttack && this.bm.mode != BattleMode.ChooseTargets && this.bm.mode != BattleMode.EnforcedSwitch)) {
                this.drawPokemonOverlays();
                overlayDrawn = true;
            }
            if ((!(hasMoreMessages = this.bm.hasMoreMessages()) || this.isLevelScreenDrawn) && this.bm.mode != BattleMode.Waiting) {
                if (this.currentScreen != null) {
                    this.currentScreen.drawScreen(this.field_146294_l, this.field_146295_m, mouseX, mouseY);
                    this.isLevelScreenDrawn = this.isLevelingUp();
                }
            } else {
                this.drawMessageScreen();
                if (!overlayDrawn) {
                    this.drawPokemonOverlays();
                    overlayDrawn = true;
                }
            }
            if (this.bm.isSpectating) {
                if (this.stopSpectateButton == null) {
                    this.addStopSpectateButton();
                }
                this.stopSpectateButton.func_191745_a(this.field_146297_k, mouseX, mouseY, 1.0f);
            }
            if (this.bm.afkOn) {
                GuiHelper.drawBattleTimer(this, this.bm.afkTime);
                if (this.bm.afkTime <= 0) {
                    this.bm.afkActive = true;
                    this.bm.clearMessages();
                    this.bm.afkSelectMove();
                    this.bm.resetAFKTime();
                }
            }
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.currentScreen != null) {
            this.currentScreen.func_73876_c();
        }
    }

    public int getGuiWidth() {
        return this.guiWidth;
    }

    public int getGuiHeight() {
        return this.guiHeight;
    }

    public void setTargetting(Attack attack, int opponentTarget, int userTarget) {
        for (int i = 0; i < this.bm.targetted.length; ++i) {
            for (int j = 0; j < this.bm.targetted[i].length; ++j) {
                this.bm.targetted[i][j] = false;
            }
        }
        TargetingInfo info = attack.baseAttack.targetingInfo;
        if (info.hitsAll) {
            if (info.hitsOppositeFoe && this.bm.currentPokemon < this.bm.targetted[1].length) {
                this.bm.targetted[1][this.bm.currentPokemon] = true;
            }
            if (info.hitsAdjacentFoe) {
                if (this.bm.currentPokemon - 1 >= 0) {
                    this.bm.targetted[1][this.bm.currentPokemon - 1] = true;
                }
                if (this.bm.currentPokemon + 1 < this.bm.targetted[1].length) {
                    this.bm.targetted[1][this.bm.currentPokemon + 1] = true;
                }
            }
            if (info.hitsExtendedFoe) {
                if (this.bm.currentPokemon - 2 >= 0) {
                    this.bm.targetted[1][this.bm.currentPokemon - 2] = true;
                }
                if (this.bm.currentPokemon + 2 < this.bm.targetted[1].length) {
                    this.bm.targetted[1][this.bm.currentPokemon + 2] = true;
                }
            }
            if (info.hitsSelf) {
                this.bm.targetted[0][this.bm.currentPokemon] = true;
            }
            if (info.hitsAdjacentAlly) {
                if (this.bm.currentPokemon - 1 >= 0) {
                    this.bm.targetted[0][this.bm.currentPokemon - 1] = true;
                }
                if (this.bm.currentPokemon + 1 < this.bm.targetted[0].length) {
                    this.bm.targetted[0][this.bm.currentPokemon + 1] = true;
                }
            }
            if (info.hitsExtendedAlly) {
                if (this.bm.currentPokemon - 2 >= 0) {
                    this.bm.targetted[0][this.bm.currentPokemon - 2] = true;
                }
                if (this.bm.currentPokemon + 2 < this.bm.targetted[0].length) {
                    this.bm.targetted[0][this.bm.currentPokemon + 2] = true;
                }
            }
        } else {
            if (userTarget != -1) {
                if (userTarget == this.bm.currentPokemon && info.hitsSelf) {
                    this.bm.targetted[0][this.bm.currentPokemon] = true;
                }
                if (info.hitsAdjacentAlly) {
                    if (userTarget == this.bm.currentPokemon + 1) {
                        this.bm.targetted[0][this.bm.currentPokemon + 1] = true;
                    }
                    if (userTarget == this.bm.currentPokemon - 1) {
                        this.bm.targetted[0][this.bm.currentPokemon - 1] = true;
                    }
                }
                if (info.hitsExtendedAlly) {
                    if (userTarget == this.bm.currentPokemon + 2) {
                        this.bm.targetted[0][this.bm.currentPokemon + 2] = true;
                    }
                    if (userTarget == this.bm.currentPokemon - 2) {
                        this.bm.targetted[0][this.bm.currentPokemon - 2] = true;
                    }
                }
            }
            if (opponentTarget != -1) {
                if (info.hitsOppositeFoe && opponentTarget == this.bm.currentPokemon) {
                    this.bm.targetted[1][this.bm.currentPokemon] = true;
                }
                if (info.hitsAdjacentFoe) {
                    if (opponentTarget == this.bm.currentPokemon + 1) {
                        this.bm.targetted[1][this.bm.currentPokemon + 1] = true;
                    }
                    if (opponentTarget == this.bm.currentPokemon - 1) {
                        this.bm.targetted[1][this.bm.currentPokemon - 1] = true;
                    }
                }
                if (info.hitsExtendedFoe) {
                    if (opponentTarget == this.bm.currentPokemon + 2) {
                        this.bm.targetted[1][this.bm.currentPokemon + 2] = true;
                    }
                    if (opponentTarget == this.bm.currentPokemon - 2) {
                        this.bm.targetted[1][this.bm.currentPokemon - 2] = true;
                    }
                }
            }
            if (userTarget == -1 && opponentTarget == -1) {
                boolean isCurseUser;
                boolean bl = isCurseUser = attack.isAttack("Curse") && !this.bm.getUserPokemonPacket().hasType(EnumType.Ghost);
                if (!info.hitsSelf && !isCurseUser) {
                    if (info.hitsOppositeFoe && this.bm.currentPokemon < this.bm.targetted[1].length) {
                        this.bm.targetted[1][this.bm.currentPokemon] = true;
                    }
                } else {
                    this.bm.targetted[0][this.bm.currentPokemon] = true;
                }
            }
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 0) {
            this.bm.endSpectate();
            this.bm.clearMessages();
            Pixelmon.network.sendToServer((IMessage)new RemoveSpectator(this.bm.battleControllerIndex, this.field_146297_k.field_71439_g.func_110124_au()));
        }
    }
}

