/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.battleScreens;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.TargetingInfo;
import com.pixelmonmod.pixelmon.client.SoundHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.client.gui.battles.GuiBattle;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.BattleScreen;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.PixelmonMovesetData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.ChooseAttack;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.battle.BattleMode;
import com.pixelmonmod.pixelmon.listener.EntityPlayerExtension;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.text.translation.I18n;

public class ChooseAttackScreen
extends BattleScreen {
    private static final int MEGA_BUTTON = 4;
    private static final int BUTTON_WIDTH = 87;
    private static final int BUTTON_HEIGHT = 20;
    private int megaAnimation;

    public ChooseAttackScreen(GuiBattle parent) {
        super(parent, BattleMode.ChooseAttack);
    }

    @Override
    public void drawScreen(int width, int height, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.battleGui2);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = this.parent.getGuiWidth();
        int guiHeight = this.parent.getGuiHeight();
        PixelmonData pokemon = this.bm.getUserPokemonPacket();
        GuiHelper.drawImageQuad(width / 2 - guiWidth / 2, height - guiHeight, guiWidth, guiHeight, 0.0, 0.0, 1.0, 0.30416667461395264, this.field_73735_i);
        if (pokemon != null) {
            int left;
            PixelmonMovesetData[] moveset = pokemon.moveset;
            int numMoves = pokemon.numMoves;
            if (moveset[0] == null || moveset[0].getAttack() == null || moveset[0].getAttack().baseAttack == null) {
                numMoves = 0;
            }
            if (numMoves > 0) {
                this.parent.drawButton(BattleMode.ChooseAttack, width / 2 - 141, height - guiHeight + 9, 87, 20, moveset[0].getAttack().baseAttack.getLocalizedName(), moveset[0].disabled, mouseX, mouseY, 0);
            }
            if (numMoves > 1) {
                this.field_146297_k.field_71446_o.func_110577_a(GuiResources.battleGui2);
                this.parent.drawButton(BattleMode.ChooseAttack, width / 2 - 50, height - guiHeight + 9, 87, 20, moveset[1].getAttack().baseAttack.getLocalizedName(), moveset[1].disabled, mouseX, mouseY, 1);
            }
            if (numMoves > 2) {
                this.field_146297_k.field_71446_o.func_110577_a(GuiResources.battleGui2);
                this.parent.drawButton(BattleMode.ChooseAttack, width / 2 - 141, height - guiHeight + 33, 87, 20, moveset[2].getAttack().baseAttack.getLocalizedName(), moveset[2].disabled, mouseX, mouseY, 2);
            }
            if (numMoves > 3) {
                this.field_146297_k.field_71446_o.func_110577_a(GuiResources.battleGui2);
                this.parent.drawButton(BattleMode.ChooseAttack, width / 2 - 50, height - guiHeight + 33, 87, 20, moveset[3].getAttack().baseAttack.getLocalizedName(), moveset[3].disabled, mouseX, mouseY, 3);
            }
            if (mouseX > width / 2 + 137 && mouseX < width / 2 + 148 && mouseY > height - 11 && mouseY < height - 1) {
                this.field_146297_k.field_71446_o.func_110577_a(GuiResources.battleGui2);
                GuiHelper.drawImageQuad(width / 2 + 137, height - 11, 11.0, 10.0f, 0.957812488079071, 0.31458333134651184, 0.9921875, 0.35625f, this.field_73735_i);
            }
            if (pokemon.canMegaEvolve() && EntityPlayerExtension.getPlayerMegaItem((EntityPlayer)Minecraft.func_71410_x().field_71439_g).canEvolve()) {
                this.field_146297_k.field_71446_o.func_110577_a(GuiResources.battleGui2);
                left = (width - 87) / 2;
                int top = height - guiHeight - 20;
                this.parent.drawButton(BattleMode.ChooseAttack, left, top, 87, 20, I18n.func_74838_a((String)"gui.mainmenu.megaevolution"), !this.bm.canMegaEvolve(), mouseX, mouseY, 4);
                if (this.bm.megaEvolving) {
                    int numColors = 10;
                    int posOffset = 87 / numColors;
                    int colorLeft = left;
                    int colorRight = left + posOffset;
                    int alpha = 100;
                    float colorOffset = (float)this.megaAnimation / 255.0f;
                    for (int i = 0; i < numColors; ++i) {
                        int alphaMask = alpha << 24 | 0xFFFFFF;
                        float startHue = (float)i / (float)numColors + colorOffset;
                        startHue -= (float)((int)startHue);
                        float endHue = (float)(i + 1) / (float)numColors + colorOffset;
                        endHue -= (float)((int)endHue);
                        int startColor = Color.HSBtoRGB(startHue, 1.0f, 1.0f) & alphaMask;
                        int endColor = Color.HSBtoRGB(endHue, 1.0f, 1.0f) & alphaMask;
                        if (i == numColors - 1) {
                            colorRight = left + 87;
                        }
                        GuiHelper.drawGradientRect(colorLeft, top, this.field_73735_i, colorRight, top + 20, startColor, endColor, true);
                        colorLeft += posOffset;
                        colorRight += posOffset;
                    }
                    this.megaAnimation += 2;
                    if (this.megaAnimation > 255) {
                        this.megaAnimation %= 255;
                    }
                }
            }
            if (this.parent.mouseOverButton < moveset.length && moveset[this.parent.mouseOverButton] != null) {
                this.func_73732_a(this.field_146297_k.field_71466_p, I18n.func_74838_a((String)"gui.battle.power") + ": " + moveset[this.parent.mouseOverButton].getAttack().movePower, width / 2 + 99, height - this.parent.getGuiHeight() + 7, 0xFFFFFF);
                this.func_73732_a(this.field_146297_k.field_71466_p, I18n.func_74838_a((String)"nbt.pp.name") + " " + moveset[this.parent.mouseOverButton].pp + "/" + moveset[this.parent.mouseOverButton].ppBase, width / 2 + 99, height - this.parent.getGuiHeight() + 18, 0xFFFFFF);
                left = I18n.func_74838_a((String)"gui.battle.type").contains(" ") ? this.field_146297_k.field_71466_p.func_78256_a(" ") : 0;
                this.func_73731_b(this.field_146297_k.field_71466_p, I18n.func_74838_a((String)"gui.battle.type"), width / 2 + 95 + left - this.field_146297_k.field_71466_p.func_78256_a(I18n.func_74838_a((String)"gui.battle.type") + moveset[this.parent.mouseOverButton].type.toString()) / 2, height - this.parent.getGuiHeight() + 29, 0xFFFFFF);
                this.field_146297_k.field_71466_p.func_78276_b(I18n.func_74838_a((String)("type." + moveset[this.parent.mouseOverButton].type.toString().toLowerCase())), width / 2 + 99 + left - this.field_146297_k.field_71466_p.func_78256_a(I18n.func_74838_a((String)"gui.battle.type") + I18n.func_74838_a((String)("type." + moveset[this.parent.mouseOverButton].type.toString().toLowerCase()))) / 2 - left + this.field_146297_k.field_71466_p.func_78256_a(I18n.func_74838_a((String)"gui.battle.type")), height - this.parent.getGuiHeight() + 30, moveset[this.parent.mouseOverButton].type.getColor());
                int categoryID = moveset[this.parent.mouseOverButton].getAttack().baseAttack.attackCategory;
                String category = categoryID == 0 ? "Physical" : (categoryID == 1 ? "Special" : "Status");
                this.func_73732_a(this.field_146297_k.field_71466_p, I18n.func_74838_a((String)"gui.battle.category") + ": " + I18n.func_74838_a((String)("attack.category." + category.toLowerCase())), width / 2 + 99, height - this.parent.getGuiHeight() + 40, 0xFFFFFF);
                this.parent.setTargetting(moveset[this.parent.mouseOverButton].getAttack(), -1, -1);
            }
        }
    }

    @Override
    public void click(int width, int height, int mouseX, int mouseY) {
        if (mouseX > width / 2 + 137 && mouseX < width / 2 + 148 && mouseY > height - 11 && mouseY < height - 1) {
            this.bm.mode = BattleMode.MainMenu;
        } else {
            int x1 = width / 2 - 141;
            int x2 = width / 2 - 50;
            int guiHeight = this.parent.getGuiHeight();
            int y1 = height - guiHeight + 9;
            int y2 = height - guiHeight + 33;
            int w = 87;
            int h = 20;
            PixelmonData poke = this.bm.getUserPokemonPacket();
            PixelmonMovesetData[] moveset = poke.moveset;
            int numMoves = poke.numMoves;
            if (mouseX > x1 && mouseX < x1 + w && mouseY > y1 && mouseY < y1 + h && numMoves > 0 && moveset[0].pp > 0 && !moveset[0].disabled) {
                if (this.canSelectTarget(moveset[0].getAttack())) {
                    this.bm.selectedAttack = 0;
                    this.bm.mode = BattleMode.ChooseTargets;
                } else {
                    this.bm.selectedActions.add(new ChooseAttack(this.bm.getUserPokemonPacket().pokemonID, ChooseAttackScreen.clone2D(this.bm.targetted), 0, this.bm.battleControllerIndex, this.bm.megaEvolving));
                    this.bm.selectedMove();
                }
            } else if (mouseX > x2 && mouseX < x2 + w && mouseY > y1 && mouseY < y1 + h && numMoves > 1 && moveset[1].pp > 0 && !moveset[1].disabled) {
                if (this.canSelectTarget(moveset[1].getAttack())) {
                    this.bm.selectedAttack = 1;
                    this.bm.mode = BattleMode.ChooseTargets;
                } else {
                    this.bm.selectedActions.add(new ChooseAttack(this.bm.getUserPokemonPacket().pokemonID, ChooseAttackScreen.clone2D(this.bm.targetted), 1, this.bm.battleControllerIndex, this.bm.megaEvolving));
                    this.bm.selectedMove();
                }
            } else if (mouseX > x1 && mouseX < x1 + w && mouseY > y2 && mouseY < y2 + h && numMoves > 2 && moveset[2].pp > 0 && !moveset[2].disabled) {
                if (this.canSelectTarget(moveset[2].getAttack())) {
                    this.bm.selectedAttack = 2;
                    this.bm.mode = BattleMode.ChooseTargets;
                } else {
                    this.bm.selectedActions.add(new ChooseAttack(this.bm.getUserPokemonPacket().pokemonID, ChooseAttackScreen.clone2D(this.bm.targetted), 2, this.bm.battleControllerIndex, this.bm.megaEvolving));
                    this.bm.selectedMove();
                }
            } else if (mouseX > x2 && mouseX < x2 + w && mouseY > y2 && mouseY < y2 + h && numMoves > 3 && moveset[3].pp > 0 && !moveset[3].disabled) {
                if (this.canSelectTarget(moveset[3].getAttack())) {
                    this.bm.selectedAttack = 3;
                    this.bm.mode = BattleMode.ChooseTargets;
                } else {
                    this.bm.selectedActions.add(new ChooseAttack(poke.pokemonID, ChooseAttackScreen.clone2D(this.bm.targetted), 3, this.bm.battleControllerIndex, this.bm.megaEvolving));
                    this.bm.selectedMove();
                }
            } else if (mouseX > (width - w) / 2 && mouseX < (width + w) / 2 && mouseY > height - guiHeight - 20 && mouseY < height - guiHeight && this.bm.canMegaEvolve() && EntityPlayerExtension.getPlayerMegaItem((EntityPlayer)Minecraft.func_71410_x().field_71439_g).canEvolve()) {
                boolean bl = this.bm.megaEvolving = !this.bm.megaEvolving;
                if (this.bm.megaEvolving) {
                    SoundHelper.playSound(SoundEvents.field_187616_bj);
                }
            }
        }
    }

    private boolean canSelectTarget(Attack attack) {
        TargetingInfo info = attack.baseAttack.targetingInfo;
        return info.hitsOppositeFoe && info.hitsAdjacentFoe && !info.hitsAdjacentAlly && !attack.isAttack("Me First") ? false : (info.hitsSelf && info.hitsAdjacentAlly && !info.hitsAll && this.bm.teamPokemon.length > 1 ? true : (!info.hitsSelf && !info.hitsAdjacentFoe && this.bm.teamPokemon.length == 1 ? false : (attack.isAttack("Curse") && !this.bm.getUserPokemonPacket().hasType(EnumType.Ghost) ? false : !info.hitsAll && !info.hitsSelf && (this.bm.teamPokemon.length > 1 || this.bm.displayedEnemyPokemon.length > 1))));
    }

    static boolean[][] clone2D(boolean[][] array) {
        boolean[][] clonedArray = new boolean[array.length][];
        for (int i = 0; i < array.length; ++i) {
            clonedArray[i] = (boolean[])array[i].clone();
        }
        return clonedArray;
    }
}

