/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.npcEditor;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.client.gui.elements.GuiContainerDropDown;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.TextureEditorNPC;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.DeleteNPC;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.NPCServerPacket;
import com.pixelmonmod.pixelmon.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrader;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity1Base;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity3HasStats;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;

public class GuiTradeEditor
extends GuiContainerDropDown {
    public int top;
    public int left;
    GuiTextField offerName;
    GuiTextField exchangeName;
    GuiTextField lvl;
    NPCTrader trader;
    String offer;
    String exchange;
    public int level;
    private TextureEditorNPC textureEditor;
    private GuiTextField formText;
    private int form = -1;

    public GuiTradeEditor(int traderId) {
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146999_f = 256;
        this.field_147000_g = 226;
        Optional<NPCTrader> entityNPCOptional = EntityNPC.locateNPCClient((World)Minecraft.func_71410_x().field_71441_e, traderId, NPCTrader.class);
        if (!entityNPCOptional.isPresent()) {
            GuiHelper.closeScreen();
        } else {
            this.trader = entityNPCOptional.get();
            if (this.trader != null) {
                this.offer = this.trader.getOffer();
                this.exchange = this.trader.getExchange();
            }
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.trader == null) {
            GuiHelper.closeScreen();
        } else {
            this.trader.updateTradePair();
            this.left = (this.field_146294_l - this.field_146999_f) / 2;
            this.top = (this.field_146295_m - this.field_147000_g) / 2;
            this.offerName = new GuiTextField(6, this.field_146297_k.field_71466_p, this.field_146294_l / 2 - 45, this.field_146295_m / 2 + 10, 90, 17);
            this.offerName.func_146180_a(Entity1Base.getLocalizedName(this.offer));
            this.exchangeName = new GuiTextField(7, this.field_146297_k.field_71466_p, this.field_146294_l / 2 + 100, this.field_146295_m / 2 + 10, 90, 17);
            this.exchangeName.func_146180_a(Entity1Base.getLocalizedName(this.exchange));
            this.lvl = new GuiTextField(8, this.field_146297_k.field_71466_p, this.field_146294_l / 2 + 15, this.field_146295_m / 2 + 28, 30, 17);
            this.lvl.func_146180_a(String.valueOf(this.trader.getLevel()));
            this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 155, this.field_146295_m / 2 + 90, 30, 20, I18n.func_74838_a((String)"gui.guiItemDrops.ok")));
            this.field_146292_n.add(new GuiButton(2, this.field_146294_l / 2 + 100, this.field_146295_m / 2 - 110, 80, 20, I18n.func_74838_a((String)"gui.tradereditor.delete")));
            this.field_146292_n.add(new GuiButton(3, this.field_146294_l / 2 - 46, this.field_146295_m / 2 + 28, 20, 20, I18n.func_74838_a((String)"gui.tradereditor.shiny")));
            this.field_146292_n.add(new GuiButton(4, this.field_146294_l / 2 - 40, this.field_146295_m / 2 - 110, 80, 20, I18n.func_74838_a((String)"gui.tradereditor.random")));
            this.field_146292_n.add(new GuiButton(5, this.field_146294_l / 2 + 58, this.field_146295_m / 2 + 9, 30, 20, "<->"));
            this.textureEditor = new TextureEditorNPC(this, this.trader, this.field_146294_l / 2 - 190, this.field_146295_m / 2 + 50, 130, -23);
            this.formText = new GuiTextField(9, this.field_146297_k.field_71466_p, this.field_146294_l / 2 + 25, this.field_146295_m / 2 + 46, 20, 17);
            this.formText.func_146180_a(Integer.toString(this.trader.getForm()));
            this.checkOfferForm();
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.cwPanel);
        GuiHelper.drawImageQuad(this.field_146294_l / 2 - 200, this.field_146295_m / 2 - 120, 400.0, 240.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        RenderHelper.func_74518_a();
        GuiHelper.drawEntity((EntityLivingBase)this.trader, this.field_146294_l / 2 - 125, this.field_146295_m / 2 + 40, 50.0f, 0.0f, 0.0f);
        if (this.trader.getIsShiny()) {
            this.offerName.func_146193_g(0xFFFF33);
        } else {
            this.offerName.func_146193_g(0xFFFFFF);
        }
        this.offerName.func_146194_f();
        this.exchangeName.func_146194_f();
        this.lvl.func_146194_f();
        String s = I18n.func_74838_a((String)"gui.tradereditor.offer");
        String s2 = I18n.func_74838_a((String)"gui.tradereditor.exchange");
        String s3 = I18n.func_74838_a((String)"gui.screenpokechecker.lvl");
        this.field_146297_k.field_71466_p.func_78276_b(s, this.left + 85, this.top + 110, 0);
        this.field_146297_k.field_71466_p.func_78276_b(s2, this.left + 225, this.top + 110, 0);
        this.field_146297_k.field_71466_p.func_78276_b(s3, this.left + 120, this.top + 145, 0);
        this.textureEditor.drawCustomTextBox();
        if (this.formText.func_146176_q()) {
            this.formText.func_146194_f();
            this.field_146297_k.field_71466_p.func_78276_b(I18n.func_74838_a((String)"gui.trainereditor.form"), this.left + 120, this.top + 165, 0);
        }
    }

    @Override
    protected void drawBackgroundUnderMenus(float var1, int var2, int var3) {
    }

    protected void func_73869_a(char key, int keyCode) {
        ArrayList<GuiTextField> textFields = new ArrayList<GuiTextField>(4);
        this.offerName.func_146201_a(key, keyCode);
        textFields.add(this.offerName);
        this.exchangeName.func_146201_a(key, keyCode);
        textFields.add(this.exchangeName);
        this.lvl.func_146201_a(key, keyCode);
        textFields.add(this.lvl);
        if (this.formText.func_146176_q()) {
            this.formText.func_146201_a(key, keyCode);
            textFields.add(this.formText);
        }
        this.textureEditor.keyTyped(key, keyCode, textFields.toArray(new GuiTextField[textFields.size()]));
        if (keyCode == 1 || keyCode == 28) {
            this.saveFields();
        }
        if (this.offerName.func_146206_l()) {
            this.checkOfferForm();
        }
    }

    @Override
    protected void mouseClickedUnderMenus(int x, int y, int mouseButton) throws IOException {
        this.offerName.func_146192_a(x, y, mouseButton);
        this.exchangeName.func_146192_a(x, y, mouseButton);
        this.lvl.func_146192_a(x, y, mouseButton);
        this.textureEditor.mouseClicked(x, y, mouseButton);
        this.formText.func_146192_a(x, y, mouseButton);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146124_l) {
            if (button.field_146127_k == 1) {
                this.saveFields();
            } else if (button.field_146127_k == 2) {
                GuiHelper.closeScreen();
                Minecraft.func_71410_x().func_175607_a((Entity)Minecraft.func_71410_x().field_71439_g);
                Pixelmon.network.sendToServer((IMessage)new DeleteNPC(this.trader.getId()));
            } else if (button.field_146127_k == 3) {
                if (!this.trader.getIsShiny()) {
                    this.trader.setIsShiny(true);
                } else {
                    this.trader.setIsShiny(false);
                }
            } else if (button.field_146127_k == 4) {
                EnumPokemon[] list = EnumPokemon.values();
                String poke2 = list[RandomHelper.getRandomNumberBetween((int)0, (int)(list.length - 1))].name;
                String poke1 = list[RandomHelper.getRandomNumberBetween((int)0, (int)(list.length - 1))].name;
                if (poke2.equalsIgnoreCase(poke1)) {
                    poke2 = list[RandomHelper.getRandomNumberBetween((int)0, (int)(list.length - 1))].name;
                }
                this.offerName.func_146180_a(Entity1Base.getLocalizedName(poke1));
                this.exchangeName.func_146180_a(Entity1Base.getLocalizedName(poke2));
                this.lvl.func_146180_a(String.valueOf(RandomHelper.getRandomNumberBetween(1, PixelmonServerConfig.maxLevel)));
                this.checkOfferForm();
            } else if (button.field_146127_k == 5) {
                String text = this.offerName.func_146179_b();
                this.offerName.func_146180_a(this.exchangeName.func_146179_b());
                this.exchangeName.func_146180_a(text);
                this.checkOfferForm();
            }
        }
    }

    private void saveFields() {
        try {
            this.level = Integer.parseInt(this.lvl.func_146179_b());
        }
        catch (NumberFormatException var3) {
            this.level = 10;
            return;
        }
        if (this.level >= 1 && this.level <= PixelmonServerConfig.maxLevel) {
            try {
                this.form = Short.parseShort(this.formText.func_146179_b());
            }
            catch (NumberFormatException var2) {
                this.form = 0;
            }
            if (EnumPokemon.hasPokemon(this.exchangeName.func_146179_b()) && EnumPokemon.hasPokemon(this.offerName.func_146179_b())) {
                this.setNewTradePokemon();
                GuiHelper.closeScreen();
                Minecraft.func_71410_x().func_175607_a((Entity)Minecraft.func_71410_x().field_71439_g);
            }
            this.textureEditor.saveCustomTexture();
        }
    }

    private void setNewTradePokemon() {
        if (EnumPokemon.hasPokemonAnyCase(this.exchangeName.func_146179_b()) && EnumPokemon.hasPokemonAnyCase(this.offerName.func_146179_b())) {
            EnumPokemon exchangeEnum = EnumPokemon.getFromNameAnyCase(this.exchangeName.func_146179_b());
            EnumPokemon offerEnum = EnumPokemon.getFromNameAnyCase(this.offerName.func_146179_b());
            if (exchangeEnum != null && offerEnum != null) {
                String exchangeText = exchangeEnum.name;
                String offerText = offerEnum.name;
                boolean shiny = this.trader.getIsShiny();
                this.trader.updateTrade(exchangeText, offerText, this.level, shiny, this.form);
                this.trader.updateTradePair();
                Pixelmon.network.sendToServer((IMessage)new NPCServerPacket(this.trader.getId(), exchangeText, offerText, this.level, shiny, this.form));
            }
        }
    }

    private void checkOfferForm() {
        if (Entity3HasStats.hasForms(this.offerName.func_146179_b())) {
            this.formText.func_146189_e(true);
            if (this.formText.func_146179_b().equals("-1")) {
                this.formText.func_146180_a("0");
            }
        } else {
            this.formText.func_146189_e(false);
            this.formText.func_146180_a("-1");
        }
    }
}

