/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.npcEditor;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.battles.rules.BattleRules;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.client.gui.elements.GuiContainerDropDown;
import com.pixelmonmod.pixelmon.client.gui.elements.GuiDropDown;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.GuiBattleRulesNPCEditor;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.GuiTrainerEditorMore;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.GuiTrainerEditorPartyScreen;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.TextureEditorNPC;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.SetTrainerData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.DeleteNPC;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.EnumNPCServerPacketType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.NPCServerPacket;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity1Base;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumEncounterMode;
import com.pixelmonmod.pixelmon.enums.EnumTrainerAI;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleAIMode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;

public class GuiTrainerEditor
extends GuiContainerDropDown {
    public static ArrayList<PixelmonData> pokemonList = new ArrayList();
    public static int currentTrainerID;
    public static SetTrainerData trainerData;
    NPCTrainer trainer;
    GuiTextField nameBox;
    private TextureEditorNPC textureEditor;
    String oldName = "";
    private static final int BUTTON_ID_RULES = 11;
    private static final int DROP_DOWN_HEIGHT_OFFSET = 25;
    BaseTrainer model;

    public GuiTrainerEditor(int trainerId) {
        Keyboard.enableRepeatEvents((boolean)true);
        Optional<NPCTrainer> entityNPCOptional = EntityNPC.locateNPCClient((World)Minecraft.func_71410_x().field_71441_e, trainerId, NPCTrainer.class);
        if (!entityNPCOptional.isPresent()) {
            GuiHelper.closeScreen();
            return;
        }
        this.trainer = entityNPCOptional.get();
        currentTrainerID = trainerId;
        if (trainerData == null) {
            trainerData = new SetTrainerData("", "", "", "", 0, new ItemStack[0], new BattleRules());
        }
        this.trainer.update(trainerData);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.trainer == null) {
            GuiHelper.closeScreen();
            return;
        }
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 155, this.field_146295_m / 2 + 90, 30, 20, I18n.func_74838_a((String)"gui.guiItemDrops.ok")));
        this.textureEditor = new TextureEditorNPC(this, this.trainer, this.field_146294_l / 2 - 20, this.field_146295_m / 2 - 84, 180);
        this.field_146292_n.add(new GuiButton(3, this.field_146294_l / 2 - 80, this.field_146295_m / 2 + 90, 100, 20, I18n.func_74838_a((String)"gui.trainereditor.edit")));
        int dropDownLeft = this.field_146294_l / 2 + 40;
        int dropDownHeightStart = this.field_146295_m / 2 + 20;
        int dropDownWidth = 100;
        int dropDownHeight = 100;
        this.addDropDown(new GuiDropDown<EnumBossMode>(Arrays.asList(EnumBossMode.values()), this.trainer.getBossMode(), dropDownLeft, dropDownHeightStart, dropDownWidth, dropDownHeight).setGetOptionString(bossMode -> bossMode.getLocalizedName()).setOnSelected(this::selectBossMode));
        this.addDropDown(new GuiDropDown<EnumTrainerAI>(Arrays.asList(EnumTrainerAI.values()), this.trainer.getAIMode(), dropDownLeft, dropDownHeightStart + 25, dropDownWidth, dropDownHeight).setGetOptionString(aiMode -> aiMode.getLocalizedName()).setOnSelected(aiMode -> this.trainer.setAIMode((EnumTrainerAI)((Object)aiMode))));
        int battleAITop = dropDownHeightStart + 50;
        this.addDropDown(new GuiDropDown<EnumBattleAIMode>(Arrays.asList(EnumBattleAIMode.values()), this.trainer.getBattleAIMode(), dropDownLeft, battleAITop - 10, dropDownWidth, dropDownHeight).setGetOptionString(battleAI -> battleAI.getLocalizedName()).setOnSelected(this::selectBattleAIMode).setInactiveTop(battleAITop));
        int encounterModeTop = dropDownHeightStart + 75;
        this.addDropDown(new GuiDropDown<EnumEncounterMode>(Arrays.asList(EnumEncounterMode.values()), this.trainer.getEncounterMode(), dropDownLeft, encounterModeTop - 35, dropDownWidth, dropDownHeight).setGetOptionString(encounterMode -> encounterMode.getLocalizedName()).setOnSelected(this::selectEncounterMode).setInactiveTop(encounterModeTop));
        this.field_146292_n.add(new GuiButton(11, this.field_146294_l / 2 + 40, this.field_146295_m / 2 - 18, 100, 20, I18n.func_74838_a((String)"gui.battlerules.title")));
        this.field_146292_n.add(new GuiButton(7, this.field_146294_l / 2 - 190, this.field_146295_m / 2 + 90, 100, 20, I18n.func_74838_a((String)"gui.trainereditor.more")));
        this.field_146292_n.add(new GuiButton(8, this.field_146294_l / 2 - 180, this.field_146295_m / 2 - 120, 80, 20, I18n.func_74838_a((String)"gui.trainereditor.delete")));
        this.nameBox = new GuiTextField(12, this.field_146297_k.field_71466_p, this.field_146294_l / 2 - 20, this.field_146295_m / 2 - 116, 180, 20);
        if (trainerData != null) {
            this.nameBox.func_146180_a(GuiTrainerEditor.trainerData.name);
            this.oldName = GuiTrainerEditor.trainerData.name;
        }
    }

    private void selectBossMode(EnumBossMode bossMode) {
        this.trainer.setBossMode(bossMode);
        Pixelmon.network.sendToServer((IMessage)new NPCServerPacket(currentTrainerID, bossMode));
    }

    private void selectBattleAIMode(EnumBattleAIMode battleAI) {
        this.trainer.setBattleAIMode(battleAI);
        Pixelmon.network.sendToServer((IMessage)new NPCServerPacket(currentTrainerID, battleAI));
    }

    private void selectEncounterMode(EnumEncounterMode encounterMode) {
        this.trainer.setEncounterMode(encounterMode);
        Pixelmon.network.sendToServer((IMessage)new NPCServerPacket(currentTrainerID, encounterMode));
    }

    @Override
    protected void drawBackgroundUnderMenus(float f, int i, int j) {
        if (this.trainer == null) {
            GuiHelper.closeScreen();
            return;
        }
        if (trainerData != null && !GuiTrainerEditor.trainerData.name.equals(this.oldName)) {
            this.oldName = GuiTrainerEditor.trainerData.name;
            this.nameBox.func_146180_a(GuiTrainerEditor.trainerData.name);
        }
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.cwPanel);
        GuiHelper.drawImageQuad(this.field_146294_l / 2 - 200, this.field_146295_m / 2 - 120, 400.0, 240.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        RenderHelper.func_74518_a();
        GuiHelper.drawEntity((EntityLivingBase)this.trainer, this.field_146294_l / 2 - 140, this.field_146295_m / 2 + 60, 60.0f, 0.0f, 0.0f);
        int dropDownLabelX = this.field_146294_l / 2 + 90;
        int dropDownHeightStart = this.field_146295_m / 2 + 10;
        GuiHelper.drawCenteredString(I18n.func_74838_a((String)"gui.trainereditor.bosstype"), dropDownLabelX, dropDownHeightStart, 0);
        GuiHelper.drawCenteredString(I18n.func_74838_a((String)"gui.trainereditor.aimode"), dropDownLabelX, dropDownHeightStart + 25, 0);
        GuiHelper.drawCenteredString(I18n.func_74838_a((String)"gui.trainereditor.battleaimode"), dropDownLabelX, dropDownHeightStart + 50, 0);
        GuiHelper.drawCenteredString(I18n.func_74838_a((String)"gui.trainereditor.encountermode"), dropDownLabelX, dropDownHeightStart + 75, 0);
        this.field_146297_k.field_71466_p.func_78276_b(I18n.func_74838_a((String)"gui.trainereditor.name"), this.field_146294_l / 2 - 60, this.field_146295_m / 2 - 110, 0);
        this.field_146297_k.field_71466_p.func_78276_b(I18n.func_74838_a((String)"gui.trainereditor.model"), this.field_146294_l / 2 - 60, this.field_146295_m / 2 - 83, 0);
        this.nameBox.func_146194_f();
        this.textureEditor.drawCustomTextBox();
        this.drawPokemonList();
    }

    private void drawPokemonList() {
        int top = this.field_146295_m / 2 + 20;
        int ySize = 68;
        int left = this.field_146294_l / 2 - 82;
        int xSize = 104;
        GuiTrainerEditor.func_73734_a((int)(left - 1), (int)(top - 1), (int)(left + xSize), (int)(top + ySize), (int)-16777215);
        GuiTrainerEditor.func_73734_a((int)left, (int)top, (int)(left + xSize), (int)(top + ySize), (int)-6777215);
        this.field_146297_k.field_71466_p.func_78276_b(I18n.func_74838_a((String)"gui.trainereditor.partypokemon"), left + 1, top - 11, 0);
        for (int n = 0; n < pokemonList.size(); ++n) {
            PixelmonData p = pokemonList.get(n);
            if (p == null) continue;
            this.field_146297_k.field_71466_p.func_78276_b(Entity1Base.getLocalizedName(p.name), left + 4, top + 4 + n * 10, 0);
            this.field_146297_k.field_71466_p.func_78276_b(I18n.func_74838_a((String)"gui.trainereditor.lvl") + " " + p.lvl, left + 65, top + 4 + n * 10, 0);
        }
    }

    protected void func_73869_a(char key, int keyCode) {
        this.nameBox.func_146201_a(key, keyCode);
        this.textureEditor.keyTyped(key, keyCode, this.nameBox);
        if (keyCode == 1 || keyCode == 28) {
            this.saveFields();
        }
    }

    @Override
    protected void mouseClickedUnderMenus(int x, int y, int mouseButton) throws IOException {
        if (this.nameBox == null) {
            this.func_73866_w_();
        }
        this.nameBox.func_146192_a(x, y, mouseButton);
        this.textureEditor.mouseClicked(x, y, mouseButton);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146124_l) {
            if (button.field_146127_k == 1) {
                this.saveFields();
            } else if (button.field_146127_k == 3) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiTrainerEditorPartyScreen());
            } else if (button.field_146127_k == 7) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiTrainerEditorMore());
            } else if (button.field_146127_k == 8) {
                Pixelmon.network.sendToServer((IMessage)new DeleteNPC(currentTrainerID));
                GuiHelper.closeScreen();
            } else if (button.field_146127_k == 11) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiBattleRulesNPCEditor());
            }
        }
    }

    private void saveFields() {
        if (this.checkFields()) {
            GuiHelper.closeScreen();
        }
    }

    private boolean checkFields() {
        if (this.nameBox.func_146179_b().equals("") || trainerData == null) {
            return false;
        }
        if (currentTrainerID <= 0) {
            currentTrainerID = this.trainer.getId();
        }
        if (!this.nameBox.func_146179_b().equals(GuiTrainerEditor.trainerData.name)) {
            Pixelmon.network.sendToServer((IMessage)new NPCServerPacket(currentTrainerID, EnumNPCServerPacketType.Name, this.nameBox.func_146179_b()));
        }
        Pixelmon.network.sendToServer((IMessage)new NPCServerPacket(currentTrainerID, this.trainer.getAIMode()));
        this.textureEditor.saveCustomTexture();
        return true;
    }
}

