/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pc;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiPixelmonOverlay;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.client.gui.elements.GuiButtonHoverDisable;
import com.pixelmonmod.pixelmon.client.gui.pc.GuiReleaseWarning;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.GuiPokeCheckerTabs;
import com.pixelmonmod.pixelmon.client.gui.ranchblock.GuiPCRanch;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.enums.EnumGui;
import com.pixelmonmod.pixelmon.gui.ContainerEmpty;
import com.pixelmonmod.pixelmon.storage.PCClient;
import com.pixelmonmod.pixelmon.storage.PCClientStorage;
import com.pixelmonmod.pixelmon.storage.PCPos;
import com.pixelmonmod.pixelmon.storage.PlayerComputerStorage;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class GuiPC
extends GuiContainer {
    protected int boxNumber;
    protected int trashX;
    protected int trashY;
    protected int pcLeft;
    protected int pcRight;
    protected int pcTop;
    protected int pcBottom;
    protected int partyLeft;
    protected int partyRight;
    protected int partyTop;
    protected int partyBottom;
    protected int slotWidth = 30;
    protected int slotHeight = 28;
    protected int pcNumWidth = 6;
    protected int partyNumWidth = 6;
    protected int pcNumHeight = 5;
    protected PCClient pcClient = new PCClient();
    GuiButton pMenuButtonSumm;
    GuiButton pMenuButtonMove;
    GuiButton pMenuButtonStat;
    Rectangle buttonBounds;
    Rectangle buttonBoundsMoves;
    Rectangle buttonBoundsStat;
    protected boolean pixelmonMenuOpen = false;
    public static PixelmonData selected = null;
    protected int menuX;
    protected int menuY;
    private int menuLeft;
    private int menuTop;
    private static final int MENU_WIDTH = 67;
    private static final int MENU_HEIGHT = 73;
    public PixelmonData mouseHeldPokemon = null;
    protected boolean goingToPokeChecker = false;
    private GuiTextField searchText;
    private GuiTextField pcBox;

    public GuiPC() {
        super((Container)new ContainerEmpty());
        this.boxNumber = PCClientStorage.getLastBoxOpen();
        this.pcClient.unselectAll();
    }

    public GuiPC(PixelmonData targetPacket, int box) {
        this();
        this.mouseHeldPokemon = targetPacket;
        this.boxNumber = box;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButtonHoverDisable(0, this.field_146294_l / 2 - 131, this.field_146295_m / 6 + 60, 20, 20, "<-"));
        this.field_146292_n.add(new GuiButtonHoverDisable(1, this.field_146294_l / 2 - 91 + 205, this.field_146295_m / 6 + 60, 20, 20, "->"));
        this.trashX = this.field_146294_l / 2 - 91 + 202;
        this.trashY = this.field_146295_m / 6 + 110;
        this.pcLeft = this.field_146294_l / 2 - 90;
        this.pcRight = this.pcLeft + this.pcNumWidth * this.slotWidth;
        this.pcTop = this.field_146295_m / 6 - 5;
        this.pcBottom = this.pcTop + this.pcNumHeight * this.slotHeight;
        this.partyLeft = this.field_146294_l / 2 - 90;
        this.partyRight = this.partyLeft + this.partyNumWidth * this.slotWidth;
        this.partyTop = this.field_146295_m / 6 + 147;
        this.partyBottom = this.partyTop + this.slotHeight;
        this.searchText = new GuiTextField(2, this.field_146289_q, this.field_146294_l / 2 - 91, this.partyBottom + 10, this.partyRight - this.partyLeft, 20);
        this.searchText.func_146203_f(32500);
        this.searchText.func_146195_b(true);
        this.pcBox = new GuiTextField(3, this.field_146289_q, this.field_146294_l / 2 - 91 + 205, this.field_146295_m / 6 - 30, 20, 20);
        this.pcBox.func_146203_f(2);
        this.pcBox.func_146180_a(String.valueOf(this.boxNumber + 1));
    }

    public PixelmonData getSlotAt(int x, int y) {
        PixelmonData pkt = null;
        pkt = this.getPCAt(x, y);
        return pkt != null ? pkt : this.getPartyAt(x, y);
    }

    public PCPos getPosAt(int x, int y) {
        PCPos pos = null;
        pos = this.getPCPosAt(x, y);
        return pos != null ? pos : this.getPartyPosAt(x, y);
    }

    protected PCPos getPartyPosAt(int x, int y) {
        if (x >= this.partyLeft && x < this.partyRight && y >= this.partyTop + 3 && y <= this.partyBottom + 3) {
            double xInd = ((double)x - (double)this.partyLeft) / (double)this.slotWidth;
            return new PCPos(-1, Math.min((int)Math.floor(xInd), 5));
        }
        return null;
    }

    protected PCPos getPCPosAt(int x, int y) {
        if (x >= this.pcLeft && x < this.pcRight && y >= this.pcTop + 5 && y <= this.pcBottom + 5) {
            double xInd = ((double)x - (double)this.pcLeft) / (double)this.slotWidth;
            double yInd = ((double)y - ((double)this.pcTop + 5.0)) / (double)this.slotHeight;
            int ind = (int)Math.floor(yInd) * 6 + (int)Math.floor(xInd);
            return new PCPos(this.boxNumber, ind > 29 ? 29 : ind);
        }
        return null;
    }

    protected PixelmonData getPartyAt(int x, int y) {
        if (x >= this.partyLeft && x < this.partyRight && y >= this.partyTop + 3 && y <= this.partyBottom + 3) {
            double xInd = ((double)x - (double)this.partyLeft) / (double)this.slotWidth;
            return this.getPartyAt(xInd);
        }
        return null;
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.searchText.func_146206_l()) {
            if (this.searchText.func_146179_b().isEmpty()) {
                this.boxNumber = 0;
                this.pcBox.func_146180_a("1");
            }
            this.searchText.func_146201_a(typedChar, keyCode);
            if (keyCode == 1) {
                super.func_73869_a(typedChar, keyCode);
            }
            return;
        }
        if (this.pcBox.func_146206_l()) {
            this.pcBox.func_146201_a(typedChar, keyCode);
            try {
                int box = Integer.parseInt(this.pcBox.func_146179_b());
                if (box > 0 && box <= PlayerComputerStorage.boxCount) {
                    this.boxNumber = box - 1;
                    this.pcBox.func_146180_a(String.valueOf(this.boxNumber + 1));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.func_73869_a(typedChar, keyCode);
    }

    protected PixelmonData getPartyAt(double index) {
        return this.pcClient.getPokemonAtPos(-1, (int)Math.floor(index));
    }

    protected PixelmonData getPCAt(int x, int y) {
        if (x >= this.pcLeft && x < this.pcRight && y >= this.pcTop + 5 && y <= this.pcBottom + 5) {
            double xInd = ((double)x - (double)this.pcLeft) / (double)this.slotWidth;
            double yInd = ((double)y - ((double)this.pcTop + 5.0)) / (double)this.slotHeight;
            int ind = (int)Math.floor(yInd) * 6 + (int)Math.floor(xInd);
            return ind > 29 ? null : this.pcClient.getPokemonAtPos(this.boxNumber, ind);
        }
        return null;
    }

    public boolean checkIfLast() {
        return this.pcClient.hasOneInParty();
    }

    public int numSelected() {
        return this.pcClient.numSelected();
    }

    private boolean isMouseInMenu(int x, int y) {
        return this.pixelmonMenuOpen && x >= this.menuLeft && x <= this.menuLeft + 67 && y >= this.menuTop && y <= this.menuTop + 73;
    }

    protected void func_73864_a(int x, int y, int par3) throws IOException {
        boolean clickInMenu = this.isMouseInMenu(x, y);
        if (!clickInMenu) {
            super.func_73864_a(x, y, par3);
        }
        this.searchText.func_146192_a(x, y, par3);
        this.pcBox.func_146192_a(x, y, par3);
        if (!(this instanceof GuiPCRanch)) {
            if (par3 == 0 && this.pixelmonMenuOpen) {
                EnumGui pokeCheckerGUI = null;
                if (this.buttonBounds.contains(x, y)) {
                    pokeCheckerGUI = EnumGui.PokeChecker;
                } else if (this.buttonBoundsMoves.contains(x, y)) {
                    pokeCheckerGUI = EnumGui.PokeCheckerMoves;
                } else if (this.buttonBoundsStat.contains(x, y)) {
                    pokeCheckerGUI = EnumGui.PokeCheckerStats;
                }
                if (pokeCheckerGUI != null) {
                    this.field_146297_k.field_71439_g.openGui((Object)Pixelmon.instance, pokeCheckerGUI.getIndex().intValue(), (World)this.field_146297_k.field_71441_e, -1, this.boxNumber, 0);
                    return;
                }
                if (!clickInMenu) {
                    this.closePokeCheckerMenu();
                }
            }
            if (!clickInMenu) {
                PixelmonData p = this.getSlotAt(x, y);
                if (!this.searchText.func_146179_b().isEmpty()) {
                    List<PixelmonData> matches = this.searchPokemon(this.searchText.func_146179_b());
                    double xInd = ((double)x - (double)this.pcLeft) / (double)this.slotWidth;
                    double yInd = ((double)y - ((double)this.pcTop + 5.0)) / (double)this.slotHeight;
                    int ind = this.boxNumber * PlayerComputerStorage.boxCount + (int)Math.floor(yInd) * 6 + (int)Math.floor(xInd);
                    p = ind < matches.size() && ind >= 0 && yInd < 5.0 && xInd < 6.0 ? matches.get(ind) : null;
                }
                if (p != null && par3 == 1) {
                    if (this.pixelmonMenuOpen) {
                        this.closePokeCheckerMenu();
                    }
                    this.menuX = x;
                    this.menuY = y;
                    if (y >= this.partyTop && y <= this.partyBottom) {
                        this.menuY -= 50;
                    }
                    this.pMenuButtonSumm = new GuiPokeCheckerTabs(6, 3, x - 63, this.menuY + 5, 47, 13, I18n.func_74838_a((String)"gui.screenpokechecker.summary"));
                    this.pMenuButtonMove = new GuiPokeCheckerTabs(6, 4, x - 63, this.menuY + 24, 47, 13, I18n.func_74838_a((String)"gui.screenpokechecker.moves"));
                    this.pMenuButtonStat = new GuiPokeCheckerTabs(6, 5, x - 63, this.menuY + 43, 47, 13, I18n.func_74838_a((String)"gui.screenpokechecker.stats"));
                    this.buttonBounds = new Rectangle(x - 63, this.menuY + 5, 47, 13);
                    this.buttonBoundsMoves = new Rectangle(x - 63, this.menuY + 24, 47, 13);
                    this.buttonBoundsStat = new Rectangle(x - 63, this.menuY + 43, 47, 13);
                    this.pixelmonMenuOpen = true;
                    selected = p;
                } else {
                    if (par3 == 0 && this.getPosAt(x, y) != null) {
                        if (p != null && p.selected) {
                            p.selected = !p.selected;
                        } else if (p != null && this.numSelected() < 1 && !p.isInRanch) {
                            p.selected = true;
                        } else if (p != null && !p.isInRanch) {
                            this.pcClient.swapPokemonWithSelected(p);
                        } else if (p == null && this.pcClient.getSelected() != null && (ServerStorageDisplay.count() > 1 || this.pcClient.getPos((PixelmonData)this.pcClient.getSelected()).box >= 0)) {
                            this.pcClient.swapPositionWithSelected(this.getPosAt(x, y));
                        }
                    }
                    if (new Rectangle(this.trashX, this.trashY, 32, 32).contains(x, y)) {
                        PixelmonData selected = this.pcClient.getSelected();
                        if (this.numSelected() == 1 && (selected != null && selected.isEgg || ServerStorageDisplay.countNonEgg() > 1 || this.pcClient.getPos((PixelmonData)selected).box >= 0)) {
                            this.field_146297_k.func_147108_a((GuiScreen)new GuiReleaseWarning(this));
                        }
                    }
                }
            }
        }
    }

    private List<PixelmonData> searchPokemon(String text) {
        ArrayList<PixelmonData> matches = new ArrayList<PixelmonData>();
        for (int box = 0; box < PlayerComputerStorage.boxCount; ++box) {
            for (int pos = 0; pos < 30; ++pos) {
                PixelmonData pokemon = this.pcClient.getPokemonAtPos(box, pos);
                if (pokemon == null || !pokemon.getSpecies().name.toLowerCase().contains(text.toLowerCase()) && !pokemon.getNickname().toLowerCase().contains(text.toLowerCase())) continue;
                matches.add(pokemon);
            }
        }
        return matches;
    }

    void releasePokemon() {
        this.pcClient.deletePokemon();
    }

    private void closePokeCheckerMenu() {
        this.pMenuButtonSumm = null;
        this.pMenuButtonMove = null;
        this.pMenuButtonStat = null;
        this.pixelmonMenuOpen = false;
        selected = null;
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (!this.goingToPokeChecker) {
            GuiPixelmonOverlay.checkSelection();
        }
    }

    public void func_146284_a(GuiButton button) {
        int b = button.field_146127_k;
        if (b == 0) {
            this.boxNumber = this.boxNumber == 0 ? PlayerComputerStorage.boxCount - 1 : --this.boxNumber;
            this.pcBox.func_146180_a(String.valueOf(this.boxNumber + 1));
        } else if (b == 1) {
            this.boxNumber = this.boxNumber == PlayerComputerStorage.boxCount - 1 ? 0 : ++this.boxNumber;
            this.pcBox.func_146180_a(String.valueOf(this.boxNumber + 1));
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GuiButtonHoverDisable.setHoverDisabledScreen(this.field_146292_n, this.isMouseInMenu(mouseX, mouseY));
        this.searchText.func_146194_f();
        this.pcBox.func_146194_f();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.drawPC(partialTicks, mouseX, mouseY);
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.pcBox);
        this.func_73729_b(this.trashX, this.trashY, 0, 224, 32, 32);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(-this.field_147003_i), (float)(-this.field_147009_r), (float)0.0f);
        PixelmonData slot = this.getSlotAt(mouseX, mouseY);
        if (!this.searchText.func_146179_b().isEmpty()) {
            List<PixelmonData> list;
            double xInd = ((double)mouseX - (double)this.pcLeft) / (double)this.slotWidth;
            double yInd = ((double)mouseY - ((double)this.pcTop + 5.0)) / (double)this.slotHeight;
            int ind = this.boxNumber * PlayerComputerStorage.boxCount + (int)Math.floor(yInd) * 6 + (int)Math.floor(xInd);
            slot = ind >= (list = this.searchPokemon(this.searchText.func_146179_b())).size() || ind < 0 ? null : list.get(ind);
        }
        GuiHelper.drawPokemonInfoPC(mouseX, mouseY, slot, this.field_73735_i);
        if (this.pixelmonMenuOpen) {
            this.drawButtonContainer();
        }
        for (GuiButton button : new GuiButton[]{this.pMenuButtonMove, this.pMenuButtonStat, this.pMenuButtonSumm}) {
            if (button == null) continue;
            button.func_191745_a(this.field_146297_k, mouseX, mouseY, 0.0f);
        }
        GlStateManager.func_179121_F();
    }

    protected void drawPC(float partialTicks, int mouseX, int mouseY) {
        int x;
        RenderHelper.func_74518_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.pcPartyBox);
        this.func_73729_b(this.field_146294_l / 2 - 91, this.field_146295_m / 6 + 151, 0, 0, 182, 29);
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.pcBox);
        this.func_73729_b(this.field_146294_l / 2 - 91, this.field_146295_m / 6, 0, 0, 182, 141);
        if (this.searchText.func_146179_b().isEmpty()) {
            for (x = 0; x < this.pcNumWidth; ++x) {
                for (int y = 0; y < this.pcNumHeight; ++y) {
                    PixelmonData pkt = this.pcClient.getPokemonAtPos(this.boxNumber, y * this.pcNumWidth + x);
                    if (pkt == null) continue;
                    GuiHelper.bindPokemonSprite(pkt, this.field_146297_k);
                    int xPos = this.pcLeft + x * this.slotWidth;
                    int yPos = this.pcTop + y * this.slotHeight;
                    GuiHelper.drawImageQuad(xPos + 2, yPos + 3 - (pkt.isGen6Sprite() ? -3 : 0), 26.0, 26.0f, 0.0, 0.0, 1.0, 1.0, 0.0f);
                    if (!pkt.heldItem.func_190926_b()) {
                        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.heldItem);
                        GuiHelper.drawImageQuad(xPos + 22, yPos + 22, 8.0, 8.0f, 0.0, 0.0, 1.0, 1.0, 0.0f);
                    }
                    if (pkt.selected) {
                        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.pcBox);
                        GuiHelper.drawImageQuad(xPos, yPos + 4, this.slotWidth, this.slotHeight + 1, 0.0, 0.55859375, 0.12109375, 0.68359375, 0.0f);
                    }
                    if (!pkt.isInRanch) continue;
                    this.field_146297_k.field_71446_o.func_110577_a(GuiResources.padlock);
                    GuiHelper.drawImageQuad(xPos + 2, yPos + 22, 8.0, 8.0f, 0.0, 0.0, 1.0, 1.0, 0.0f);
                }
            }
        } else {
            List<PixelmonData> matches = this.searchPokemon(this.searchText.func_146179_b());
            int x2 = 0;
            int y = 0;
            for (int index = 0; index < matches.size(); ++index) {
                PixelmonData pokemon;
                int pokemonIndex = this.boxNumber * PlayerComputerStorage.boxCount + index;
                if (pokemonIndex >= matches.size() || (pokemon = matches.get(pokemonIndex)) == null) continue;
                GuiHelper.bindPokemonSprite(pokemon, this.field_146297_k);
                int xPos = this.pcLeft + x2 * this.slotWidth;
                int yPos = this.pcTop + y * this.slotHeight;
                GuiHelper.drawImageQuad(xPos + 2, yPos + 3 - (pokemon.isGen6Sprite() ? -3 : 0), 26.0, 26.0f, 0.0, 0.0, 1.0, 1.0, 0.0f);
                if (!pokemon.heldItem.func_190926_b()) {
                    this.field_146297_k.field_71446_o.func_110577_a(GuiResources.heldItem);
                    GuiHelper.drawImageQuad(xPos + 22, yPos + 22, 8.0, 8.0f, 0.0, 0.0, 1.0, 1.0, 0.0f);
                }
                if (pokemon.selected) {
                    this.field_146297_k.field_71446_o.func_110577_a(GuiResources.pcBox);
                    GuiHelper.drawImageQuad(xPos, yPos + 4, this.slotWidth, this.slotHeight + 1, 0.0, 0.55859375, 0.12109375, 0.68359375, 0.0f);
                }
                if (pokemon.isInRanch) {
                    this.field_146297_k.field_71446_o.func_110577_a(GuiResources.padlock);
                    GuiHelper.drawImageQuad(xPos + 2, yPos + 22, 8.0, 8.0f, 0.0, 0.0, 1.0, 1.0, 0.0f);
                }
                if (++x2 != 6) continue;
                if (++y != 5) {
                    x2 = 0;
                    continue;
                }
                break;
            }
        }
        for (x = 0; x < this.getPartySize(); ++x) {
            PixelmonData pkt = this.getPartyPokemon(x);
            if (pkt == null) continue;
            int xPos = this.partyLeft + x * this.slotWidth;
            int yPos = this.partyTop;
            GuiHelper.bindPokemonSprite(pkt, this.field_146297_k);
            GuiHelper.drawImageQuad(xPos + 2, yPos + 3 - (pkt.getNationalPokedexNumber() <= 649 ? 0 : -3), 26.0, 26.0f, 0.0, 0.0, 1.0, 1.0, 0.0f);
            if (!pkt.heldItem.func_190926_b()) {
                this.field_146297_k.field_71446_o.func_110577_a(GuiResources.heldItem);
                GuiHelper.drawImageQuad(xPos + 18, yPos + 22, 8.0, 8.0f, 0.0, 0.0, 1.0, 1.0, 0.0f);
            }
            if (!pkt.selected) continue;
            this.field_146297_k.field_71446_o.func_110577_a(GuiResources.pcBox);
            GuiHelper.drawImageQuad(xPos, yPos + 3, this.slotWidth, this.slotHeight + 1, 0.0, 0.55859375, 0.12109375, 0.68359375, 0.0f);
        }
        this.field_146297_k.field_71466_p.func_78276_b(I18n.func_74838_a((String)"gui.pc.box") + (this.boxNumber + 1), this.field_146294_l / 2 - 18, this.field_146295_m / 6 - 20, 0xFFFFFF);
    }

    protected int getPartySize() {
        return this.partyNumWidth;
    }

    protected PixelmonData getPartyPokemon(int pos) {
        return this.pcClient.getPokemonAtPos(-1, pos);
    }

    public void drawButtonContainer() {
        if (this.pixelmonMenuOpen) {
            this.field_146297_k.field_71446_o.func_110577_a(GuiResources.pokecheckerPopup);
            this.menuLeft = this.menuX - 73;
            this.menuTop = this.menuY - 10;
            GuiHelper.drawImageQuad(this.menuLeft, this.menuTop, 67.0, 73.0f, 0.0, 0.0, 0.26171875, 0.29f, -1.0f);
        }
    }
}

