/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pokemoneditor;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.client.gui.elements.GuiButtonHoverDisable;
import com.pixelmonmod.pixelmon.client.gui.elements.GuiContainerDropDown;
import com.pixelmonmod.pixelmon.client.gui.elements.GuiDropDown;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.EnumTextureType;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.GuiImportExport;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.GuiPokemonEditorAdvanced;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.IImportableContainer;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.ImportExportConverter;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.PixelmonMovesetData;
import com.pixelmonmod.pixelmon.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity1Base;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity3HasStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.EnumSpecialTexture;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.text.translation.I18n;

public abstract class GuiIndividualEditorBase
extends GuiContainerDropDown
implements IImportableContainer {
    public PixelmonData p;
    public String titleText;
    private GuiTextField tbName;
    private GuiTextField tbNickname;
    private GuiTextField tbLvl;
    private GuiTextField[] tbMoves = new GuiTextField[4];
    private String origName;
    private Attack[] attacks = new Attack[4];
    protected GuiTextField formText = null;
    private static final int BUTTON_OKAY = 1;
    private static final int BUTTON_GENDER = 3;
    private static final int BUTTON_CHANGE = 4;
    private static final int BUTTON_ADVANCED = 6;
    private static final int BUTTON_DELETE = 14;
    private static final int BUTTON_IMPORT_EXPORT = 15;
    protected List<GuiTextField> textFields = new ArrayList<GuiTextField>();

    public GuiIndividualEditorBase(PixelmonData p, String titleText) {
        this.p = p;
        this.origName = Entity1Base.getLocalizedName(this.p.name);
        this.titleText = titleText;
    }

    @Override
    public void func_73866_w_() {
        int i;
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 155, this.field_146295_m / 2 + 90, 30, 20, I18n.func_74838_a((String)"gui.guiItemDrops.ok")));
        ArrayList<EnumTextureType> shinyOptions = new ArrayList<EnumTextureType>(Arrays.asList(EnumTextureType.Normal, EnumTextureType.Shiny));
        EnumPokemon species = this.p.getSpecies();
        if (species.hasSpecialTexture() && species.getSpecialTexture() != EnumSpecialTexture.Online) {
            shinyOptions.add(EnumTextureType.Special);
        }
        EnumTextureType currentType = EnumTextureType.Normal;
        if (this.p.isShiny) {
            currentType = EnumTextureType.Shiny;
        } else if (this.p.specialTexture != 0) {
            currentType = EnumTextureType.Special;
        }
        this.addDropDown(new GuiDropDown<EnumTextureType>(shinyOptions, currentType, this.field_146294_l / 2 - 120, this.field_146295_m / 2 + 14, 80, 50).setOnSelected(this::setTextureType).setGetOptionString(EnumTextureType::getLocalizedName));
        int malePercent = Entity3HasStats.getBaseStats((String)this.p.name).get().malePercent;
        if (malePercent > 0 && malePercent < 100) {
            this.field_146292_n.add(new GuiButtonHoverDisable(3, this.field_146294_l / 2 - 120, this.field_146295_m / 2 + 30, 80, 20, this.p.gender == Gender.Male ? I18n.func_74838_a((String)"gui.trainereditor.male") : I18n.func_74838_a((String)"gui.trainereditor.female")));
        }
        this.addDropDown(new GuiDropDown<EnumGrowth>(Arrays.asList(EnumGrowth.values()), this.p.growth, this.field_146294_l / 2 - 120, this.field_146295_m / 2 + 28, 80, 100).setOnSelected(growth -> {
            this.p.growth = growth;
        }).setGetOptionString(EnumGrowth::getLocalizedName).setInactiveTop(this.field_146295_m / 2 + 54));
        this.tbName = new GuiTextField(6, this.field_146297_k.field_71466_p, this.field_146294_l / 2 - 120, this.field_146295_m / 2 - 50, 90, 17);
        this.tbName.func_146180_a(Entity1Base.getLocalizedName(this.p.name.toLowerCase()));
        this.field_146292_n.add(new GuiButton(4, this.field_146294_l / 2 - 20, this.field_146295_m / 2 - 52, 100, 20, I18n.func_74838_a((String)"gui.trainereditor.changepokemon")));
        this.tbLvl = new GuiTextField(7, this.field_146297_k.field_71466_p, this.field_146294_l / 2 - 120, this.field_146295_m / 2 - 30, 60, 17);
        this.tbLvl.func_146180_a(this.p.lvl + "");
        this.tbNickname = new GuiTextField(8, this.field_146297_k.field_71466_p, this.field_146294_l / 2 - 120, this.field_146295_m / 2 - 10, 90, 17);
        this.tbNickname.func_146180_a(this.p.nickname);
        for (i = 0; i < this.tbMoves.length; ++i) {
            this.tbMoves[i] = new GuiTextField(9 + i, this.field_146297_k.field_71466_p, this.field_146294_l / 2 + 60, this.field_146295_m / 2 + 20 * i, 120, 17);
        }
        for (i = 0; i < this.p.numMoves; ++i) {
            this.attacks[i] = new Attack(this.p.moveset[i].attackIndex);
            this.tbMoves[i].func_146180_a(this.attacks[i].baseAttack.getLocalizedName());
        }
        this.field_146292_n.add(new GuiButton(6, this.field_146294_l / 2 + 105, this.field_146295_m / 2 - 110, 80, 20, I18n.func_74838_a((String)"gui.trainereditor.advanced")));
        this.textFields.clear();
        this.textFields.addAll(Arrays.asList(this.tbName, this.tbLvl, this.tbNickname, this.tbMoves[0], this.tbMoves[1], this.tbMoves[2], this.tbMoves[3]));
        if (Entity3HasStats.hasForms(this.p.name)) {
            this.formText = this.createExtraTextField(13);
            this.formText.func_146180_a(Short.toString(this.p.form));
            this.textFields.add(this.formText);
        } else {
            this.formText = null;
        }
        if (this.showDeleteButton()) {
            this.field_146292_n.add(new GuiButton(14, this.field_146294_l / 2 - 185, this.field_146295_m / 2 - 110, 90, 20, I18n.func_74838_a((String)"gui.trainereditor.deletepoke")));
        }
        this.field_146292_n.add(new GuiButton(15, this.field_146294_l / 2 + 20, this.field_146295_m / 2 + 90, 100, 20, I18n.func_74838_a((String)"gui.pokemoneditor.importexport")));
    }

    protected GuiTextField createExtraTextField(int id) {
        return new GuiTextField(id, this.field_146297_k.field_71466_p, this.field_146294_l / 2 - 120, this.field_146295_m / 2 + 72, 60, 17);
    }

    private void setTextureType(EnumTextureType textureType) {
        switch (textureType) {
            case Normal: {
                this.p.isShiny = false;
                this.p.specialTexture = 0;
                break;
            }
            case Shiny: {
                this.p.isShiny = true;
                this.p.specialTexture = 0;
                break;
            }
            case Special: {
                this.p.isShiny = false;
                this.p.specialTexture = (short)this.p.getSpecies().getSpecialTexture().id;
            }
        }
    }

    protected boolean showDeleteButton() {
        return true;
    }

    @Override
    protected void drawBackgroundUnderMenus(float f, int i, int j) {
        if (this.tbName == null) {
            this.func_73866_w_();
        }
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.cwPanel);
        GuiHelper.drawImageQuad(this.field_146294_l / 2 - 200, this.field_146295_m / 2 - 120, 400.0, 240.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        RenderHelper.func_74518_a();
        this.field_146297_k.field_71466_p.func_78276_b(this.titleText, this.field_146294_l / 2 - this.field_146297_k.field_71466_p.func_78256_a(this.titleText) / 2, this.field_146295_m / 2 - 90, 0);
        this.field_146297_k.field_71466_p.func_78276_b(I18n.func_74838_a((String)"gui.trainereditor.name"), this.field_146294_l / 2 - 180, this.field_146295_m / 2 - 45, 0);
        this.field_146297_k.field_71466_p.func_78276_b(I18n.func_74838_a((String)"gui.trainereditor.lvl"), this.field_146294_l / 2 - 180, this.field_146295_m / 2 - 25, 0);
        this.tbName.func_146194_f();
        this.tbLvl.func_146194_f();
        this.field_146297_k.field_71466_p.func_78276_b(I18n.func_74838_a((String)"gui.trainereditor.nickname"), this.field_146294_l / 2 - 180, this.field_146295_m / 2 - 5, 0);
        this.tbNickname.func_146194_f();
        this.field_146297_k.field_71466_p.func_78276_b(I18n.func_74838_a((String)"gui.trainereditor.shiny"), this.field_146294_l / 2 - 180, this.field_146295_m / 2 + 15, 0);
        this.field_146297_k.field_71466_p.func_78276_b(I18n.func_74838_a((String)"gui.trainereditor.gender"), this.field_146294_l / 2 - 180, this.field_146295_m / 2 + 35, 0);
        this.field_146297_k.field_71466_p.func_78276_b(I18n.func_74838_a((String)"gui.trainereditor.growth"), this.field_146294_l / 2 - 180, this.field_146295_m / 2 + 55, 0);
        GuiHelper.bindPokemonSprite(this.p, this.field_146297_k);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GuiHelper.drawImageQuad(this.field_146294_l / 2 - 157, this.field_146295_m / 2 - 73 - (this.p.isGen6Sprite() ? -3 : 0), 20.0, 20.0f, 0.0, 0.0, 1.0, 1.0, 1.0f);
        this.field_146297_k.field_71466_p.func_78276_b(I18n.func_74838_a((String)"gui.screenpokechecker.moves"), this.field_146294_l / 2 + 100, this.field_146295_m / 2 - 15, 0);
        for (GuiTextField tbMove : this.tbMoves) {
            tbMove.func_146194_f();
        }
        this.drawExtraText(this.formText, "gui.trainereditor.form");
    }

    protected void drawExtraText(GuiTextField textField, String langKey) {
        if (textField != null) {
            textField.func_146194_f();
            this.field_146297_k.field_71466_p.func_78276_b(I18n.func_74838_a((String)langKey), this.field_146294_l / 2 - 180, textField.field_146210_g + 3, 0);
        }
    }

    protected void func_73869_a(char key, int keyCode) throws IOException {
        this.tbLvl.func_146201_a(key, keyCode);
        int lvl = 0;
        try {
            lvl = Integer.parseInt(this.tbLvl.func_146179_b());
            if (lvl > 0 && lvl <= PixelmonServerConfig.maxLevel) {
                this.p.lvl = lvl;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        GuiHelper.textboxKeyTypedLimited(this.tbNickname, key, keyCode, 11);
        this.p.nickname = this.tbNickname.func_146179_b();
        this.tbName.func_146201_a(key, keyCode);
        for (GuiTextField tbMove : this.tbMoves) {
            tbMove.func_146201_a(key, keyCode);
        }
        if (this.formText != null) {
            this.formText.func_146201_a(key, keyCode);
            short form = 0;
            try {
                form = Short.parseShort(this.formText.func_146179_b());
                if (EnumPokemon.getFormFromID(this.p.getSpecies(), form) == null) {
                    form = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.p.form = form;
        }
        GuiHelper.switchFocus(keyCode, this.textFields);
        if (keyCode == 1 || keyCode == 28) {
            this.saveFields();
        }
    }

    @Override
    protected void mouseClickedUnderMenus(int x, int y, int button) throws IOException {
        this.tbLvl.func_146192_a(x, y, button);
        this.tbNickname.func_146192_a(x, y, button);
        this.tbName.func_146192_a(x, y, button);
        for (GuiTextField tbMove : this.tbMoves) {
            tbMove.func_146192_a(x, y, button);
        }
        if (this.formText != null) {
            this.formText.func_146192_a(x, y, button);
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146124_l) {
            if (button.field_146127_k == 1) {
                this.saveFields();
            } else if (button.field_146127_k == 3 && Entity3HasStats.getBaseStats((String)this.p.name).get().malePercent > 0) {
                this.p.gender = this.p.gender == Gender.Male ? Gender.Female : Gender.Male;
                button.field_146126_j = this.p.gender == Gender.Male ? I18n.func_74838_a((String)"gui.trainereditor.male") : I18n.func_74838_a((String)"gui.trainereditor.female");
            } else if (button.field_146127_k == 4) {
                Optional<EnumPokemon> pokemon = EnumPokemon.getFromName(this.tbName.func_146179_b());
                if (pokemon.isPresent()) {
                    this.origName = this.tbName.func_146179_b();
                    this.changePokemon(pokemon.get());
                } else {
                    this.tbName.func_146180_a(this.origName);
                }
            } else if (button.field_146127_k == 6) {
                if (this.checkFields()) {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiPokemonEditorAdvanced(this));
                }
            } else if (button.field_146127_k == 14) {
                this.deletePokemon();
            } else if (button.field_146127_k == 15 && this.checkFields()) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiImportExport(this, this.titleText));
            }
        }
    }

    protected abstract void changePokemon(EnumPokemon var1);

    protected abstract void deletePokemon();

    private void saveFields() {
        if (this.checkFields()) {
            this.saveAndClose();
        }
    }

    protected abstract void saveAndClose();

    protected boolean checkFields() {
        this.p.moveset[3] = null;
        this.p.moveset[2] = null;
        this.p.moveset[1] = null;
        this.p.moveset[0] = null;
        int numMoves = 0;
        for (GuiTextField tbMove : this.tbMoves) {
            String moveText = tbMove.func_146179_b();
            if (moveText.isEmpty()) continue;
            if (!Attack.hasAttack(moveText)) {
                tbMove.func_146180_a("");
                return false;
            }
            Attack a = new Attack(moveText);
            this.p.moveset[this.getNextAvailablePosition()] = PixelmonMovesetData.createPacket(a);
        }
        for (int i = 0; i < 4; ++i) {
            if (this.p.moveset[i] == null) continue;
            ++numMoves;
        }
        if (numMoves == 0) {
            return false;
        }
        this.p.numMoves = numMoves;
        return true;
    }

    public int getNextAvailablePosition() {
        for (int i = 0; i < 4; ++i) {
            if (this.p.moveset[i] != null) continue;
            return i;
        }
        return -1;
    }

    public abstract List<PixelmonData> getPokemonList();

    @Override
    public String getExportText() {
        return ImportExportConverter.getExportText(this.p);
    }

    @Override
    public String importText(String importText) {
        return ImportExportConverter.importText(importText, this.p);
    }

    @Override
    public GuiScreen getScreen() {
        return this;
    }
}

