/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pokemoneditor;

import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.FormData;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class ImportExportForm {
    private static ImportExportForm instance;
    private Map<EnumPokemon, Map<Short, String>> speciesMap = new HashMap<EnumPokemon, Map<Short, String>>();
    private Map<String, FormData> nameMap = new HashMap<String, FormData>();

    static ImportExportForm getInstance() {
        if (instance == null) {
            instance = new ImportExportForm();
        }
        return instance;
    }

    private ImportExportForm() {
        for (EnumPokemon pokemon : EnumPokemon.formList.keySet()) {
            List list = EnumPokemon.formList.get((Object)pokemon);
            this.addFormData(pokemon, (short)0, "");
            this.addFormData(pokemon, (short)-1, "");
            for (IEnumForm iEnumForm : list) {
                this.addFormData(pokemon, iEnumForm.getForm(), iEnumForm.getFormSuffix());
            }
        }
    }

    private void addSpeciesFormData(EnumPokemon species, String ... formNames) {
        this.addFormData(species, (short)0, "");
        this.addFormData(species, (short)-1, "");
        for (int i = 0; i < formNames.length; i = (int)((short)(i + 1))) {
            String formName = formNames[i];
            this.addFormData(species, (short)(i + 1), formName);
        }
    }

    private void addFormData(EnumPokemon species, short formIndex, String formName) {
        Map<Object, Object> formMap;
        if (this.speciesMap.containsKey((Object)species)) {
            formMap = this.speciesMap.get((Object)species);
        } else {
            formMap = new HashMap();
            this.speciesMap.put(species, formMap);
        }
        String fullFormName = species.name;
        if (!formName.isEmpty()) {
            fullFormName = fullFormName + "-" + formName;
        }
        formMap.put(formIndex, fullFormName);
        this.nameMap.put(fullFormName, new FormData(species, formIndex));
    }

    String getFormName(EnumPokemon species, short formIndex) {
        if (this.speciesMap.isEmpty()) {
            instance = new ImportExportForm();
        }
        if (this.speciesMap.containsKey((Object)species)) {
            Map<Short, String> formMap = this.speciesMap.get((Object)species);
            if (formMap.containsKey(formIndex)) {
                return formMap.get(formIndex);
            }
            return formMap.get(0);
        }
        return species.name;
    }

    Optional<FormData> getFormData(String formName) {
        if (this.speciesMap.isEmpty()) {
            instance = new ImportExportForm();
        }
        if (this.nameMap.containsKey(formName)) {
            return Optional.of(this.nameMap.get(formName));
        }
        return Optional.empty();
    }
}

