/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.statueEditor;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.elements.GuiContainerDropDown;
import com.pixelmonmod.pixelmon.client.gui.elements.GuiDropDown;
import com.pixelmonmod.pixelmon.client.render.RenderStatue;
import com.pixelmonmod.pixelmon.comm.packetHandlers.statueEditor.EnumStatuePacketMode;
import com.pixelmonmod.pixelmon.comm.packetHandlers.statueEditor.StatuePacketServer;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityStatue;
import com.pixelmonmod.pixelmon.entities.pixelmon.EnumSpecialTexture;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.EnumStatueTextureType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;

public class GuiStatueEditor
extends GuiContainerDropDown {
    public static int[] statueId;
    private EntityStatue statue;
    GuiButton animationGuiButton;
    GuiButton modelGuiButton;
    GuiTextField tbName;
    GuiTextField tbLabel;
    GuiTextField tbFrame;
    int controlWidth = 320;
    int controlLeft;
    int controlHeight = 90;
    int controlTop;
    ModelBase lastModel;
    private GuiTextField formText;
    int lastFrame;
    static float spinCount;
    private EntityStatue renderTarget;

    public GuiStatueEditor(int entityid) {
        EntityStatue statue;
        Keyboard.enableRepeatEvents((boolean)true);
        Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(entityid);
        if (entity instanceof EntityStatue && PixelmonMethods.isIDSame((statue = (EntityStatue)entity).getPokemonId(), statueId)) {
            this.statue = statue;
        }
    }

    @Override
    public void func_73866_w_() {
        if (this.statue == null) {
            GuiHelper.closeScreen();
            return;
        }
        super.func_73866_w_();
        this.controlLeft = this.field_146294_l / 2 - this.controlWidth / 2;
        this.controlTop = this.field_146295_m - this.controlHeight - 10;
        int buttonHeight = 20;
        int textFieldHeight = 17;
        this.field_146292_n.add(new GuiButton(0, this.controlLeft + 137, this.controlTop + 8, 80, buttonHeight, I18n.func_74838_a((String)"gui.update.text")));
        ArrayList<EnumStatueTextureType> textures = new ArrayList<EnumStatueTextureType>(Arrays.asList(EnumStatueTextureType.values()));
        BaseStats stats = this.statue.initializeBaseStatsIfNull();
        if (stats == null) {
            GuiHelper.closeScreen();
            return;
        }
        EnumPokemon e = stats.pokemon;
        if (!e.hasSpecialTexture() || e.getSpecialTexture() == EnumSpecialTexture.Online) {
            textures.remove((Object)EnumStatueTextureType.Special);
        }
        this.addDropDown(new GuiDropDown<EnumStatueTextureType>(textures, this.statue.getTextureType(), this.controlLeft + 228, this.controlTop - 15, 80, 150).setGetOptionString(texture -> texture.getLocalizedName()).setOnSelected(texture -> Pixelmon.network.sendToServer((IMessage)new StatuePacketServer(EnumStatuePacketMode.SetTextureType, statueId, texture.toString()))).setInactiveTop(this.controlTop + 20));
        this.addDropDown(new GuiDropDown<EnumGrowth>(Arrays.asList(EnumGrowth.values()), this.statue.getGrowth(), this.controlLeft + 45, this.controlTop + 4, 80, 150).setGetOptionString(growth -> growth.getLocalizedName()).setOnSelected(growth -> Pixelmon.network.sendToServer((IMessage)new StatuePacketServer(EnumStatuePacketMode.SetGrowth, statueId, growth.toString()))).setInactiveTop(this.controlTop + 35));
        this.field_146292_n.add(new GuiButton(1, this.controlLeft + this.controlWidth - 55, this.field_146295_m - 31, 50, buttonHeight, I18n.func_74838_a((String)"gui.save.text")));
        this.tbFrame = null;
        if (this.statue.isSmd() && this.statue.getFrameCount() > 0) {
            int animTop = this.controlTop + 73;
            List<String> anims = this.statue.getAllAnimations();
            this.addDropDown(new GuiDropDown<String>(anims, this.statue.getAnimation(), this.controlLeft + 48, animTop + Math.max(-16, (anims.size() - 1) * -10), 60, 100).setGetOptionString(animation -> I18n.func_74838_a((String)("gui.model." + animation))).setOnSelected(this::selectAnimation).setInactiveTop(this.controlTop + 73));
            this.tbFrame = new GuiTextField(9, this.field_146297_k.field_71466_p, this.controlLeft + 158, this.controlTop + 70, 40, textFieldHeight);
            this.tbFrame.func_146180_a(this.statue.getAnimationFrame() + "");
            this.lastFrame = this.statue.getAnimationFrame();
        }
        if (this.statue.hasFlyingModel()) {
            String extra = this.statue.getIsFlying() ? "flying" : "standing";
            this.modelGuiButton = new GuiButton(10, this.controlLeft + 137, this.controlTop + 30, 80, buttonHeight, I18n.func_74838_a((String)("gui.model." + extra)));
            this.field_146292_n.add(this.modelGuiButton);
        }
        this.tbName = new GuiTextField(6, this.field_146297_k.field_71466_p, this.controlLeft + 45, this.controlTop + 10, 90, textFieldHeight);
        this.tbName.func_146180_a(this.statue.getLocalizedName());
        this.tbLabel = new GuiTextField(7, this.field_146297_k.field_71466_p, this.controlLeft + 45, this.controlTop + 51, 180, textFieldHeight);
        this.tbLabel.func_146180_a(this.statue.getLabel());
        this.lastModel = this.statue.getModel();
        if (this.formText == null) {
            this.formText = new GuiTextField(11, this.field_146297_k.field_71466_p, this.controlLeft + 270, this.controlTop + 45, 40, textFieldHeight);
            this.formText.func_146180_a(Integer.toString(this.statue.getForm()));
            this.checkForm();
        }
    }

    private void selectAnimation(String nextAnim) {
        this.statue.setAnimation(nextAnim);
        Pixelmon.network.sendToServer((IMessage)new StatuePacketServer(EnumStatuePacketMode.SetAnimation, statueId, nextAnim));
    }

    protected void func_73869_a(char key, int keyCode) throws IOException {
        int eventKey = Keyboard.getEventKey();
        if (eventKey == 1 || eventKey == 28) {
            this.closeScreen();
            return;
        }
        if (this.tbName == null) {
            this.func_73866_w_();
        }
        ArrayList<GuiTextField> guiTextFields = new ArrayList<GuiTextField>(4);
        this.tbName.func_146201_a(key, keyCode);
        guiTextFields.add(this.tbName);
        this.tbLabel.func_146201_a(key, keyCode);
        guiTextFields.add(this.tbLabel);
        if (this.tbFrame != null) {
            this.tbFrame.func_146201_a(key, keyCode);
            guiTextFields.add(this.tbFrame);
            if (this.tbFrame.func_146206_l()) {
                int frame = 0;
                if (!this.tbFrame.func_146179_b().isEmpty()) {
                    try {
                        frame = Integer.parseInt(this.tbFrame.func_146179_b());
                    }
                    catch (NumberFormatException exc) {
                        this.tbFrame.func_146180_a("");
                    }
                }
                if (frame != this.lastFrame) {
                    if (frame < 0) {
                        frame = 0;
                        this.tbFrame.func_146180_a("");
                    } else if (frame >= this.statue.getFrameCount()) {
                        frame = this.statue.getFrameCount() - 1;
                        this.tbFrame.func_146180_a(String.valueOf(frame));
                    }
                    if (frame != this.lastFrame) {
                        this.statue.setAnimationFrame(frame);
                        Pixelmon.network.sendToServer((IMessage)new StatuePacketServer(EnumStatuePacketMode.SetAnimationFrame, statueId, frame));
                        this.lastFrame = frame;
                    }
                }
            }
        }
        if (this.formText.func_146176_q()) {
            this.formText.func_146201_a(key, keyCode);
            guiTextFields.add(this.formText);
            if (this.formText.func_146206_l()) {
                int form = -1;
                try {
                    form = Integer.parseInt(this.formText.func_146179_b());
                }
                catch (NumberFormatException exc) {
                    // empty catch block
                }
                if (form != this.statue.getForm()) {
                    Pixelmon.network.sendToServer((IMessage)new StatuePacketServer(EnumStatuePacketMode.SetForm, statueId, form));
                    boolean hasMega = this.statue.baseStats.pokemon.hasMega();
                    if (hasMega && form > 0) {
                        this.resetSpecialTexture();
                        if (this.statue.getIsFlying()) {
                            this.changeFlying(false);
                        }
                    }
                    this.statue.setForm(form);
                }
            }
        }
        GuiTextField[] GuiTextFieldsArray = new GuiTextField[guiTextFields.size()];
        GuiHelper.switchFocus(keyCode, guiTextFields.toArray(GuiTextFieldsArray));
    }

    private void closeScreen() {
        EnumPokemon e;
        if (!this.tbName.func_146179_b().equalsIgnoreCase(this.statue.getPokemonName()) && (e = EnumPokemon.getFromNameAnyCase(this.tbName.func_146179_b())) != null) {
            Pixelmon.network.sendToServer((IMessage)new StatuePacketServer(EnumStatuePacketMode.SetName, statueId, e.name));
        }
        if (!this.tbLabel.func_146179_b().equalsIgnoreCase(this.statue.getLabel())) {
            Pixelmon.network.sendToServer((IMessage)new StatuePacketServer(EnumStatuePacketMode.SetLabel, statueId, this.tbLabel.func_146179_b()));
        }
        GuiHelper.closeScreen();
        this.field_146297_k.func_71381_h();
    }

    @Override
    protected void mouseClickedUnderMenus(int x, int y, int mouseButton) throws IOException {
        if (this.tbName == null) {
            this.func_73866_w_();
        }
        this.tbName.func_146192_a(x, y, mouseButton);
        this.tbLabel.func_146192_a(x, y, mouseButton);
        if (this.tbFrame != null) {
            this.tbFrame.func_146192_a(x, y, mouseButton);
        }
        if (this.formText.func_146176_q()) {
            this.formText.func_146192_a(x, y, mouseButton);
        }
    }

    protected void func_146284_a(GuiButton guiButton) throws IOException {
        super.func_146284_a(guiButton);
        if (this.tbName == null) {
            this.func_73866_w_();
        }
        if (guiButton.field_146127_k == 0) {
            EnumPokemon e = EnumPokemon.getFromNameAnyCase(this.tbName.func_146179_b());
            if (e != null) {
                if (!e.hasSpecialTexture()) {
                    this.resetSpecialTexture();
                }
                Pixelmon.network.sendToServer((IMessage)new StatuePacketServer(EnumStatuePacketMode.SetName, statueId, e.name));
            } else {
                this.tbName.func_146180_a(I18n.func_74838_a((String)("pixelmon." + this.statue.getPokemonName().toLowerCase() + ".name")));
            }
        } else if (guiButton.field_146127_k == 1) {
            this.closeScreen();
        } else if (guiButton.field_146127_k == 10) {
            this.changeFlying(!this.statue.getIsFlying());
        }
    }

    private void changeFlying(boolean isFlying) {
        String extra;
        this.statue.setIsFlying(isFlying);
        Pixelmon.network.sendToServer((IMessage)new StatuePacketServer(EnumStatuePacketMode.SetModelStanding, statueId, isFlying));
        String string = extra = isFlying ? "flying" : "standing";
        if (this.modelGuiButton != null) {
            this.modelGuiButton.field_146126_j = I18n.func_74838_a((String)("gui.model." + extra));
        }
    }

    @Override
    protected void drawBackgroundUnderMenus(float p_146976_1_, int p_146976_2_, int par3) {
        EntityStatue ep;
        this.func_73733_a(this.controlLeft, this.controlTop, this.controlLeft + this.controlWidth, this.controlTop + this.controlHeight, -1713512995, -1713512995);
        if (this.statue.getModel() != this.lastModel) {
            ScaledResolution scaledresolution = new ScaledResolution(this.field_146297_k);
            int i = scaledresolution.func_78326_a();
            int j = scaledresolution.func_78328_b();
            this.func_146280_a(this.field_146297_k, i, j);
            this.checkForm();
            if (this.formText.func_146176_q()) {
                int oldForm = this.statue.getForm();
                this.statue.setForm(oldForm);
                int newForm = this.statue.getForm();
                if (oldForm != newForm || this.formText.func_146179_b().equals("-1")) {
                    this.formText.func_146180_a(Integer.toString(newForm));
                }
            }
            this.lastModel = this.statue.getModel();
        }
        String text = I18n.func_74838_a((String)"gui.trainereditor.name");
        this.field_146297_k.field_71466_p.func_78276_b(text, this.controlLeft + 40 - this.field_146297_k.field_71466_p.func_78256_a(text), this.controlTop + 16, 0x555555);
        text = I18n.func_74838_a((String)"gui.trainereditor.growth");
        this.field_146297_k.field_71466_p.func_78276_b(text, this.controlLeft + 40 - this.field_146297_k.field_71466_p.func_78256_a(text), this.controlTop + 36, 0x555555);
        if (this.tbName != null) {
            this.tbName.func_146194_f();
        }
        text = I18n.func_74838_a((String)"gui.label.text");
        this.field_146297_k.field_71466_p.func_78276_b(text, this.controlLeft + 40 - this.field_146297_k.field_71466_p.func_78256_a(text), this.controlTop + 56, 0x555555);
        if (this.tbLabel != null) {
            this.tbLabel.func_146194_f();
        }
        text = I18n.func_74838_a((String)"gui.texture.text");
        this.field_146297_k.field_71466_p.func_78276_b(text, this.controlLeft + 268 - this.field_146297_k.field_71466_p.func_78256_a(text) / 2, this.controlTop + 10, 0x555555);
        if (this.tbFrame != null) {
            text = I18n.func_74838_a((String)"gui.model.animation");
            this.field_146297_k.field_71466_p.func_78276_b(text, this.controlLeft + 46 - this.field_146297_k.field_71466_p.func_78256_a(text), this.controlTop + 74, 0x555555);
            this.tbFrame.func_146194_f();
            text = I18n.func_74838_a((String)"gui.model.frame");
            this.field_146297_k.field_71466_p.func_78276_b(text, this.controlLeft + 150 - this.field_146297_k.field_71466_p.func_78256_a(text), this.controlTop + 74, 0x555555);
            text = "/" + (this.statue.getFrameCount() - 1);
            this.field_146297_k.field_71466_p.func_78276_b(text, this.controlLeft + 200, this.controlTop + 74, 0x555555);
        }
        if (this.formText.func_146176_q()) {
            this.formText.func_146194_f();
            this.field_146297_k.field_71466_p.func_78276_b(I18n.func_74838_a((String)"gui.trainereditor.form"), this.controlLeft + 240, this.controlTop + 51, 0x555555);
        }
        if ((ep = this.statue) != null && ep.getModel() != null) {
            GuiStatueEditor.drawEntityToScreen(this.field_146294_l / 2 - 10, this.field_146295_m / 2 + 20, 200, 200, ep, par3, true);
        }
    }

    public static void drawEntityToScreen(int x, int y, int w, int l, EntityStatue e, float pt, boolean spin) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179142_g();
        GlStateManager.func_179126_j();
        GlStateManager.func_179109_b((float)x, (float)y, (float)100.0f);
        float eheight = (float)l / e.field_70131_O / 4.0f;
        float ewidth = (float)l / e.field_70130_N / 4.0f;
        float scalar = eheight > ewidth ? eheight : ewidth;
        GlStateManager.func_179152_a((float)scalar, (float)scalar, (float)scalar);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (spin) {
            GlStateManager.func_179114_b((float)(spinCount += 0.66f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        RenderHelper.func_74519_b();
        try {
            RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
            Render entityClassRenderObject = renderManager.func_78715_a(EntityStatue.class);
            RenderStatue rp = (RenderStatue)entityClassRenderObject;
            rp.renderStatue(e, 0.0, e.func_70033_W(), 0.0, 0.0f, pt, true);
            renderManager.field_78735_i = 180.0f;
        }
        catch (Exception exception) {
            // empty catch block
        }
        GlStateManager.func_179121_F();
    }

    public EntityStatue getRenderTarget(String name) {
        if (this.renderTarget != null) {
            return this.renderTarget;
        }
        if (name == null || name.equals("???") || !EnumPokemon.hasPokemon(name)) {
            return null;
        }
        this.renderTarget = new EntityStatue((World)this.field_146297_k.field_71441_e);
        this.renderTarget.init(name);
        this.renderTarget.setGrowth(EnumGrowth.Ordinary);
        return this.renderTarget;
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    public void func_146276_q_() {
        this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, -1725816286, -1725816286);
    }

    public void func_146278_c(int tint) {
        super.func_146278_c(tint);
    }

    private void checkForm() {
        if (this.statue.baseStats != null) {
            if (this.statue.hasForms() || this.statue.baseStats.pokemon.hasMega()) {
                this.formText.func_146189_e(true);
            } else if (this.formText.func_146176_q()) {
                this.formText.func_146189_e(false);
                this.formText.func_146180_a("-1");
                this.statue.setForm(-1);
            }
        }
    }

    private void resetSpecialTexture() {
        if (this.statue.getTextureType() == EnumStatueTextureType.Special) {
            EnumStatueTextureType t = EnumStatueTextureType.OriginalTexture;
            ((GuiButton)this.field_146292_n.get((int)1)).field_146126_j = I18n.func_74838_a((String)("enum.statuetex." + t.toString().toLowerCase()));
            this.statue.setTextureType(t);
            Pixelmon.network.sendToServer((IMessage)new StatuePacketServer(EnumStatuePacketMode.SetTextureType, statueId, t.toString()));
        }
    }

    static {
        spinCount = 0.0f;
    }
}

