/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.models;

import com.pixelmonmod.pixelmon.client.models.ModelCustomWrapper;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelBase;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelRenderer;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelSmd;
import com.pixelmonmod.pixelmon.client.models.animations.SkeletonBase;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModel;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumPokemonModel;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PixelmonSmdFactory {
    protected EnumPokemonModel model;
    protected float xRotation;
    protected float yRotation = 24.0f;
    protected float zRotation;
    protected float rotateAngleX = -1.5707964f;
    protected float rotateAngleY;
    protected float movementThreshold = 0.3f;
    protected float animationIncrement = 1.0f;
    private float scale = 1.0f;

    public PixelmonSmdFactory(EnumPokemonModel model) {
        this.model = model;
    }

    public PixelmonSmdFactory setYRotation(float yRotation) {
        this.yRotation = yRotation;
        return this;
    }

    public PixelmonSmdFactory setZRotation(float zRotation) {
        this.zRotation = zRotation;
        return this;
    }

    public PixelmonSmdFactory setMovementThreshold(float threshold) {
        this.movementThreshold = threshold;
        return this;
    }

    public PixelmonSmdFactory setRotateAngleX(float rotateAngleX) {
        this.rotateAngleX = rotateAngleX;
        return this;
    }

    public PixelmonSmdFactory setRotateAngleY(float rotateAngleY) {
        this.rotateAngleY = rotateAngleY;
        return this;
    }

    public PixelmonSmdFactory setAnimationIncrement(float animationIncrement) {
        this.animationIncrement = animationIncrement;
        return this;
    }

    public PixelmonSmdFactory setScale(float scale) {
        this.scale = scale;
        return this;
    }

    public PixelmonModelSmd createModel() {
        Impl impl = new Impl((ValveStudioModel)this.model.loadModel());
        impl.body.func_78793_a(this.xRotation, this.yRotation, this.zRotation);
        ((Impl)impl).body.field_78795_f = this.rotateAngleX;
        ((Impl)impl).body.field_78796_g = this.rotateAngleY;
        impl.movementThreshold = this.movementThreshold;
        impl.animationIncrement = this.animationIncrement;
        ((PixelmonModelBase)impl).scale = this.scale;
        return impl;
    }

    public float getScale() {
        return this.scale;
    }

    public static class Impl
    extends PixelmonModelSmd {
        private PixelmonModelRenderer body;

        Impl(ValveStudioModel valveStudioModel) {
            this.theModel = valveStudioModel;
            this.body = new PixelmonModelRenderer(this, "body");
            this.body.addCustomModel(new ModelCustomWrapper(valveStudioModel));
            this.skeleton = new SkeletonBase(this.body);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
            if (entity instanceof EntityPixelmon) {
                // empty if block
            }
            super.func_78088_a(entity, f, f1, f2, f3, f4, f5);
            this.body.func_78785_a(f5);
        }
    }
}

