/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.layers;

import com.pixelmonmod.pixelmon.client.PlayerExtraDataStore;
import com.pixelmonmod.pixelmon.client.models.IPixelmonModel;
import com.pixelmonmod.pixelmon.enums.EnumCustomModel;
import com.pixelmonmod.pixelmon.storage.PlayerExtraData;
import com.pixelmonmod.pixelmon.storage.PlayerExtras;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LayerHat
implements LayerRenderer<EntityPlayer> {
    private final ModelRenderer modelRenderer;
    private final RenderPlayer renderer;
    private final ResourceLocation locationCapBG;
    private final DynamicTexture capBG;
    private IModel topHatModel;
    private IModel fezModel;
    private IModel fedoraModel;
    private IModel monocleModel;
    private IModel trainerHatModel;
    private IModel pikaHoodModel;

    public LayerHat(RenderPlayer renderer, ModelRenderer modelRenderer) {
        this.modelRenderer = modelRenderer;
        this.renderer = renderer;
        this.capBG = new DynamicTexture(1, 1);
        this.capBG.func_110565_c()[0] = -1;
        this.capBG.func_110564_a();
        this.locationCapBG = Minecraft.func_71410_x().func_110434_K().func_110578_a("capBG", this.capBG);
    }

    public void doRenderLayer(EntityPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        PlayerExtraData extras = PlayerExtraDataStore.get(player);
        if (extras.getHatType() != PlayerExtras.HatType.NONE && !player.func_82150_aj()) {
            GlStateManager.func_179094_E();
            IModel hat = null;
            String path = "";
            if (player.func_70093_af()) {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.75f, (float)0.0f);
            }
            this.modelRenderer.func_78794_c(1.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)1.5f, (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179091_B();
            if (extras.getHatType() == PlayerExtras.HatType.TOP_HAT) {
                if (this.topHatModel == null) {
                    this.topHatModel = EnumCustomModel.TopHat.getModel();
                }
                hat = this.topHatModel;
                path = "pixelmon:textures/playeritems/tophat.png";
            } else if (extras.getHatType() == PlayerExtras.HatType.FEZ) {
                if (this.fezModel == null) {
                    this.fezModel = EnumCustomModel.Fez.getModel();
                }
                hat = this.fezModel;
                path = "pixelmon:textures/playeritems/fez.png";
            } else if (extras.getHatType() == PlayerExtras.HatType.FEDORA) {
                if (this.fedoraModel == null) {
                    this.fedoraModel = EnumCustomModel.Fedora.getModel();
                }
                hat = this.fedoraModel;
                path = "pixelmon:textures/playeritems/fedora.png";
            } else if (extras.getHatType().id == 3) {
                if (this.monocleModel == null) {
                    this.monocleModel = EnumCustomModel.Monocle.getModel();
                }
                hat = this.monocleModel;
                path = "pixelmon:textures/playeritems/monocle.png";
            } else if (extras.getHatType() == PlayerExtras.HatType.TRAINER_HAT) {
                if (this.trainerHatModel == null) {
                    this.trainerHatModel = EnumCustomModel.TrainerHat.getModel();
                }
                hat = this.trainerHatModel;
                if (extras.capColours[0] == -1) {
                    this.renderer.func_110776_a(this.locationCapBG);
                    int i = player.field_70173_aa / 25 + player.func_145782_y();
                    int j = EnumDyeColor.values().length;
                    int k = i % j;
                    int l = (i + 1) % j;
                    float f7 = ((float)(player.field_70173_aa % 25) + partialTicks) / 25.0f;
                    float[] afloat1 = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.func_176764_b((int)k));
                    float[] afloat2 = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.func_176764_b((int)l));
                    float r = afloat1[0] * (1.0f - f7) + afloat2[0] * f7;
                    float g = afloat1[1] * (1.0f - f7) + afloat2[1] * f7;
                    float b = afloat1[2] * (1.0f - f7) + afloat2[2] * f7;
                    this.capBG.func_110565_c()[0] = 0xFF000000 | (int)((double)(r * 255.0f) + 0.5) << 16 | (int)((double)(g * 255.0f) + 0.5) << 8 | (int)((double)(b * 255.0f) + 0.5);
                    this.capBG.func_110564_a();
                } else {
                    this.capBG.func_110565_c()[0] = 0xFF000000 | extras.capColours[0] << 16 | extras.capColours[1] << 8 | extras.capColours[2];
                    this.capBG.func_110564_a();
                }
                ((IPixelmonModel)hat).renderAll();
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                path = "pixelmon:textures/playeritems/trainerhat.png";
            } else if (extras.getHatType().id == 5) {
                if (this.pikaHoodModel == null) {
                    this.pikaHoodModel = EnumCustomModel.PikaHood.getModel();
                }
                hat = this.pikaHoodModel;
                path = "pixelmon:textures/playeritems/fez.png";
            } else {
                GlStateManager.func_179121_F();
                return;
            }
            Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110577_a(new ResourceLocation(path));
            ((IPixelmonModel)hat).renderAll();
            GlStateManager.func_179121_F();
        }
    }

    public boolean func_177142_b() {
        return true;
    }
}

