/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.layers;

import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.client.PlayerExtraDataStore;
import com.pixelmonmod.pixelmon.client.models.IPixelmonModel;
import com.pixelmonmod.pixelmon.client.models.pokeballs.ModelPokeballs;
import com.pixelmonmod.pixelmon.enums.EnumCustomModel;
import com.pixelmonmod.pixelmon.enums.items.EnumPokeballs;
import com.pixelmonmod.pixelmon.listener.EntityPlayerExtension;
import com.pixelmonmod.pixelmon.storage.PlayerExtraData;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class LayerSash
implements LayerRenderer<EntityPlayer> {
    private final ResourceLocation normalSash = new ResourceLocation("pixelmon:textures/playeritems/otherstuff.png");
    private final ResourceLocation adminSash = new ResourceLocation("pixelmon:textures/playeritems/admin.png");
    private final ResourceLocation developerSash = new ResourceLocation("pixelmon:textures/playeritems/developer.png");
    private final ResourceLocation moddelerSash = new ResourceLocation("pixelmon:textures/playeritems/modeler.png");
    private final IPixelmonModel sashModel = (IPixelmonModel)EnumCustomModel.Sash.getModel();
    private final RenderPlayer renderer;
    private final HashMap<EnumPokeballs, ModelPokeballs> pokeballModels = Maps.newHashMap();
    private final ResourceLocation locationSashBG;
    private final DynamicTexture sashBG;

    public LayerSash(RenderPlayer renderer) {
        this.renderer = renderer;
        this.sashBG = new DynamicTexture(1, 1);
        this.sashBG.func_110565_c()[0] = -1;
        this.sashBG.func_110564_a();
        this.locationSashBG = Minecraft.func_71410_x().func_110434_K().func_110578_a("sashBG2", this.sashBG);
    }

    public void doRenderLayer(EntityPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        int[] balls;
        PlayerExtraData extras = PlayerExtraDataStore.get(player);
        if (!extras.hasSash || !extras.sashEnabled || player.func_82150_aj()) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean needsColouring = false;
        if (extras.colours[0] <= 0 && extras.colours[1] <= 0 && extras.colours[2] <= 0) {
            if (extras.isAdmin) {
                this.renderer.func_110776_a(this.adminSash);
            } else if (extras.isDeveloper) {
                this.renderer.func_110776_a(this.developerSash);
            } else if (extras.isModeller) {
                this.renderer.func_110776_a(this.moddelerSash);
            } else {
                needsColouring = true;
            }
        } else {
            needsColouring = true;
        }
        scale = 1.0f;
        if (player.func_70093_af()) {
            this.renderer.func_177087_b().field_178730_v.field_78797_d = (float)((double)this.renderer.func_177087_b().field_178730_v.field_78797_d + (double)scale * 0.2);
        }
        this.renderer.func_177087_b().field_178730_v.func_78794_c(scale);
        GlStateManager.func_179137_b((double)0.0, (double)1.5, (double)0.0);
        if (player.field_71071_by.field_70460_b.get(2) != ItemStack.field_190927_a) {
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)(scale + 0.31f));
        } else {
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        }
        if (extras.hasRainbowSash) {
            this.renderer.func_110776_a(this.locationSashBG);
            int i = player.field_70173_aa / 25 + player.func_145782_y();
            int j = EnumDyeColor.values().length;
            int k = i % j;
            int l = (i + 1) % j;
            float f7 = ((float)(player.field_70173_aa % 25) + partialTicks) / 25.0f;
            float[] afloat1 = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.func_176764_b((int)k));
            float[] afloat2 = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.func_176764_b((int)l));
            float r = afloat1[0] * (1.0f - f7) + afloat2[0] * f7;
            float g = afloat1[1] * (1.0f - f7) + afloat2[1] * f7;
            float b = afloat1[2] * (1.0f - f7) + afloat2[2] * f7;
            this.sashBG.func_110565_c()[0] = 0xFF000000 | (int)((double)(r * 255.0f) + 0.5) << 16 | (int)((double)(g * 255.0f) + 0.5) << 8 | (int)((double)(b * 255.0f) + 0.5);
            this.sashBG.func_110564_a();
            this.sashModel.renderAll();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            this.renderer.func_110776_a(this.normalSash);
            needsColouring = false;
        }
        if (needsColouring) {
            this.renderer.func_110776_a(this.locationSashBG);
            this.sashBG.func_110565_c()[0] = extras.colours[0] != -1 ? 0xFF000000 | extras.colours[0] << 16 | extras.colours[1] << 8 | extras.colours[2] : -4773323;
            this.sashBG.func_110564_a();
            this.sashModel.renderAll();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            this.renderer.func_110776_a(this.normalSash);
        }
        this.sashModel.renderAll();
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)-0.175, (double)1.44, (double)0.15);
        for (int ball : balls = EntityPlayerExtension.getPlayerPokeballs(player)) {
            if (ball < 0) continue;
            EnumPokeballs pokeball = EnumPokeballs.getFromIndex(ball);
            if (this.pokeballModels.get(pokeball) == null) {
                this.pokeballModels.put(pokeball, pokeball.getModel());
            }
            this.renderer.func_110776_a(new ResourceLocation(pokeball.getTextureDirectory() + pokeball.getTexture()));
            GlStateManager.func_179137_b((double)0.0275, (double)-0.05, (double)0.0);
            this.pokeballModels.get(pokeball).render(null, 6.0E-4f);
        }
        GlStateManager.func_179121_F();
    }

    public boolean func_177142_b() {
        return true;
    }
}

