/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.tileEntities;

import com.pixelmonmod.pixelmon.blocks.machines.BlockHealer;
import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityHealer;
import com.pixelmonmod.pixelmon.client.models.blocks.ModelHealer;
import com.pixelmonmod.pixelmon.client.models.pokeballs.ModelPokeballs;
import com.pixelmonmod.pixelmon.client.render.BlockModelHolder;
import com.pixelmonmod.pixelmon.client.render.tileEntities.SharedModels;
import com.pixelmonmod.pixelmon.client.render.tileEntities.TileEntityRenderer;
import com.pixelmonmod.pixelmon.entities.pokeballs.EntityPokeBall;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class RenderTileEntityHealer
extends TileEntityRenderer<TileEntityHealer> {
    private static final BlockModelHolder<ModelHealer> modelHealer = new BlockModelHolder<ModelHealer>(ModelHealer.class);
    private static final ResourceLocation texture = new ResourceLocation("pixelmon:textures/blocks/healer.png");

    public RenderTileEntityHealer() {
        this.yOffset = 1.5f;
        this.correctionAngles = 180;
    }

    @Override
    public void renderTileEntity(TileEntityHealer healer, IBlockState state, double x, double y, double z, float partialTicks, int destroyStage) {
        this.func_147499_a(texture);
        ((ModelHealer)((Object)modelHealer.getModel())).renderModel(healer, 0.0625f);
        if (healer.stayDark) {
            healer.rotation = 0.0f;
        }
        if (healer.beingUsed) {
            for (int slot = 0; slot < healer.pokeballType.length; ++slot) {
                if (healer.pokeballType[slot] == null) continue;
                this.renderPokeball(slot, healer);
            }
        }
    }

    @Override
    protected int getRotation(IBlockState state) {
        if (state.func_177230_c() instanceof BlockHealer) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockHealer.FACING);
            if (facing == EnumFacing.EAST) {
                return 270;
            }
            if (facing == EnumFacing.NORTH) {
                return 0;
            }
            if (facing == EnumFacing.WEST) {
                return 90;
            }
            if (facing == EnumFacing.SOUTH) {
                return 180;
            }
        }
        return 0;
    }

    private void renderPokeball(int slot, TileEntityHealer tile) {
        GlStateManager.func_179094_E();
        float y = 0.76f;
        switch (slot) {
            case 0: {
                GlStateManager.func_179109_b((float)-0.12f, (float)y, (float)0.25f);
                break;
            }
            case 1: {
                GlStateManager.func_179109_b((float)0.12f, (float)y, (float)0.25f);
                break;
            }
            case 2: {
                GlStateManager.func_179109_b((float)-0.12f, (float)y, (float)0.0f);
                break;
            }
            case 3: {
                GlStateManager.func_179109_b((float)0.12f, (float)y, (float)0.0f);
                break;
            }
            case 4: {
                GlStateManager.func_179109_b((float)-0.12f, (float)y, (float)-0.25f);
                break;
            }
            case 5: {
                GlStateManager.func_179109_b((float)0.12f, (float)y, (float)-0.25f);
            }
        }
        GlStateManager.func_179114_b((float)(tile.rotation + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        if (tile.allPlaced) {
            if (tile.flashTimer < 6 || tile.stayDark) {
                GlStateManager.func_179131_c((float)0.3f, (float)0.3f, (float)0.3f, (float)1.0f);
            } else {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (tile.flashTimer >= 10) {
                tile.flashTimer = 0;
            }
        }
        this.func_147499_a(tile.pokeballType[slot].getTextureLocation());
        BlockModelHolder<? extends ModelPokeballs> pokeball = SharedModels.getPokeballModel(tile.pokeballType[slot]);
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)60.6f);
        ModelPokeballs model = (ModelPokeballs)((Object)pokeball.getModel());
        model.theModel.setAnimation("idle");
        model.render(null, EntityPokeBall.scale);
        GlStateManager.func_179121_F();
    }
}

