/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.database.DatabaseMoves;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Moveset;
import com.pixelmonmod.pixelmon.enums.EnumType;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;

public class PixelmonMovesetData {
    public int attackIndex;
    public EnumType type;
    public int pp;
    public int ppBase;
    public boolean disabled = false;
    private Attack attack;

    public static PixelmonMovesetData create(Moveset moveset, int i) {
        if (moveset.size() <= i) {
            return null;
        }
        PixelmonMovesetData p = new PixelmonMovesetData();
        p.attackIndex = moveset.get((int)i).baseAttack.attackIndex;
        p.pp = moveset.get((int)i).pp;
        p.ppBase = moveset.get((int)i).ppBase;
        p.type = moveset.get((int)i).baseAttack.attackType;
        p.disabled = moveset.get(i).getDisabled();
        return p;
    }

    public static PixelmonMovesetData create(NBTTagCompound nbt, int i) {
        Attack a;
        if (nbt.func_74762_e("PixelmonNumberMoves") <= i) {
            return null;
        }
        PixelmonMovesetData p = new PixelmonMovesetData();
        if (!nbt.func_74764_b("PixelmonMoveID" + i)) {
            a = DatabaseMoves.getAttack(nbt.func_74779_i("PixelmonMoveName" + i));
            if (a == null) {
                return null;
            }
            p.attackIndex = a.baseAttack.attackIndex;
        } else {
            p.attackIndex = nbt.func_74762_e("PixelmonMoveID" + i);
            a = new Attack(p.attackIndex);
        }
        if (a.baseAttack == null) {
            return null;
        }
        p.type = a.baseAttack.attackType;
        p.pp = nbt.func_74762_e("PixelmonMovePP" + i);
        p.ppBase = nbt.func_74762_e("PixelmonMovePPBase" + i);
        return p;
    }

    public void writeData(ByteBuf data) {
        data.writeInt(this.attackIndex);
        data.writeShort(this.type.getIndex());
        data.writeShort(this.pp);
        data.writeShort(this.ppBase);
        data.writeBoolean(this.disabled);
    }

    public void readData(ByteBuf data) {
        this.attackIndex = data.readInt();
        this.type = EnumType.parseType(data.readShort());
        this.pp = data.readShort();
        this.ppBase = data.readShort();
        this.disabled = data.readBoolean();
    }

    public void updatePokemon(NBTTagCompound p, int i) {
        p.func_74768_a("PixelmonMoveID" + i, this.attackIndex);
        p.func_74768_a("PixelmonMovePP" + i, this.pp);
        p.func_74768_a("PixelmonMovePPBase" + i, this.ppBase);
    }

    public static PixelmonMovesetData createPacket(Attack a) {
        PixelmonMovesetData p = new PixelmonMovesetData();
        p.attackIndex = a.baseAttack.attackIndex;
        p.pp = a.pp;
        p.ppBase = a.ppBase;
        p.type = a.baseAttack.attackType;
        return p;
    }

    public Attack getAttack() {
        if (this.attack == null || this.attack.baseAttack.attackIndex != this.attackIndex) {
            this.attack = DatabaseMoves.getAttack(this.attackIndex);
        }
        return this.attack;
    }
}

